
function initMkeyMobile(NsddFileURL,NwebserviceURL){
	
	function MkeyMobile(TsddFileURL,TwebserviceURL){
		"use strict";
		var $ = jQuery;
		

		var sddFileURL = TsddFileURL;
		var webserviceURL = TwebserviceURL;
		
		
		var scoreMap = {};
		var descriptions = [];
		var discardedDescriptors = [];
		var discardedDescriptorsIdsForJSON = [];
		var remainingItems = [];
		var everyItems = [];
		var discardeditems = [];
		var remainingItemsIdsForJSON = [];
		var selectedStatesNames = [];
		
		var quantitativeMeasure = {};
		
		var active_states_count = 0;
		var descriptorsToSubmit = [];
		//Every Item in the dataset
		var items = [];
		//Every descriptor in the dataset
		var descriptors = [];
		//Every States in the dataset
		var states = [];
		//Every resources in the dataset
		var resources = [];
		//Warning rootNodes contains parentNodes which are not childNode
		var rootNodesID = [];
		//DependancyTree transcription
		//var dependancyTable = {};
		var sddName = "";
		
		var invertedDependancyTable = {};
		var selectedStatesIds = [];
		var numberOfDescriptor = 5;
		
		//Set language the navigator language by default
		try{
			var mkeyLang = new MkeyLang();
			//Set language the navigator language by default
			try{
				var language = window.navigator.userLanguage || window.navigator.language;
				mkeyLang.changeLang(language.slice(0,2));
			}
			catch(e){
				mkeyLang.changeLang("en");
			}
		}catch(e){
			alert("GRAVE : mkey_lang.js is undefined !!");
			return false;
		}
		
//		setWebserviceURL(NwebserviceURL);
//		setSddFileUrl(NsddFileURL,true);
		
		/**
		* debounce
		* @param {integer} milliseconds This param indicates the number of milliseconds
		* to wait after the last call before calling the original function .
		* @return {function} This returns a function that when called will wait the
		* indicated number of milliseconds after the last call before
		* calling the original function.
		*/
		Function.prototype.debounce = function (milliseconds) {
		    var baseFunction = this,
		        timer = null,
		        wait = milliseconds;
		
		    return function () {
		        var self = this,
		            args = arguments;
		
		        function complete() {
		            baseFunction.apply(self, args);
		            timer = null;
		        }
		
		        if (timer) {
		            clearTimeout(timer);
		        }
		
		        timer = setTimeout(complete, wait);
		    };
		};
		
		function onResize(){
			
		    var screenHeight = $(window).height();
		    var screenWidth = $(window).width();
		    
		//    $("#bigImg").popup("close");
		//    $("#bigImg img").css("max-height",(screenHeight-47-40));
		    
		    $("body").css("height",$("body").css("min-height"));
		    
		    if ($('html').hasClass('lte9')) return;
		    
		    $('.block-full-height').each(function(){
		        
		        var offsetR = parseInt($(this).offset().top)
		                   + $('footer').height();
		//        if ($('#content').hasClass('descriptor-submittable'))
		//            offset += parseInt($('#btnSubmit').css('height').replace('px', '')) + 11;
		        $(this).height(screenHeight - offsetR);
		        
		    });
		
		    var w = screenWidth - (getRealWidth($($("a.brand")[0])) + getRealWidth($($("a.share")[0]))) - 4;
		    $("#submitContainer").css("width",w);
		    
		}
		
		
		    
		$(document).ready(function(){
			$("bigImg").popup();
			$.mobile.loading( 'show' );
			$(window).resize(function(){
				onResize();
				return false;
			});
			
			$(window).on("dragstart",function(){
				return false;
			});	
			
		    onResize();
		//    $(window).resize(onResize.debounce(150));
		
		    // Tabs
		    $('#tabs a').click(function(e){
		        e.preventDefault();
		        
		        var $target = $(e.target);
		        if ($target.not('a'))
		            $target = $target.closest('a');
		        $('#content .block').removeClass('active').filter($target.attr('href')).addClass('active');
		        $('#tabs li').removeClass('active');
		        $(this).parent('li').addClass('active');
		        
		        onResize();
		    });
		    
		  //Set clickEvent, reset identification
			$('#reset_identification').click(function(){
				descriptions = [];
				descriptorsToSubmit = [];
				changeDescriptionHistory();
			});
		    
		    // Identification
		    var $content = $('#content'),
		        $submit = $('#btnSubmit'),
		        $history_tab = $('#tab-id-history'),
		        $items_list_tab = $('#tab-id-items-list'),
		        $items_list = $('#block-id-items-list');
		
		
		//    getDescriptiveData();
		    
			
			
			$("#msg-no-descriptor-left a").click(function(){
				var href = $(this).attr("href");
				if ( href == "#" ){	
					descriptions = [];
					changeDescriptionHistory();
				}
				else {
					$("#tabs li").removeClass("active");
					$(".block").removeClass("active");
					if ( href == "#block-id-items-list" ){
						$("#tab-id-items-list").addClass("active");
					}
					$(href).addClass("active");
				}
			});
			
		    // Validation d'un descripteur
		    $submit.click(function(e){   
		    	
//				e.preventDefault();
//				e.stopPropagation();
//				var descriptor = descriptors[parseInt($submit.attr("data-descriptor_id"))];
//				submitDescription(descriptor);
				
//				$submit.attr('data-descriptor_id',-1);
				$content.removeClass('descriptor-submittable');
		
//			    e.preventDefault();
//		        e.stopPropagation();
		        submitDescription(descriptorsToSubmit);
		        descriptorsToSubmit = [];
				
				onResize();
		
		        $history_tab.find('.number').text(descriptions.length);
		        $items_list.find('.block-title .number-remaining').text(remainingItems.length);
		        $items_list.find('.block-total .number-total').text(items.length);
		        $items_list_tab.find('.number').text(remainingItems.length);
		        $submit.fadeOut();
		        return false;
		    });
		    
		    $("#block-id-descriptors").on("click","img",function(){
		    	//Hide the card Item modal 
		    	$("#id-item-card").empty().hide();
		    	
		    	var copyImg = $(this).clone();
		    	copyImg.removeAttr("style");
		    	createBigImg(copyImg,$("#bigImg"));
		    	return false;
		    });
		    
		//    $.event.special.swipe.durationThreshold = 2000;
		//    $.event.special.swipe.horizontalDistanceThreshold = 10;
		//    $.event.special.swipe.verticalDistanceThreshold= 100;
		    
		    $("#id-item-card").on("swipeleft",function(event){
		    	$(".modal-control.right").click();
		    	return false;
		    });
		    
		    $("#id-item-card").on("swiperight",function(event){
		    	$(".modal-control.left").click();
		    	return false;
		    });
		    
		    //Start Identification
		    getDescriptiveData();
		    
		});
		
		/**
		 * Basic Function used to get every Data contained in the SDD
		 * @param callback, function to be back called
		 */
		function getDescriptiveData(callback) {
		
			$.ajax({
				url : webserviceURL + '/identification/getDescriptiveData',
				data : {sddURL : sddFileURL,
					    withGlobalWeigth : true
					    },
				method : 'GET',
				dataType : 'jsonp'
		
			}).done(function(data) {
				try{
					everyItems = data.Items;
					items = data.Items;
					descriptors = data.Descriptors;
					states = data.States;
					resources = data.Resources;
					rootNodesID = data.DescriptorRootId;
		//			dependancyTable = data.DependancyTable;
					invertedDependancyTable = data.InvertedDependancyTable;
					scoreMap = data.descriptorsScoreMap;
					sddName = data.NameDataset;
					

					//Escap spe character
					escapeCharacter();
					
					document.title = sddName;
					$(".base-name").html(sddName);
					var $items_list = $('#block-id-items-list');
			        $items_list.find('.block-title .number-remaining').text(items.length+"  ");
			        $items_list.find('.block-total .number-total').text(items.length);
			        $('#tab-id-items-list').find('.number').text(items.length);
					
					$.each(items, function(index, item) {
						createRemainingItem(item);
						remainingItemsIdsForJSON.push(item.id);
					});
					
					displayDescriptorSelect();
					
					if( document.title.length == 0 ){
						document.title = data.NameDataset;
					}
					
					//Hide the Load Event
					$.mobile.hidePageLoadingMsg();
					if ( callback != undefined ){
						callback();
					}			
					
				}
				catch(err){
					alert(err);
				}
			});
		}
		
//		function setSddFileUrl(urlSdd,reloadIdentification){
//			sddFileURL = urlSdd;
//			var bol = isBoolean(reloadIdentification);
//			if ( bol != undefined && bol){
//				getDescriptiveData();
//			}
//		}
		
		//Basic Function, call Mkey+ api with the description and the current remaining Item and descriptor
		function getRemainingItemsAndRemainingDescriptors(descList) {		
			$.mobile.showPageLoadingMsg();
			
			$.ajax({
				url : webserviceURL+ '/identification/getRemainingItemsAndDescriptorsUsingIDs',
				data : {
					sddURL : sddFileURL,
					descriptions : JSON.stringify(descList),
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON),
					withScoreMap : true,
					discardedDescriptorsIDs : JSON.stringify(discardedDescriptorsIdsForJSON),
					withGlobalWeigth : true
				},
				method : 'GET',
				dataType : 'jsonp'// ,
				}).done(function(data) {
		//			remainingDescriptors = data.remainingDescriptors;
					scoreMap = data.descriptorScoreMap;
					remainingItems = data.remainingItems;
					
					remainingItemsIdsForJSON = [];
					$.each(remainingItems, function(index, item) {
						remainingItemsIdsForJSON.push(item.id);
					});
					
					var discardedDescriptorsInIteration = data.discardedDescriptorsInIteration;
					// discardedDescriptorsNamesForJSON = [];
					$.each(discardedDescriptorsInIteration, function(index,descriptorIn) {
						discardedDescriptors.push(descriptorIn);
						discardedDescriptorsIdsForJSON.push(descriptorIn.id);
					});
		
					$('#block-id-items-list').find('.block-title .number-remaining').text(remainingItems.length+" ");
		//	        $items_list.find('.block-total .number-total').text(items.length);
			        $('#tab-id-items-list').find('.number').text(remainingItems.length);
					
					// Add by antoine
					updateItemInformation(remainingItems);
		
					// reset input list of descrpitor
					displayDescriptorSelect();
					
					//sort item
					sortItemRemainingDiscarded();
					
					$.mobile.hidePageLoadingMsg();
				}).fail(function(jqXHR, textStatus) {
					$.mobile.hidePageLoadingMsg();
				});
		}
		
		/**
		 * This function is fired every time the UI is updated.
		 * This function, sort the descriptor and display them with the rowDisplay or default display
		 * Do not use this function (prefer reloadDescriptorUI() function
		 */
		function displayDescriptorSelect() {
			
			//Show or hide the descriptions help
			if ( descriptions.length == 0 ){
				$("#msg-no-description").css("display","block");
			}
			else{
				$("#msg-no-description").css("display","none");
			}
			
			//Create the Descriptor List param is the number of descriptor to display
			var sortedListDescriptorId = sortDescriptorScore(numberOfDescriptor);
			$('#numberOfDescriptor').html(sortedListDescriptorId.length+" ");
			$('#id-descriptors-list').empty();
			
			
			
			$.each(sortedListDescriptorId,function(index,descriptorID){
				createDescriptorDiv(descriptors[descriptorID]);
			});
			
		}
		
		//Sort n descriptors depending on their score ( Higth to low )
		function sortDescriptorScore(nIndex){	
			var sortedDescriptorList = [];
			var tmpIndex = -1;
			var max = -1;
			for (var i=0;i<nIndex;i++){ 
				$.each(scoreMap,function(index,score){
					if (!isParentDescriptorDiscardedAndInaplicable(descriptors[index])){
						if ( $.inArray(index,sortedDescriptorList) < 0 && score > 0 &&  score >= max){
							max = score;
							tmpIndex = index;
						}
					}
				});
				if (tmpIndex != -1 ){
					sortedDescriptorList.push(tmpIndex);
				}
				tmpIndex = -1;
				max = -1;
			}
			
			//Fire End identification
			if ( sortedDescriptorList.length == 0 ){	
				$("#msg-no-descriptor-left").css("display","block");
			}
			else{
				$("#msg-no-descriptor-left").css("display","none");
			}
			return sortedDescriptorList;
		}
		
		
		/**
		 * Warning : If QuantitativeMeasure == undefined, the description results will have no field quantitativeMeasure
		 * Recompute the entire Description History
		 * @param callback
		 */
		function changeDescriptionHistory(callback){
			$.mobile.showPageLoadingMsg();
			$.ajax({
				url : webserviceURL+ '/identification/changeDescriptionHistory',
				data : {
					sddURL : sddFileURL,
					descriptions : JSON.stringify(descriptions)
				},
				method : 'GET',
				dataType : 'jsonp'// ,
				}).done(function(data) {
		//			remainingDescriptors = data.remainingDescriptors;
					remainingItems = data.remainingItems;
					discardedDescriptors = data.discardedDescriptors;
					
					descriptions = data.descriptions;
					
		//			remainingDescriptors = data.remainingDescriptors;
					scoreMap = data.descriptorScoreMap;
					remainingItems = data.remainingItems;
					everyItems = items;
					
					remainingItemsIdsForJSON = [];
					$.each(remainingItems, function(index, item) {
						remainingItemsIdsForJSON.push(item.id);
					});
					
					discardedDescriptorsIdsForJSON = [];
					$.each(discardedDescriptors, function(index,descriptorIn) {
						discardedDescriptorsIdsForJSON.push(descriptorIn.id);
					});
		
					discardeditems = [];
					//reset Class items
					$("#remainingItemList li.eliminated").removeClass("eliminated").addClass("remaining");
					
					// Add by antoine
					updateItemInformation(remainingItems);
		
					// reset input list of descrpitor
					displayDescriptorSelect();
					
					//sort item
					sortItemRemainingDiscarded();
					
					$('#id-history-descriptorsList').empty();
					
					//Recreate description block
					$.each(descriptions,function(index,description){
						creatHistoryEntry(description,index);
					});
					
					
		//			var $items_list = $('#block-id-items-list');
					$('#block-id-items-list').find('.block-title .number-remaining').text(remainingItems.length+" ");
		//	        $items_list.find('.block-total .number-total').text(items.length);
			        $('#tab-id-items-list').find('.number').text(remainingItems.length);
					
			        $('#tab-id-history').find('.number').text(descriptions.length);
			        
			        $.mobile.hidePageLoadingMsg();
					if ( callback != undefined ){
						//fire callback
						callback();
					}
				});
		}
		
		function isNumber(n) {
			 return !isNaN(parseFloat(n)) && isFinite(n);
		}
		
		
		function escapeCharacter(){
			//descriptors
			for ( var i = 0 ; i < descriptors.length ; i++){
				descriptors[i].name = $("<esc/>").text(descriptors[i].name).html();
//				descriptors[i].detail = $("<esc/>").text(descriptors[i].detail).html();
			}
			//Item
//			for ( var i = 0 ; i < items.length ; i++ ){
//				items[i].name = $("<esc/>").text(items[i].name).html();
//				items[i].detail = $("<esc/>").text(items[i].detail).html();
//			}
			//State
//			for ( var i = 0 ; i < states.length ; i++ ){
//				states[i].name = $("<esc/>").text(states[i].name).html();
//				states[i].detail = $("<esc/>").text(states[i].detail).html();
//			}
		}
		
		//Retun true if inaplicable state is selected in the parentDescriptor or return
		//true if the parentDescriptor is not yet discarded
		function isParentDescriptorDiscardedAndInaplicable(currentDescriptor) {
			var inap = false;
			var isDiscarded = false;
			var allwaysShown = false;
		//
			// for each rootNode descriptor that are allways shown
			$.each(rootNodesID, function(index, rootID) {
				if (rootID == currentDescriptor.id) {
					allwaysShown = true;
					// break the $.each iteration
					return false;
				}
			});
			// if the first if as returned false
			if (!allwaysShown){
				//If currentDescriptor is a child descriptor
				if ( invertedDependancyTable[currentDescriptor.id] != undefined){
					var parentDescriptorID = invertedDependancyTable[currentDescriptor.id];
					$.each(discardedDescriptors,function(index,descriptorDescarded){
						//The parend Descriptor of this child has been selected
						if ( descriptorDescarded.id == parentDescriptorID ){
							isDiscarded = true;
							$.each(descriptions,function(index1,description){
								if ( description.descriptor.id == parentDescriptorID ){
									var inapplicableStateIDs = currentDescriptor.inapplicableState;
									$.each(description.selectedStates, function(index2,selectedState) {
										$.each(inapplicableStateIDs,function(index3,inapplicableStateID){
											// if there is one inaplicable state selected in
											// the description
											if (states[selectedState].id == inapplicableStateID) {
												// then inaplicable state is detected
												inap = true;
												// break the $.each iteration
												return false;
											}
										});
										if ( inap ){
											// break the $.each iteration
											return false;
										}
									});
		
									// break the $.each iteration
									return false;
								}
							});
							//break the $.each
							return false;
						}
					});
				}
			}
			else{
				return !allwaysShown;
			}
			if ( isDiscarded ){
				return inap;
			}
			
			return !isDiscarded;
		}
		
		
		
		
		//Get the remaining Items if this state is selected and submited by the user,
		//then append the HTML code for the check box in the interface
		//Warning as the ajax request can only be performed async=true, the HTML result
		//could not be write any where else.
		function getRemainingItems(state,descriptor,row) {
			selectedStatesNames = [];
			selectedStatesNames.push(state.name);
			selectedStatesIds = [];
			selectedStatesIds.push(state.id);
		
			var descList = [];
			var descriptionElementStateJSON = {
				selectedStatesNames : selectedStatesIds,
				quantitativeMeasure : quantitativeMeasure
			};
			var descriptionJSON = {};
			var selectedDescriptor = descriptor;
		
			descriptionJSON[selectedDescriptor.id] = descriptionElementStateJSON;
			descList.push(descriptionJSON);
		
			$.ajax({url : webserviceURL+ '/identification/getRemainingItemsAndDescriptorsUsingIDs',
				method : 'GET',
				dataType : 'jsonp',
				data : {
					sddURL : sddFileURL,
					descriptions : JSON.stringify(descList),
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON),
					withScoreMap : false,
					discardedDescriptorsIDs : JSON.stringify(discardedDescriptorsIdsForJSON),
					 withGlobalWeigth : true
				}
			}).done(function(data) {
				creatState(state,descriptor,data.remainingItems.length,row);
			});
		}
		
		
		
		function isBoolean(testBol){
			var bol = undefined;
			if ( testBol == "false" ){
				bol = false;
			}
			else if(testBol == "true"){
				bol = true;
			}
			else if ( testBol == true || testBol == false){
				bol = testBol;
			}
			return bol;
		}
		
		
		
		//Fire by the submit Button, create the History entry, fire the mkey+ api getRemainingItem
		function submitDescription(descriptorsSubmited) {
			//reset active_states
			active_states_count = 0;
			var submittedDescription = [];
			
			for ( var i = 0 ; i < descriptorsSubmited.length ; i++ ){
				var selectedDescriptor = descriptors[descriptorsSubmited[i]];
				selectedStatesIds = [];
				quantitativeMeasure = undefined;
				
				
				
				if (selectedDescriptor.categoricalType) {
					var $states = $('#D'+selectedDescriptor.id).nextUntil('.descriptor');
					$.each($states, function(index,state) {
							if ($(state).hasClass("active") ){
								selectedStatesIds.push(parseInt($(state).attr("data-stateid")));
							}
					});
				} else if (selectedDescriptor.quantitativeType) {
					quantitativeMeasure = {
						value : $('.state.numerical.active').find('input[name=numerical_value]').val()
					};
				}
				
//		        var $parent_descriptor = $('#D'+selectedDescriptor.id);
//		        $parent_descriptor.nextUntil('.descriptor').remove();
//		        $parent_descriptor.remove();
				
				
				// Create a new description
				var description = {
					descriptor : selectedDescriptor,
					selectedStates : selectedStatesIds,
					quantitativeMeasure : quantitativeMeasure
				};
				
				
				var descriptionElementStateJSON = {
						selectedStatesNames : selectedStatesIds,
						quantitativeMeasure : quantitativeMeasure
				};
				var descriptionJSON = {};
		
				descriptionJSON[selectedDescriptor.id] = descriptionElementStateJSON;
				
				//Create the description to submit
				submittedDescription.push(descriptionJSON);
				
				// add the description in Descriptions (to be save)
				descriptions.push(description);
				
				//Creat the Html
				creatHistoryEntry(description);			
			}
			
			getRemainingItemsAndRemainingDescriptors(submittedDescription);
		}
		 
		
		//Update the List of discardedItems
		function updateItemInformation(remainingItemsIn){
			var tmp_every = [];
			// construct the discardeditems list
			$.each(everyItems, function(index, item) {
				var bol = false;
				$.each(remainingItemsIn, function(rindex, ritem) {
					if (item.id == ritem.id) {
						tmp_every.push(item);
						bol = true;
						return false;
					}
				});
				if (!bol) {
					$("#I"+item.id).removeClass('remaining').addClass('eliminated');
					$("#I"+item.id).addClass('item_D');
					$("#I"+item.id).attr('indexDel',descriptions.length);
					discardeditems.push(item);
				}
			});
			//Update the Number of remaining item
			$('#numberOfRemainingItem').html(remainingItemsIn.length+"  ");
			everyItems = tmp_every;
		}
		
		
		//Sort the Item list ( remaining Up, eliminated down )
		function sortItemRemainingDiscarded(){
			$('#remainingItemList > .eliminated').detach().appendTo('#remainingItemList');
			
		}
		
		
		//Get The Next / prev Image in the carousel ( next/prev are in the view list order )
		function getItemCarousel(itemID,pas){
			if ( pas > 0){
				var next = $('li#I'+itemID).next();
				if ( next.length != 0 ){
					var idStr = next[0].id;
					idStr =  idStr.substr(1,idStr.length);
					createCardItem(items[idStr],$('#id-item-card'));
				}
			}
			else{
				var prev = $('li#I'+itemID).prev();
				if ( prev.length != 0 ){
					var idStr = prev[0].id;
					idStr =  idStr.substr(1,idStr.length);
					createCardItem(items[idStr],$('#id-item-card'));
				}
			}
		}
		
		
		function getRealWidth(element){
			var mw = parseInt(element.css("margin-left")) + parseInt(element.css("margin-right"));
			mw += parseInt(element.css("padding-left")) + parseInt(element.css("padding-right"));
			mw += parseInt(element.css("width"));
			return mw;
		}
		
		
		//Create the State description under each descriptor
		//( numberOfItem is the remaining number of items left if this descriptor is choosen )
		function creatState(state,descriptor,numberOfItem,row,isHistory){
			var stringToAppend = '';
			var $content = $("#content");
			var classe = "";
			var numberOfitemStr = "";
			var style = "";
			var relativeScore = Math.round((1 - (numberOfItem/everyItems.length)) *100);
		//	if ( graphicDisplayRemainingItem ){
				style = getStyle(relativeScore);
		//	}
		//	else{
		//		if ( numberOfItem == 0 ){
		//			classe = "invalidDescriptor'";
		//		}
		//	}
			
			if ( numberOfItem >= 0){
				numberOfitemStr = "("+numberOfItem+")";
			}
			
			row.addClass(classe);
		//	toAppend +=	"<tr class='state "+classes+" ' data-descriptorid=S"+descriptor.id+" data-stateid="+state.id+" >";
		//	toAppend += "</tr>";
			stringToAppend += "<td class='picture'>";
			//If ressources
			var rIds = state.resourceIds;
			if ( rIds.length > 0  ){
				stringToAppend += "<img src='"+ resources[rIds[0]].url +"' alt='"+state.name+"' class='min-picture' onerror='this.onerror=null;this.src=\"http://xper3.com/resources/img/defaultThumbnail.png\";' />";
			}
			else{
				stringToAppend += "<img src='http://xper3.com/resources/img/defaultThumbnail.png' class='min-picture' />";
			}
			stringToAppend += "</td>";//End picture
			stringToAppend += "<td class='state-text' >";
			stringToAppend += "<strong class='state-title'>"+state.name+"</strong><br /><div style="+style+"></div><span style='clear:rigth;'>"+numberOfitemStr+"</span>";
			if ( state.detail != null && state.detail != "null" && state.detail != "_"){
				stringToAppend += "<p>"+state.detail+"</p>";
			}
			stringToAppend += "</td>";//End state-text
			stringToAppend += "<td class='button'></td>";
		
			row.append(stringToAppend);
			
			
			//bind Event
			var bol = isBoolean(isHistory);
			if ( bol != undefined && bol ){
				row.click(function(){	  
				      $(this).toggleClass('active');		   
				  });
			}
			//Case for Default interface div design
			else{
				// Selection des etats
				row.click(function(){
				      active_states_count += ($(this).hasClass('active') ? -1 : 1);
				      $(this).toggleClass('active');
				      // Afficher / masquer le bouton Submit
				      if (active_states_count > 0) {
				    	  $content.addClass('descriptor-submittable');
				    	  $("#btnSubmit").fadeIn();
				      } else {
				    	  $("#btnSubmit").fadeOut();
				    	  $content.removeClass('descriptor-submittable');
				      }
				      
				      if (  $('#D'+descriptor.id).nextUntil('.descriptor').hasClass("active") ){
				    	//add the descriptor ID in the Described descriptor
				    	  if ( descriptorsToSubmit.indexOf(descriptor.id) < 0 ){
				    		  descriptorsToSubmit.push(descriptor.id);
				    	  }
				      }else{
				    	//remove the descriptor ID in the Described descriptor
				    	  if ( descriptorsToSubmit.indexOf(descriptor.id) >= 0 ){
				    		  descriptorsToSubmit.splice(descriptorsToSubmit.indexOf(descriptor.id),1);
				    	  }
				      }
				      
				      return false;
				  });
			}
		}
		
		function getStyle(score){	
			var cssStr = "";
			cssStr += "border-radius:10px;";
			cssStr += "clear:both;";
			cssStr += "display:inline-block;";
			cssStr += "vertical-align:text-bottom;";
			cssStr += "width:100px;";
			cssStr += "height:16px;";
			cssStr += "background:rgb(160,202,84);";
			cssStr += "background:-moz-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
		//	cssStr += "background:-webkit-gradient(linear,left top,right top,color-stop(0%,rgba(160,202,84,1)),color-stop(27%,rgba(255,255,255,1)));";
			cssStr += "background:-webkit-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
			cssStr += "background:-o-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
			cssStr += "background:-ms-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
		//	cssStr += "background:linear-gradient(to right,rgba(160,202,84,1)0%,rgba(255,255,255,1)27%);";
			cssStr += "filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#a0ca54',endColorstr='#f3f7f8',GradientType=1);";
			return cssStr;
		}
		
		
		function createBigImg(img,container){
			container.unbind("swipeleft");
			container.unbind("swiperight");
			container.find("img").remove();
			container.find(".modal-controls").remove();
			container.append(img);
			container.popup("open");
		}
		
		function createBigImgs(imgs,title,container){
			container.unbind("swipeleft");
			container.unbind("swiperight");
			
			var currentImgPositionInArray = 0;
			
			container.find("img").remove();
			container.find(".modal-controls").remove();
			
			container.append(imgs[currentImgPositionInArray]);
			
			var pagination = $('<div class="pagination"><span class="current">'+(currentImgPositionInArray+1)+'</span>/<span class="total">'+imgs.length+'</span></div>');
		
			
			//Bind swipe Event
			container.on("swiperight",function(event){
		    	if ( (currentImgPositionInArray - 1) > -1 ){
		    		imgs[currentImgPositionInArray].detach();
		    		currentImgPositionInArray -= 1;
		    		container.append(imgs[currentImgPositionInArray]);
		    		control.detach();
		    		pagination.find(".current").html(currentImgPositionInArray+1);
		    		container.append(control);
		    	}
		    	return false;
		    });
		    
			container.on("swipeleft",function(event){
		    	if ( (currentImgPositionInArray + 1) < imgs.length ){
		    		imgs[currentImgPositionInArray].detach();
		    		currentImgPositionInArray += 1;
		    		container.append(imgs[currentImgPositionInArray]);
		    		control.detach();
		    		pagination.find(".current").html(currentImgPositionInArray+1);
		    		container.append(control);
		    	}
		    	return false;
		    });
			
			var control = $('<div class="modal-controls"></div>');
			
			var left = $('<a class="modal-control left"  >&lsaquo;</a>');
			left.click(function(){
				container.trigger("swiperight");
				return false;
			});
			var right = $('<a class="modal-control right" >&rsaquo;</a>');
			right.click(function(){
				container.trigger("swipeleft");
				return false;
			});
			
			control.append(left);
			control.append(right);
			control.append(pagination);
			
			
			container.append(control);
		    
			container.popup("open");
		}
		
		function createCardItem(item,container){	
			//Hide the bigImg modal
			$('#bigImg').popup("close");
			
			
			var resource = item.resourceIds;
			container.empty();
			
			var toAppend =  '<div class="modal-header">';
		    toAppend += '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>';
		    toAppend +=  '<h3 id="id-item-card-label">'+item.name+'</h3>';
		    if ( $('li#I'+item.id).hasClass('remaining') ){
		    	toAppend +=  '<span class="id-item-card-status">– ' + mkey.mkeyLang.getMessage("message_remaining") + '</span>';
		    }
		    else{
		    	toAppend +=  '<span class="id-item-card-status">– ' + mkey.mkeyLang.getMessage("message_discarded") + '</span>';
		    }
		    toAppend += '</div>';//End Header
		    toAppend += '<div class="modal-body">';
		    
		    toAppend += ' <div id="id-item-card-carousel" class="carousel"> ';
		    if ( resource.length > 0 ){
		    	var currentResource = resources[resource[0]];
		    	if ( currentResource.type == "image" ){
					  toAppend += '<div class="active item" draggable="false" ><img src="'+currentResource.url+'" alt="'+item.name+'" draggable="false" /></div>';
				  } 
			  	  else{
			  		  alert("display error, resource is not an image");
			  	  }
		    }else{
		    	stringToAppend += "<img src='http://xper3.com/resources/img/defaultThumbnail.png' class='min-picture' />";
		    	toAppend += '<div class="active item" draggable="false" ><img src="http://xper3.com/resources/img/defaultThumbnail.png" draggable="false"/></div>';
		    }
		    toAppend += '<span class="message carousel-control" data-message="message_clicktoview"></span>';
		    toAppend += '</div>'; //End id-item-card-carousel
		    
		    
		    if ( item.detail != "null" && item.detail != "_" ){
		    	toAppend += "<div class='detail_item_carousel'>";
		    	toAppend += item.detail;
		    	toAppend += "</div>";
		    }
		    
		    toAppend += '<dl id="description-card-item">';
		    toAppend += '</dl>' ;
		    toAppend += '</div>';//end modal-body
		    
		    
		    toAppend += '<div class="modal-controls">';
		    toAppend += '<a id="gcleft" class="modal-control left" >&lsaquo;</a>';
		    toAppend += '<a id="gcright" class="modal-control right">&rsaquo;</a>';
		    toAppend += '<div class="pagination"><span class="current">'+(item.id + 1)+'</span>/<span class="total">'+items.length+'</span></div>';
		    toAppend += '</div>';
		    
		    container.append(toAppend);
		    
		
			var elementSecondary = $('#description-card-item');
			elementSecondary.addClass("whiteWaitCard");
		    try{
		    	createDescription(item,elementSecondary);
		    	elementSecondary.removeClass("whiteWaitCard");
		    }
		    catch(err){
		    	elementSecondary.removeClass("whiteWaitCard");
		    	alert(err);
		    }
		    
		    $('#id-item-card .close').click(function(){
		    	$("#id-item-card").empty().hide();
		    	return false;
		    });
		    
		    //Lazy ressources instanciation
		    var resourcesToShow = [];
		    for ( var i=0; i<resource.length;i++){
		    	var currentResource = resources[resource[i]];
		    	resourcesToShow[i] = $('<img src="'+currentResource.url+'" alt="'+item.name+'" draggable="false" />');
		    	resourcesToShow[i].error(function(){
		    		resourcesToShow.splice(i,i+1);
		    		return false;
		    	});
		    }	
		    	
		    $("#id-item-card-carousel").click(function(){
		    	createBigImgs(resourcesToShow,item.name,$("#bigImg"));
		    	return false;
		    });
		    
		    $("#gcleft").click(function(){
		    	getItemCarousel(item.id,-1);
		    	return false;
		    });
		    $("#gcright").click(function(){
		    	getItemCarousel(item.id,1);
		    	return false;
		    });
		    
		    mkeyLang.updateLang("#id-item-card");
		    container.show();
		    $.mobile.hidePageLoadingMsg();
		}
		
		/**
		 * Create the description in the Item card display
		 * @param descriptionElements
		 */
		function createDescription(item,element){
			$.mobile.showPageLoadingMsg();
		    $.ajax({
				url : webserviceURL +'/identification/getDescription',
				data : {
					sddURL : sddFileURL,
					itemName : item.name
				},
				method : 'GET',
				dataType : 'jsonp'
			}).done(function(data) {
				var descriptionElements = data.description;
				var innapDescriptorId = data.innapDescriptorId;
				
				$.each(descriptionElements,function(index,descriptionElement){
					var toAppendDesc = "";
					toAppendDesc += "<dt>";
					toAppendDesc += descriptors[descriptionElement.id].name;
					toAppendDesc += "</dt>";
					toAppendDesc += "<dd>";
					if ( !descriptionElement.unknown ){
						//Categorical states
						if ( descriptionElement.states != null && descriptionElement.states.length > 0){
							
							toAppendDesc += "<ul>";
							for ( var i=0; i < descriptionElement.states.length ; i++){
								var state = descriptionElement.states[i];
								toAppendDesc += "<li>";
								toAppendDesc += state.name;
								toAppendDesc += "</li>";
							}
							toAppendDesc += "</ul>";
						}
						//Quantitative states
						else if ( descriptionElement.quantitativeMeasure != null ){
							var quantitativeMeasureDesc = descriptionElement.quantitativeMeasure;
							if ( quantitativeMeasureDesc.min != null || quantitativeMeasureDesc.max != null || quantitativeMeasureDesc.mean != null || quantitativeMeasureDesc.sd != null){
								toAppendDesc += "[min,max] = ["+quantitativeMeasureDesc.min+","+quantitativeMeasureDesc.max+"]<br />";
								toAppendDesc += "mean = "+quantitativeMeasureDesc.mean+"<br />";
								toAppendDesc += "sd = "+quantitativeMeasureDesc.sd;
							}
							else{
								toAppendDesc += "<span class='description-text-notdescribed'>not described</span>";
							}
						}
						//calculated States
						else if( descriptionElement.calculatedStates != null && descriptionElement.calculatedStates.length > 0 ){
							var calculatedStates = descriptionElement.calculatedStates;
							toAppendDesc += "<ul>";
							for ( var i=0; i < calculatedStates.length ; i++){
								var calculatedState = descriptionElement.calculatedStates[i];
								toAppendDesc += "<li>";
								toAppendDesc += calculatedState.name;
								toAppendDesc += "</li>";
							}
							toAppendDesc += "</ul>";
						}
						else{
							var indexToDel = isDescriptorApplicable(descriptors[descriptionElement.id],innapDescriptorId);
							if ( indexToDel > -1){
								innapDescriptorId.slice(indexToDel,1);
								toAppendDesc += "<span class='description-text-inapplicable'>" + mkey.mkeyLang.getMessage("message_inapplicable") + "</span>";
							}
							else{
								toAppendDesc += "<span class='description-text-notdescribed'>" + mkey.mkeyLang.getMessage("message_notDescribed") + "</span>";
							}
						}
					}
					else{
						toAppendDesc += "<span class='description-text-unknown'>" + mkey.mkeyLang.getMessage("message_unknown") + "</span>";
					}
					toAppendDesc += "</dd>";
					element.append(toAppendDesc);
				});
				$.mobile.hidePageLoadingMsg();
			}).fail(function(jqXHR, textStatus) {
				$.mobile.hidePageLoadingMsg();
			});
			
		}
		
		//Create the Item List (called Once)
		function createRemainingItem(item){
			var itemHTML = $("<li indexDel='-1' class='remaining' id=I"+item.id+"><a href='#'>"+item.name+"</a></li>");
			$('#remainingItemList').append(itemHTML);
			
			//Bind event Open carousel
			itemHTML.click(function(e){
			      e.preventDefault();
			      createCardItem(item,$("#id-item-card"));
		//	      $("#tabs .active").removeClass("active");
			  });
		}
		
		
		/**
		 * Create a default style descriptor div, contained in the Descriptor Block ( left )
		 * @param descriptor
		 * @param addMode Integer, 0 == append ( default ) , 1 == prepend
		 */
		function createDescriptorDiv(descriptor,addMode){
			var $content = $("#content");
			var $submit = $("#btnSubmit");
			var scoreStr = "";
			//Array containing all the dom created
			var arrayDesc = [];
			
			
			var descriptorTR = $("<tr class='descriptor' id=D"+descriptor.id+"></tr>");
			
			var toAppend = "<td class='picture'>";
		
			//If ressources
			var dIds = descriptor.resourceIds;
			if ( dIds.length > 0  ){
				toAppend += "<img draggable='false' src='"+ resources[dIds[0]].url + "' alt='"+descriptor.name+"' onerror='this.onerror=null;this.src=\"http://xper3.com/resources/img/defaultThumbnail.png\";' style='max-width: 140px;' />";
			}
			else{
				toAppend += "<img draggable='false' src='http://xper3.com/resources/img/defaultThumbnail.png' style='max-width: 140px;' />";
			}
			toAppend += "</td>";//End Td img
			toAppend += "<td class='descriptor-text'>";
		
			//Descriptor name
			toAppend += "<strong class='descriptor-title'>"+descriptor.name+"</strong>"+scoreStr;
			if ( descriptor.detail != null && descriptor.detail != "null" && descriptor.detail != "_"){
				toAppend += "<p>"+descriptor.detail+"</p>";
			}
			toAppend += "<div class='descriptor-operators'>";	
		
			//		<a href="#" class="active">AND</a> / <a href="#">OR</a> / <a href="#">XOR</a> / <a href="#">NOT</a> / <a href="#">NOR</a> / <a href="#">NXOR</a>
			toAppend += "</div>";//end descriptor-operator
			toAppend += "</td>";//End Descriptor-text
			toAppend += "<td class='button'></td>";//Submit button
			
			descriptorTR.append(toAppend);//End descriptor row
			
			
		
			arrayDesc.push(descriptorTR);
			$('#id-descriptors-list').append(descriptorTR);
		
			
			//List states add FOR
			//if descriptor is categorical
			if ( descriptor.categoricalType ){
				
				$.each(descriptor.stateIds,function(index,stateID){
		//			data-descriptorid='"+descriptor.id+"'
						var newRow = $("<tr class='state' data-stateid='"+states[stateID].id+"'></tr>");
						//Add the row in the Array
						arrayDesc.push(newRow);
						$('#id-descriptors-list').append(newRow);				
						getRemainingItems(states[stateID],descriptor,newRow);
				});
				
			}
			//if quantitativeType (test)
			else if (descriptor.quantitativeType ) {
				descriptorTR.addClass("numerical");
				var newRow = $('<tr class="state numerical"></tr>');
				
				toAppend = '<td class="picture"></td>';
				toAppend += '<td class="state-text">';
				toAppend += '<input type="number" min="0" step="0.5" value="" name="numerical_value" style="width: 50px">'+descriptor.unit;
				toAppend += ' </td>';
				toAppend += ' <td class="button"></td>';
		//		toAppend += ' </tr>';
				
				newRow.append(toAppend);
				//Add the row in the Array
				arrayDesc.push(newRow);
		        $('#id-descriptors-list').append(newRow);
		        
		        //Bind Event
		        newRow.find('input[name=numerical_value]').keyup(function(){
		        	if ($.isNumeric($(this).val())) {
		        		$submit.fadeIn();
		        		newRow.addClass('active');
		        		$content.addClass('descriptor-submittable');
		        	} else {
		        		$submit.fadeOut();
		        		newRow.removeClass('active');
		        		$content.removeClass('descriptor-submittable');
		        	}
		    	}); 
		        
		
			}
			else{
				alert("Do not show other type then categorical");
			}
			
			if ( isNumber(addMode) && addMode == 1){
				$(arrayDesc).detach();
				$('#id-descriptors-list').prepend(arrayDesc);
			}
			
			 
			//Bind Event
			$('#D'+descriptor.id).click(function(){

				if ( $(this).hasClass('descriptor-open') ){
					$(this).nextUntil(".descriptor").removeClass('visible').removeClass('active');
					$(this).removeClass('descriptor-open');
					//remove the descriptor ID in the Described descriptor
					if ( descriptorsToSubmit.indexOf(descriptor.id) >= 0 ){
						descriptorsToSubmit.splice(descriptorsToSubmit.indexOf(descriptor.id),1);
					}
					
					if ( descriptorsToSubmit.length == 0 ){
						$submit.fadeOut();
					}
					
				}else{
					$(this).addClass('descriptor-open');
					$(this).nextUntil('.descriptor').addClass('visible');
					$("#id-descriptors-list").parent().scrollTop($(this).offset().top - $($("#id-descriptors-list tr")[0]).offset().top );
				}
				
			});	 
		}
		
		//Create an Entry in the History view base on this description
		function creatHistoryEntry(description,index){
			var index_description = index;
			if ( index_description == undefined ){
				index_description = descriptions.length - 1;
			}
			var descriptor = description.descriptor;
			var stateIds = description.selectedStates;
			var qMeasure = description.quantitativeMeasure;
			
		
			var row = $('<tr class="descriptor" id="DescriptionD'+descriptor.id+'" data-indexdescription="'+index_description+'"></tr>');
			var toAppend = '<td class="descriptor-text" colspan="2">';
			toAppend += '<strong class="descriptor-title">'+descriptor.name+'</strong>';
			toAppend += '</td>';//End Descirptor-text
			toAppend += '<td class="button"></td>';
		
		
			row.append(toAppend);
			$('#id-history-descriptorsList').append(row);
			
			var deleteButton = $('<button class="close">x</button>');
		//	var editButton = $('<button class="close">x</button>');
		
			toAppend = "";
			//Categorical Type
			if ( descriptor.categoricalType ){
				for ( var g=0; g < stateIds.length ; g++ ){
					var state = states[stateIds[g]];
					toAppend += '<tr class="state">';
					toAppend += '<td class="picture">';
					if ( state.resourceIds.length > 0){
						var resource = resources[state.resourceIds[0]];
						toAppend += '<img src="'+resource.url+'" alt="'+state.name+'"  class="min-picture"/>';
					}
					else{
						toAppend += '<img src="http://xper3.com/resources/img/defaultThumbnail.png" class="min-picture" />';
					}
					toAppend += '</td>';//End picture
					toAppend += '<td class="state-text">';
					toAppend += '<strong class="state-title">'+state.name+'</strong>';
					toAppend += '</td>';//End State text
					toAppend += '<td class="button"></td>';
					toAppend += '</tr>';//End State
				}
			}
			else if (descriptor.quantitativeType ){
				row.addClass("numerical");
				toAppend += '<tr class="state numerical">';
				toAppend += '<td class="picture"></td>';
				toAppend += '<td class="state-text">';
				toAppend += '<strong>'+qMeasure.value+'</strong>'+descriptor.unit;
				toAppend += ' </td>';
				toAppend += ' <td class="button"></td>';
				toAppend += ' </tr>';
				
			}
			else{
				alert("Unknown descriptor Type");
			}
		
			
			$('#id-history-descriptorsList').append(toAppend);
			
		//	$('#DescriptionD'+descriptor.id+' .button').append(editButton);
			$('#DescriptionD'+descriptor.id+' .button').append(deleteButton);
			
			//Bind event
			deleteButton.click(function() {
		//		$("#edit-history").fadeOut();
				var ind = parseInt(row.attr("data-indexDescription"));
				descriptions.splice(ind,1);		
				changeDescriptionHistory();
			});
			
		//	
		//	editButton.click(function(){
		//		setPositionEditHistory();
		//		createEditHistory($("#edit-history"),description,index_description);
		//		$("#edit-history").fadeIn();
		//		mkeyLang.updateLang("#edit-history");
		//	});
			
			//Set the Span Message (update only the str passed as selector)
			mkeyLang.updateLang('#DescriptionD'+descriptor.id);
		}
		
//		function setWebserviceURL(urlWebService){
//			webserviceURL=urlWebService;
//		}
	}
	
	window.mkeyMobile = new MkeyMobile(NsddFileURL,NwebserviceURL);
}