

	
	Window.prototype.addDescription = function(DOMelement){		
		//Create the drag-Content Div
		var divDraggable = document.createElement("DIV");
		divDraggable.setAttribute("class","dragDiv");
		divDraggable.setAttribute("draggable","true");
		//Bind Drag n Drop Event
		divDraggable.addEventListener("dragstart",onDragStart,false);
		divDraggable.addEventListener("dragover",onDragOver,false);
		divDraggable.addEventListener("drop",onDrop,false);
		
		var contentDraggable = document.createElement("DIV");
		contentDraggable.setAttribute("class","content_dragDiv");
		
		contentDraggable.appendChild(DOMelement);
		divDraggable.appendChild(contentDraggable);
		
		document.body.appendChild(divDraggable);
		
		
		//Bind Closing Event
		//WARNING ( here as childNodes is use, this ligne should be change if the position of the button is changed )
		if ( DOMelement.childNodes[0].childNodes[0].className == "close" ){
			DOMelement.childNodes[0].childNodes[0].addEventListener("click",onDescriptionClosing,false);
		}else{
			console.error("Error In Mkey Code :: DOMelement.childNodes[0].childNodes[0].className != close ");
		}
		
		//TODO
		//Bind Comparaison Event
		
	};

	function onDescriptionClosing( event ){
		event.preventDefault();
		var targetElement = event.target;
		
		//Search the dragDiv class in the parents Node
		while ( !targetElement.classList.contains("dragDiv") && targetElement.tagName.toLowerCase() != "body"   ){
			targetElement = targetElement.parentNode;
		}
		
		//Remove the dragDiv element from the window
		targetElement.remove();
		
		//Automatically close the window if there is no more description in it
		if ( document.getElementsByClassName("dragDiv").length == 0 ){
			window.close();
		}
	}
	
	function onDragOver( event ){
//		console.log("dragOverBody");
		event.preventDefault();
		event.dataTransfer.dropEffect = "move";
	}
	
	function onDrop( event ){
//		console.log("drop");
		event.preventDefault();
		
//		var id = parseInt(Math.random()*1000)+"";
		var data=event.dataTransfer.getData("Text");
		
		var DOMelementToDrop = document.getElementById(data);
		var DOMelementOldContainer = DOMelementToDrop;
		var DOMelementNewContainer = event.target;
		
		//Search the dragDiv class in the parents Node
		while ( !DOMelementNewContainer.classList.contains("dragDiv") && DOMelementNewContainer.tagName.toLowerCase() != "body" ){
			DOMelementNewContainer = DOMelementNewContainer.parentElement;
		}
		
		//Search the dragDiv class in the parents Node
		while ( !DOMelementOldContainer.classList.contains("dragDiv") && DOMelementOldContainer.tagName.toLowerCase() != "body" ){
			DOMelementOldContainer = DOMelementOldContainer.parentElement;
		}
		
		var DOMelementToReplace = DOMelementNewContainer.getElementsByClassName("content_dragDiv")[0];
		
		//Switch place between DOM
		DOMelementNewContainer.appendChild(DOMelementToDrop);
		DOMelementOldContainer.appendChild(DOMelementToReplace);
		
	}
	
	function onDragStart ( event ){
//		console.log("dragstarted");
		var dt = event.dataTransfer;
		
		var id = parseInt(Math.random()*1000)+"";
		
		var DOMelementDroppable = event.target.getElementsByClassName("content_dragDiv")[0];
	
		DOMelementDroppable.id = id;
		
		dt.effectAllowed = "all";
		dt.setData('Text', id );
		dt.setData('text\html',id);
		return false;
	}