/**
 * @author antoine bergamaschi
 * @param NsddFileURL
 * @param NwebserviceURL
 * @param interfaceType, 0 = default, 1 = rowDisplay, 2 = rowDisplaySquare , 99 = special spipoll option
 */
function initMkey(NsddFileURL,NwebserviceURL,interfaceType ){
	
	initMkey(NsddFileURL,NwebserviceURL,interfaceType, null );
}


/**
 * @author antoine bergamaschi
 * @param NsddFileURL
 * @param NwebserviceURL
 * @param interfaceType, 0 = default, 1 = rowDisplay, 2 = rowDisplaySquare , 99 = special spipoll option
 */
function initMkey(NsddFileURL,NwebserviceURL,interfaceType, NxperienceUniqueid ){
			
	function Mkey(NsddFileURL,NwebserviceURL,interfaceType, NxperienceUniqueid){
		"use strict";
		
		this.sddFileURL = NsddFileURL;
		this.webserviceURL = NwebserviceURL;
		this.sddFileVersion = "unknow"; // vrolland : sdd version for SPIPOLL
		this.xperienceUniqueid = NxperienceUniqueid; // vrolland : uniqueid for xperience
		this.img_hasbeen_changed = false;
		
		//Prod Version ONLY
		var $ = jQuery,
		descriptionWindow = undefined,
		scoreMap = {},
		descriptions = [],
		discardedDescriptors = [],
		discardedDescriptorsIdsForJSON = [],
		remainingItems = [],
		everyItems = [],
		discardeditems = [], 
		remainingItemsIdsForJSON = [],
		selectedStatesNames = [],
		quantitativeMeasure = {},
		active_states_count = 0,
		descriptorsToSubmit = [],
		items = [],
		descriptors = [],
		states = [],
		resources = [],
		rootNodesID = [],
		invertedDependancyTable = {},
		selectedStatesIds = [],
		itemsSelectedForSubmission = [],
		displayMoreDescriptorsButton = true,
		oldsafari = window.navigator.appVersion.search("Safari") != -1 && window.navigator.appVersion.search("Chrome") == -1 && window.navigator.appVersion.search("Version/5") != -1 ;
		
		

		
		
//		var $ = jQuery;
		
		//The ref to the description window ( spipoll only )
//		var descriptionWindow = undefined;
//		
//		var scoreMap = {};
//		var descriptions = [];
//		var discardedDescriptors = [];
//		var discardedDescriptorsIdsForJSON = [];
//		var remainingItems = [];
//		var everyItems = [];
//		var discardeditems = [];
//		var remainingItemsIdsForJSON = [];
//		var selectedStatesNames = [];
//		
//		var quantitativeMeasure = {};
//		
//		var active_states_count = 0;
//		var descriptorsToSubmit = [];
//		
//		//Every Item in the dataset
//		var items = [];
//		//Every descriptor in the dataset
//		var descriptors = [];
//		//Every States in the dataset
//		var states = [];
//		//Every resources in the dataset
//		var resources = [];
//		//Warning rootNodes contains parentNodes which are not childNode
//		var rootNodesID = [];
//		//DependancyTree transcription
//		//var dependancyTable = {};
//		var invertedDependancyTable = {};
//		var selectedStatesIds = [];
		
		//Not implemented TODO add Mode
		//xper = 0, sokal = 1, jaccard = 2
		this.scoreType = 0;
		
		this.openDescriptionInAnotherDiv = false;
		this.showConfigurationOption = true;
		this.askForSDD = false;
		this.fixedDimension = false;
		this.messageOnClose = false;
		this.onlyPositiveScore = true;
		this.showEndIdentification = false;
		this.showStateWhitoutTaxon = true;
		this.endIdentification = false;
		this.hightlightFirstDescriptor = false;
		this.showScore = false;
		this.graphicDisplayScore = true;
		this.showNumberOfRemainingItem = true;
		this.graphicDisplayRemainingItem = true;
		//Show this.historyGraphDisplay ( item carousel in item description )
		this.historyGraphDisplay = false;
		this.numberOfDescriptor = 20;
		this.statByRow = 4;
		this.statByRowSquare = 6;
		this.principalStateDim = 6;
		
		switch(interfaceType){
			//default
			case 0:
				this.rowDisplay = false;
				this.rowDisplaySquare = false;
				break;
			//rowDisplay
			case 1:
				this.rowDisplay = true;
				this.rowDisplaySquare = false;
				break;
			//rowSquare
			case 2:
				this.rowDisplay = true;
				this.rowDisplaySquare = true;
				break;
			//Default Design with fixed dimension and without option
			case 3:
				this.rowDisplay = false;
				this.rowDisplaySquare = false;
				this.fixedDimension = true;
				this.showConfigurationOption = false;
				this.askForSDD = true;
				break;
			//Publish
			case 4:
				this.rowDisplay = false;
				this.rowDisplaySquare = false;
				this.fixedDimension = true;
				break;
			//Special Spipoll option
			case 99:
				this.openDescriptionInAnotherDiv = true;
				this.rowDisplay = true;
				this.rowDisplaySquare = true;
				this.showEndIdentification = true;
				this.hightlightFirstDescriptor = true;
				this.messageOnClose = true;
				break;
			default:
				this.rowDisplay = false;
				this.rowDisplaySquare = false;
				break;
		}
		
		
		//Init Lang
		try{
			this.mkeyLang = new MkeyLang();
		}catch(error){
//			alert("GRAVE : mkey_lang.js is undefined !!");
			console.error(error," : mkey_lang.js is undefined !!");
			return false;
		}
		
		Mkey.prototype.mkeyReady = function(callback){
			
			if ( window.location.pathname != "/xper3/kbEdition"){
				//Test if the url parameter is passed via URL ( ?sddURL )
				var SearchString = window.location.search.substring(1);
				if( SearchString.length > 0 ){
					var splitURL = SearchString.split("&");
					this.setSddFileUrl(parseURL(splitURL,"sdd"),false);
					this.setWebserviceURL(parseURL(splitURL,"ws"));
					this.changeInterface(parseInt(parseURL(splitURL,"interOption")));
					
					if ( $("#sddLoad").length > 0){
						$("#sddLoad").modal("hide");
					}
				}
			}
			
			initFullScreenApi();
			
			//If this.sddFileURL exist and not empty
			if ( this.sddFileURL.length > 0 ){
				
				if(this.sddFileURL.indexOf("sddmanager") != -1) {
					
					// vrolland : get SDD version					
					$.ajax({ context: this,
						url : this.sddFileURL.split("current")[0] + "/php/getversion.php",
						method : 'GET',
						crossDomain: true,
						dataType : 'json',
						success : function(json, statut){
							console.log(json);
							if(json.status == 'ok') {
								this.sddFileVersion = json.message;
							}
						},
						error : function(json,statut) {
							console.log(statut);
							console.log(json);
						}
					});
					// end vrolland : get SDD version
	
					//Begin Identification 
					getDescriptiveData(function(){	
						//Set the FullScreen Button
						if (fullScreenApi.supportsFullScreen) {
						    $("#ButtonFullScreen").fadeIn();
						}
					});
				}/* else if ( this.sddFileURL.split("sddpipoll") == "http://localhost/testbase.xml" ) { // test purpose 
					this.sddFileVersion = "unknown";
					getDescriptiveData(function(){	
						//Set the FullScreen Button
						if (fullScreenApi.supportsFullScreen) {
						    $("#ButtonFullScreen").fadeIn();
						}
					});
				} */
			}
			
			
			//Lock resize used to not fire resizing function to much
//			var lock_resize = false;
//			var rtime = undefined;
			
//			$(window).resize(function(){
//		//		resizeMkey();
//			    rtime = new Date();
//			    if (!lock_resize) {
//			    	lock_resize = true;
//			        setTimeout(resizeend, 100);
//			    }
//			});
//		      
//		    function resizeend() {
//		        if (new Date() - rtime < 100) {
//		            setTimeout(resizeend, 100);
//		        } else {
//		        	lock_resize = false;
//		//			mkey global resizing
////		        	resizeMkey();
//		        	if ( !fullScreenApi.isFullScreen() && fullScreenApi.supportsFullScreen){
//		        		 $("#ButtonFullScreen").fadeIn();
//		        	}
//		        }               
//		    }
			
		    $(document).keydown(function(event) {
				//If there is an item cart displayed switch resources with left or rigth key
				if ($('#id-item-card').attr('aria-hidden') == "false"){
					if ( event.keyCode == 37){
						 $('#id-item-card-carousel').carousel("prev");
					}
					else if (event.keyCode == 39 ){
						 $('#id-item-card-carousel').carousel("next");
					}
				}
		    });
			
			
			//Set clickEvent, reset identification
			$('#reset_identification').click(function(){
				//Reload page
				window.location.reload();
				/*if(confirm(mkey.mkeyLang.getMessage("message_warning_resetIdentification"))){
					descriptions = [];
					changeDescriptionHistory();
//					Change view to see descriptor
					$("#nav-descriptor-description li").addClass("active");
					$("#nav-li-description").removeClass("active");
					$("#id-descriptors-block .tab-pane").addClass("active");
					$("#id-history").removeClass("active");
				}*/
			});
			
			$("#msg-no-descriptor-left a").click(function(){
				//descriptions = [];
				//changeDescriptionHistory();
				window.location.reload();
			});
			
			//Fire the submitDescription button
			 $("#submitRow").click(function(e){
		        submitDescription(descriptorsToSubmit);
		        for ( var i = 0 ; i < descriptorsToSubmit.length ; i++ ){
		        	$('#D'+descriptorsToSubmit[i]).parent().remove();
		        }
		        descriptorsToSubmit = [];
				return false;
			 });
			
			 //Fire reset current Selection and close descriptor
			 $("#resetRow").click(function(e){
				   //Fire a click on the opened descriptor
				   $($(".descriptor-open")[0]).click();
			       return false;
			 });
			 
			
			//Remove the fullscreen button
		//	$("#cleanButtonFullScreen").click(function(){
		//		$("#ButtonFullScreen").fadeOut();
		//	});
			$("#ButtonFullScreen").click(function(){
//				$("#ButtonFullScreen").fadeOut();
				enterFullscreen();
			});
			
			//Remove the message show in visualState when clicking on history
			$("#nav-li-description").click(function(){
				$("#visualState").empty();
				
				//Close the descriptor open
				$(".descriptor-open").removeClass('descriptor-open');			
				$.each($(".descriptor-description"),function(index,row){
					if ($(row).css("display") !== "none"){
						$(row).toggle();
					}
				});
				
				$("#selectionSummary").fadeOut();

			});
			
			//Add the message show in visualState when clicking on descriptor
			$("#nav-li-descriptor").click(function(){
				$('#visualState').html('<h1  style="text-align: center;vertical-align: middle;padding: 12%;"> <table><tr><td><img style="width: 100px;" src="./img/arrow.png"/> </td><td> <span class="message" data-message="message_helpFirstStep"></span></td></tr></table> </h1>');
				$('#visualState').css("display","block");
				mkey.mkeyLang.updateLang("#visualState");
			});
			
		//	var lock_mouseover = false;
			//The fullscreen band
		//	$("#xper-nav").mouseover(function(){
		//		if ( !fullScreenApi.isFullScreen() && !lock_mouseover){
		//			lock_mouseover = true;
		//			$("#ButtonFullScreen").fadeIn();
		//			//Display 1 Sec the button
		//			setTimeout(function(){
		//				$("#ButtonFullScreen").fadeOut();
		//			},1000);
		//			//Lock the nav barre for 4 sec
		//			setTimeout(function(){
		//				lock_mouseover = false;
		//			},4000);
		//		}
		//		return false;
		//	});
			
			//Open the configuration menu
			$("#mkey-configuration-menu").click(function(){
				$("#modalConfiguationMkey").modal('show');
				$("#slider-range-max").slider( "option", "max", descriptors.length );
				$("#infoNumberOfItems").html(items.length);
				$("#infoNumberOfDescriptors").html(descriptors.length);
			});
			
			//Open the search panel
			$("#addSpecificDescriptorButton").click(function(){
				var inputDom = $("#input_search");
				if ( inputDom.css("display") == "none" ){
					var parentDom = $("#id-descriptors-block");
					inputDom.removeClass("inverted");
					$(".input_search_descriptor").css("display","inline-block");
					$(".input_search_item").css("display","none");
					setPositionInputSearch(parentDom,inputDom,0);
					inputDom.fadeIn();
					$("#search_descriptor_input").focus();
				}
				else{
					inputDom.fadeOut();
				}
				return false;
			});
			//open the search panel
			$("#selectSpecificItemButton").click(function(){
				var inputDom = $("#input_search");
				if ( inputDom.css("display") == "none" ){
					var parentDom = $("#remainingItemList").parent().parent();
					inputDom.addClass("inverted");
					$(".input_search_item").css("display","inline-block");
					$(".input_search_descriptor").css("display","none");
					setPositionInputSearch(parentDom,inputDom,1);
					inputDom.fadeIn();
					$("#search_item_input").focus();
				}
				else{
					inputDom.fadeOut();
				}
				return false;
			});
			//open the search panel
			$("#end-identification-selectSpecificItemButton").click(function(){
				var inputDom = $("#input_search");
				if ( inputDom.css("display") == "none" ){
					var parentDom = $("#remainingItemList").parent().parent();
					inputDom.addClass("inverted");
					$(".input_search_item").css("display","inline-block");
					$(".input_search_descriptor").css("display","none");
					setPositionInputSearch(parentDom,inputDom,1);
					inputDom.fadeIn();
					$("#search_item_input").focus();
				}
				else{
					inputDom.fadeOut();
				}
				return false;
			});
			
			
			//When out focusing the input search close clear the field
			$("input[type=search]").focusout(function(){
				$("#input_search").fadeOut();
				return false;
			});
			
		
			//Bind Event MouseHover on picture in the default design to enlarge img
			$("#id-descriptors-list").on("mouseover",".picture img",function(){
				//Only if default design
				if ( mkey.rowDisplay == false ){
					var copyIMG = $(this).clone();
					copyIMG.css("max-width","500px");
					copyIMG.css("height","auto");
					var bimg = $("#big_img_div");
					bimg.empty();
					bimg.append(copyIMG);
					setPositionBigImg($(this),bimg);
					bimg.fadeIn();
					
					//Bing closing event
					$(this).mouseout(function(){
						bimg.css("display","none");
						$(this).unbind();
						return false;
					});
				}
				return false;
			});
			
			
		
			 $("#button_submit").click(function(e){
			    e.preventDefault();
		        e.stopPropagation();
		        submitDescription(descriptorsToSubmit);
//		        for ( var i = 0 ; i < descriptorsToSubmit.length ; i++ ){
//		        	$('#D'+descriptorsToSubmit[i]).remove();
//		        }
		        descriptorsToSubmit = [];
				return false;
			 });
			 
			 $("#button_reset_submit").click(function(e){
			 	$(".descriptor.descriptor-open").removeClass("descriptor-open");
			 	$(".state.active").removeClass("active");
			 	$(".state.visible").removeClass("visible");
			 	
			 	$("#button_reset_submit").fadeOut();
			 	$("#button_submit").fadeOut();
			 	
			    descriptorsToSubmit = [];
				return false;
			 });
			 
			//Create contextual Dialog 
			 
			//Create the div in which error are displayed
			$("body").append($("<div id='alert_dialog_jq'></div>"));
			$("#alert_dialog_jq").dialog({
				autoOpen: false,
				dialogClass: "alert-dialog no-close",
				draggable: false,
				modal: true,
				resizable: false,
				open: function( event, ui ) {
					mkey.mkeyLang.updateLang("#alert_dialog_jq");
					setTimeout(function(){
						$("#alert_dialog_jq").dialog("close");
					},3000);
				},
				closeText: "hide"
			});
			 
			
			$("body").append($("<div id='wait-message'><span class='message' data-message='message_warning_waitLoading_2'></span><br /><br /><i class='loadImg'></i></div>"));
			
			$("#wait-message").dialog({
				autoOpen: false,
				dialogClass: "no-close",
				draggable: false,
				modal: true,
				resizable: false,
				closeText: "hide",
				closeOnEscape: false
			});
			 
			$("#add_descriptors").click(function(){
				mkey.numberOfDescriptor += 5;
				displayDescriptorSelect();
				return false;
			}); 
			 
			
			//Add the unload event to prevent from quitting accidentally the page
			function closeIt(event){
				triggerEndIdentification();
				if ( mkey.messageOnClose ){
					return mkey.mkeyLang.getMessage("message_warning_closeMkey");
				}
			}
			
			//Attention code penible
			window.onbeforeunload = closeIt;

			// Handle mkeyEnd : In case, there is a sessionid and the user didn't submit we send datas :
			$(window).bind("MkeyEnded", function(event,data){
				
				if(Mkey.prototype.getURLAnchorParameter('sessionid') == null) {
					return false;
				}

				$.ajax({
					url : mkey.webserviceURL + '/xperience/addrecord',
					data : { 	
						sddversion : mkey.sddFileVersion,
						sessionid : Mkey.prototype.getURLAnchorParameter('sessionid'),
						itemsselected : Mkey.prototype.getJSONItemsSelected(),
						history : Mkey.prototype.getJSONDescriptions(),
						urlimageuser : 'none'
					},
					method : 'GET',
					dataType : 'jsonp',
					success : function(code_json, statut){
					   	// no rescue... page will close !		   					   
				   },
				   error : function(resultat, statut, erreur){
					   	// no rescue... page will close !
				   }
				});
			});
			
			// -- end vrolland 	
			
	
			
			//Set language the navigator language by default
			try{
				var language = window.navigator.userLanguage || window.navigator.language;
				this.mkeyLang.changeLang(language.slice(0,2));
			}
			catch(error){
				this.mkeyLang.changeLang("en");
			}
			
			
			//Load the rendering loop
			beforePaint();
			
			if ( typeof callback == "function"){
				callback();
			}
		};
		
		/****************************************************************************************************************/
		/****************************************************************************************************************/
		
		/**
		 * FUNCTION IDENTIFICATION
		 */
		
		//Mkey basic prototype function
		if ( typeof Mkey.initProto === "undefined"){
			Mkey.prototype.getIdentificationData = function(callback){
				$.ajax({
					url : mkey.webserviceURL + '/identification/getDescriptiveData',
					data : {sddURL : mkey.sddFileURL,
						    withGlobalWeigth : true
						    },
					method : 'GET',
					dataType : 'jsonp'
			
				})
				.done(callback(data))
				.fail(callback(data));
			};
			
			Mkey.prototype.submitDescription = function(descriptionList,remainingItemsIDs,discardedDescroptorsIds,withScoreMap,withGlobalWeigth,callback){
				$.ajax({
					url : mkey.webserviceURL+ '/identification/getRemainingItemsAndDescriptorsUsingIDs',
					data : {
						sddURL : mkey.sddFileURL,
						descriptions : JSON.stringify(descriptionList),
						remainingItemsIDs : JSON.stringify(remainingItemsIDs),
						withScoreMap : withScoreMap,
						discardedDescriptorsIDs : JSON.stringify(discardedDescroptorsIds),
						withGlobalWeigth : withGlobalWeigth
					},
					method : 'GET',
					dataType : 'jsonp'// ,
				})
				.done(callback(data))
				.fail(callback(data));
				return false;
			};
			
			Mkey.prototype.computeSimilarity = function(descriptionsArray,remainingItemsIds,callback){
				var descriptionsJSON = [];
				for ( var i = 0 ; i < descriptionsArray.length ; i ++ ){
					var descriptionElementStateJSON = {
						selectedStatesNames : descriptionsArray[i].selectedStates,
						quantitativeMeasure : descriptionsArray[i].quantitativeMeasure
					};
					var descriptionJSON = {};
			
					descriptionJSON[descriptionsArray[i].descriptor.id] = descriptionElementStateJSON;
					
					descriptionsJSON.push(descriptionJSON);
				}
					
				$.ajax({
					url : this.webserviceURL+ '/identification/getSimilarityMap',
					data : {
						sddURL : mkey.sddFileURL,
						descriptions : JSON.stringify(descriptionsJSON),
						remainingItemsIDs : JSON.stringify(remainingItemsIds)
					},
					method : 'GET',
					dataType : 'jsonp'// ,
					}).done(callback(data));
				return false;
			};
			
			Mkey.prototype.changeHistory = function(descriptionArray,callback){
				$.ajax({
					url : this.webserviceURL+ '/identification/changeDescriptionHistory',
					data : {
						sddURL : mkey.sddFileURL,
						descriptions : JSON.stringify(descriptionArray)
					},
					method : 'GET',
					dataType : 'jsonp'// ,
					}).done(callback(data));
				return false;
			};
			
			Mkey.prototype.getDescriptions = function(){
				return descriptions;
			};
			
			Mkey.prototype.getJSONDescriptions = function(){
				var descriptionsJSON = [];
				for ( var i = 0 ; i < descriptions.length ; i ++ ) {
					var descriptorId = descriptions[i].descriptor.id;
					
					var stateId = [];
					for (var index in descriptions[i].selectedStates){
						stateId.push(descriptions[i].selectedStates[index]);
					}
					
					var descriptionElementStateJSON = {
							descId : descriptorId,
							statesID : stateId,
							quantitativeMeasure : descriptions[i].quantitativeMeasure	
					};
					var descriptionJSON = {};
					descriptionJSON = descriptionElementStateJSON;
					descriptionsJSON.push(descriptionJSON);
				}
				return JSON.stringify(descriptionsJSON);
			};
			
			Mkey.prototype.getRemainingItems = function(){
				return remainingItems;
			};
			
			Mkey.prototype.getJSONRemainingItems = function(){
				var itemsJSON = [];
				for ( var i = 0 ; i < remainingItems.length ; i ++ ){
					itemsJSON.push(remainingItems[i].id);
				}
				return JSON.stringify(itemsJSON);
			};
						
			Mkey.prototype.getJSONItemsSelected = function(){
				
				var itemsJSON = [];
				for ( var i = 0 ; i < remainingItems.length ; i ++ ){
					if( $.inArray(remainingItems[i].id , itemsSelectedForSubmission) != -1 ) {
						itemsJSON.push(remainingItems[i].id);
					}
				}
				
				return JSON.stringify(itemsJSON);
			};
			
			
			Mkey.prototype.getURLImageUser = function(){
				return $('.target').attr("src") == "./img/defaultThumbnail.png" ? "none" : $('.target').attr("src");
			};

			// Get Parameter after the url
			// ONLY WITH ANCHOR (#) ! NOT with '&' to avoid google analytic stuff
			Mkey.prototype.getURLAnchorParameter = function(sParam) {
				var sPageURL = window.location.href;
				var sURLParameters = sPageURL.split('#');
				if(sURLParameters.length == 2) {
					var sURLVariables = sURLParameters[1].split('&');
					
					for (var i = 0; i < sURLVariables.length; i++) 
					{
						var sParameterName = sURLVariables[i].split('=');
						if (sParameterName[0] == sParam) 
						{
							return sParameterName[1];
						}
					}
				}
				return null;
			};
			// Init image user if it's present
			var ImageUserFromURL =  Mkey.prototype.getURLAnchorParameter('urlimageuser');
			if(ImageUserFromURL) {
				LoadImageFromUrl(ImageUserFromURL);
			}

			Mkey.prototype.getSDDFileVersion = function(){
				return this.sddFileVersion
			};
			// end vrolland --

			Mkey.prototype.getResources = function(){
				return resources;
			};
			
			Mkey.prototype.getStates = function(){
				return states;
			};
			
		}
		
		
		/**
		 * First Function to be Called, this function get every Data necessary for identification from Mkey+ Webservice
		 * @param callback
		 */
		function getDescriptiveData(callback) {
		
			$.ajax({
				url : mkey.webserviceURL + '/identification/getDescriptiveData',
				data : {sddURL : mkey.sddFileURL,
						//uniqueid : "1916916151212", TODO TODO TODO 
						//uniqueid : "0123456789",
						uniqueid : mkey.xperienceUniqueid,
					    withGlobalWeigth : true
					    },
				method : 'GET',
				dataType : 'jsonp'
		
			}).done(function(data) {
		
				try{
					
					everyItems = data.Items;
					items = data.Items;
					descriptors = data.Descriptors;
					states = data.States;
					resources = data.Resources;
					rootNodesID = data.DescriptorRootId;
					invertedDependancyTable = data.InvertedDependancyTable;
					scoreMap = data.descriptorsScoreMap;
					
					//Escap spe character
					escapeCharacter();
					
					//Create the Data object for auto-complete and bind Event
					var search_input = $("#search_descriptor_input");
					createAutoComplete(descriptors,search_input,$("#id-descriptors-block"),0);
					
					
					$("#numberOfRemainingItem").html(" "+items.length+" ");
					if ( $("#numberOfRemainingItemBis").length){
						$("#numberOfRemainingItemBis").html(" "+items.length+" ");
					}
					$("#numberTotalOfItem").html(items.length);
					$('#remainingItemList').empty();
					remainingItemsIdsForJSON = [];
					$.each(items, function(index, item) {
						createRemainingItem(item,index%2);
						remainingItemsIdsForJSON.push(item.id);
					});
		
					search_input = $("#search_item_input");
					createAutoComplete(items,search_input,$("#remainingItemList"),1);
					
					//Basic Function 
					displayDescriptorSelect();
					
					//Add color chart graphics
					createColorChartGraphics();
					
					//add The charteDiv
					if ( mkey.graphicDisplayScore && $("#charteDiv").css("display") == "none"){
						$("#charteDiv").toggle();
					}
					
					
					if( document.title.length == 0 ){
						document.title = data.NameDataset;
					}
					
					if ( typeof callback == "function"){
						callback();
					}
					
				}
				catch(err){
					var alertDiv = $("#alert_dialog_jq");
					alertDiv.empty();
					var alertMessage =  "<h3><strong> Error : <span class='message' data-message='message_error_reload_1'></span> </strong></h3><br />";
					alertMessage += "<span class='message' data-message='message_error_reload_2' ></span><br />";
					alertMessage += "<p>"+err+"</p>";
					alertDiv.append(alertMessage);
					
					alertDiv.dialog("open");
				}
				
			})
			.fail(function(data){
				var alertDiv = $("#alert_dialog_jq");
				alertDiv.empty();
				var alertMessage =  "<h3><strong> Error : <span class='message' data-message='message_error_server_1'></span> </strong></h3><br />";
				alertMessage += "<span class='message' data-message='message_error_server_2' ></span><br />";
				alertMessage += "<p>"+data+"</p>";
				alertDiv.append(alertMessage);
				
				alertDiv.dialog("open");
			});
		}
		
		
		function updateInterface(){
			
			var itemDivDisplay = $("#itemDivDisplay");
			var itemRowDisplay = $("#itemRowDisplay");
			var descriptorDisplay = $("#desciptorDisplay");
//			var identificationSpan = $("#identificationSpan");
			var buttonSubmitSpan = $("#button_submit").parent();
			var navDescriptorDescription = $("#nav-descriptor-description").parent();
			var numbOfDescription = $("#numberOfdescription");
			
			var principalInformationRow = $("#principalInformation");
			var additionalInforamtionRow = $("#additionalInformation");
		
			//Update number of description in history
			numbOfDescription.html(descriptions.length);
			
			//Reload Bar
			if ( $('.remainingItemBar').length > 0){
				updateRemainingItemBar();
			}
			
			//Show or hide the descriptions help
			if ( descriptions.length == 0 ){
				$("#msg-no-description").css("display","block");
			}
			else{
				$("#msg-no-description").css("display","none");
			}
			
			//Show / Hide option
			if ( !mkey.showConfigurationOption ){
				$("#mkey-configuration-menu").css("display","none");
			}else{
				$("#mkey-configuration-menu").css("display","block");
			}
			
			//Initialize Interface depending on the display selected
			//Row display Interface
			if ( mkey.rowDisplay || mkey.rowDisplaySquare){

				//Row Display do not support fixed Dim interface
				$($("#main-content.container .row")[0]).removeClass("row").addClass("row-fluid");
				$("#main-content.container").removeClass("container").addClass("container-fluid");

				
				//Initialize the row display (from the default view), hide the Item view and set the Row span
				if ( $("#itemDivDisplay #remainingItemList").length > 0 ){			
					itemDivDisplay.hide();
					itemRowDisplay.show();
				}
				
				var remainingItem = $('#remainingItemList');
				remainingItem.detach();
				$('#consol_remainingItem').append(remainingItem);
				
				//Initialize descriptorDisplay row-fluid dimension
				if ( descriptorDisplay.hasClass("span8") ){
					descriptorDisplay.removeClass("span8");
				}
				if ( !descriptorDisplay.hasClass("span4")){
					descriptorDisplay.addClass("span4");
				}
				
				if ( principalInformationRow.length > 0 ){
					if ( !principalInformationRow.hasClass("span9") ){
						principalInformationRow.addClass("span9");
					}
					if ( principalInformationRow.hasClass("span12")){
						principalInformationRow.removeClass("span12");
					}
					
				}
				
				//Change the size of the row header of descriptor block
				if ( buttonSubmitSpan.length > 0){
					buttonSubmitSpan.css("display","none");
					if ( !navDescriptorDescription.hasClass("span10") ){
						navDescriptorDescription.addClass("span10");
					}
					if ( navDescriptorDescription.hasClass("span6") ){
						navDescriptorDescription.removeClass("span6");
					}
				}
				$("#humanReadableConsole").show();
				
			}
			//Default Interface
			else{
				
				if ( mkey.fixedDimension ){
					$($("#main-content.container .row*")[0]).removeClass("row-fluid").addClass("row");
					$("#main-content.container-fluid").removeClass("container-fluid").addClass("container");
				}else{
					$($("#main-content.container .row*")[0]).removeClass("row").addClass("row-fluid");
					$("#main-content.container").removeClass("container").addClass("container-fluid");
				}
				
				//Initialize the div display, hide the Item view and set the Row span
				if ( itemDivDisplay.css("display") == 'none' ){
					itemDivDisplay.show();
					itemRowDisplay.hide();
				}
				
				var remainingItem = $('#remainingItemList');
				remainingItem.detach();
	
				$('#remainingItemListContainer').append(remainingItem);
				
				if ( !descriptorDisplay.hasClass("span8") ){
					descriptorDisplay.addClass("span8");
				}
				if ( descriptorDisplay.hasClass("span4")){
					descriptorDisplay.removeClass("span4");
				}
				
				
				if ( principalInformationRow.length > 0 && additionalInforamtionRow.find("#image-container").length == 0){
					if ( !principalInformationRow.hasClass("span12") ){
						principalInformationRow.addClass("span12");
					}
					if ( principalInformationRow.hasClass("span9")){
						principalInformationRow.removeClass("span9");
					}
					
				}
				//Change the size of the row header of descriptor block
				if ( buttonSubmitSpan.length > 0){
					buttonSubmitSpan.css("display","inline-block");
					if ( navDescriptorDescription.hasClass("span10") ){
						navDescriptorDescription.removeClass("span10");
					}
					if ( !navDescriptorDescription.hasClass("span6") ){
						navDescriptorDescription.addClass("span6");
					}
				}
				
				$("#humanReadableConsole").hide();
			}
			
		}
		
		/**
		 * This function is fired every time the UI is updated.
		 * This function, sort the descriptor and display them with the this.rowDisplay or default display
		 * Do not use this function (prefer reloadDescriptorUI() function
		 */
		function displayDescriptorSelect() {
			updateInterface();
			
			//Create the Descriptor List param is the number of descriptor to display
			var sortedListDescriptorId = sortDescriptorScore(mkey.numberOfDescriptor);
			$('#numberOfDescriptor').html(sortedListDescriptorId.length+" ");
			
			//Detach the button to see more descriptors
//			var $add_descriptors = $("#add_descriptors").detach();
			
			$('#id-descriptors-list').empty();
			
			$.each(sortedListDescriptorId,function(index,descriptorID){
		
				//Row Display ( graphical View )
				if ( mkey.rowDisplay ){
					createDescriptorRow(descriptors[descriptorID]);
				}
				//Div Display ( expert View ) default
				else {
					createDescriptorDiv(descriptors[descriptorID]);
				}
			});
			
			
			//Set the HightLight Mode for the first Descriptor
			if ( mkey.hightlightFirstDescriptor ){
				//Create the first Modal window showing the must discriminant Descriptor
				createHightlightedDescriptor(sortedListDescriptorId[0]);

				//Only for the First Descriptor
				mkey.hightlightFirstDescriptor = false;
			} 
			
			$("#id-loading-dialog").hide();
			
//			$('#id-descriptors-list').append($add_descriptors);
			
			if(displayMoreDescriptorsButton){
				$("#add_descriptors").css("display","block");
			}else{
				$("#add_descriptors").css("display","none");
			}
		}
		
		
		function isDescriptorApplicable(descriptor,innapDescriptorId){
			var index = 0;
			while ( index < innapDescriptorId.length){
				if ( innapDescriptorId[index] == descriptor.id ){
					return index;
				}
				index++;
			}
			return -1;
		}
		
		//Get The Next / prev Image in the carousel ( next/prev are in the view list order )
		function getItemCarousel(itemID,pas){
			if ( pas > 0){
				var next = $('li#I'+itemID).next();
				if ( next.length != 0 ){
					var idStr = next[0].id;
					idStr =  idStr.substr(1,idStr.length);
					createCardItem(items[idStr],$('#id-item-card'));
				}
			}
			else{
				var prev = $('li#I'+itemID).prev();
				if ( prev.length != 0 ){
					var idStr = prev[0].id;
					idStr =  idStr.substr(1,idStr.length);
					createCardItem(items[idStr],$('#id-item-card'));
				}
			}
		}
		
		//Fire by the submit Button, create the History entry, fire the mkey+ api getRemainingItem
		function submitDescription(descriptorsSubmited) {

			//reset active_states
			active_states_count = 0;
			var submittedDescription = [];
			for ( var i = 0 ; i < descriptorsSubmited.length ; i++ ){
				var selectedDescriptor = descriptors[descriptorsSubmited[i]];
				selectedStatesIds = [];
				quantitativeMeasure = undefined;
				//For default design
				if ( !mkey.rowDisplay ){
					if (selectedDescriptor.categoricalType) {
						var $states = $('#D'+selectedDescriptor.id).nextUntil('.descriptor');
						$.each($states, function(index,state) {
								if ($(state).hasClass("active") ){
									selectedStatesIds.push(parseInt($(state).attr("data-stateid")));
								}
						});
					} else if (selectedDescriptor.quantitativeType) {
						var $states = $('#D'+selectedDescriptor.id).nextUntil('.descriptor');
						quantitativeMeasure = {
							value : $states.find('input[name=numerical_value]').val()
						};
					}
				}
				//For row display design
				else{
					if (selectedDescriptor.categoricalType) {
						var $states = [];
						//If rowSquare
						if ( mkey.rowDisplaySquare ){
							$states = $('#De'+selectedDescriptor.id+' #divMinStat .carousel');
						}
						//If row
						else{
							$states = $('#De'+selectedDescriptor.id+' .carousel');
						}
						$.each($states, function(index,state) {
							var val = parseInt($(state).attr('value'));
							if ($(state).hasClass("selectedState") && $.inArray(val,selectedStatesIds)){
								selectedStatesIds.push(val);
							}
						});
					}
					else if (selectedDescriptor.quantitativeType) {
						quantitativeMeasure = {
							value : $('#visualState').find('input[name=numerical_value]').val()
						};
					}
				}
				
				// Create a new description
				var description = {
					descriptor : selectedDescriptor,
					selectedStates : selectedStatesIds,
					quantitativeMeasure : quantitativeMeasure
				};
				
				
				var descriptionElementStateJSON = {
					selectedStatesNames : selectedStatesIds,
					quantitativeMeasure : quantitativeMeasure
				};
				var descriptionJSON = {};
		
				descriptionJSON[selectedDescriptor.id] = descriptionElementStateJSON;
				
				submittedDescription.push(descriptionJSON);
				
				// add the description in Descriptions
				descriptions.push(description);
				
				//Creat the Html
				creatHistoryEntry(description);
			}
			
			//reset the submitRow button
			$('#selectionSummary').fadeOut();
			$($("#content_selectionSummary ol")[0]).empty();
		//	$("#submitRow").attr('value',-1);
			
			//reset divButton
			$("#button_submit").fadeOut();
			$("#button_reset_submit").fadeOut();
			
		//	$("#button_submit").attr("data-descriptor",-1);
			
			//Close view
			$('#visualState').fadeOut(function(){
				$('#visualState').empty();
				$('#titleDescriptor').empty();
				$('#visualState').append('<h1  style="text-align: center;vertical-align: middle;padding: 12%;"> <table><tr><td><img style="width: 100px;" src="./img/arrow.png"/> </td><td> <span class="message" data-message="message_helpFirstStep"></span></td></tr></table> </h1>');
				$('#visualState').css("display","block");
				mkey.mkeyLang.updateLang("#visualState");
			});
			
			//Get remaining Items
			getRemainingItemsAndRemainingDescriptors(submittedDescription);
			
		}
		
		
		//Basic Function, call Mkey+ api with the description and the current remaining Item and descriptor
		function getRemainingItemsAndRemainingDescriptors(descList) {
			loadingMessage("open");
		
			$.ajax({
				url : mkey.webserviceURL+ '/identification/getRemainingItemsAndDescriptorsUsingIDs',
				data : {
					sddURL : mkey.sddFileURL,
					descriptions : JSON.stringify(descList),
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON),
					withScoreMap : true,
					discardedDescriptorsIDs : JSON.stringify(discardedDescriptorsIdsForJSON),
					withGlobalWeigth : true,

					uniqueid : mkey.xperienceUniqueid
				},
				method : 'GET',
				dataType : 'jsonp'// ,
				}).done(function(data) {
					if ( data !== "false" ){
			//			remainingDescriptors = data.remainingDescriptors;
						scoreMap = data.descriptorScoreMap;
						remainingItems = data.remainingItems;
						
						remainingItemsIdsForJSON = [];
						$.each(remainingItems, function(index, item) {
							remainingItemsIdsForJSON.push(item.id);
						});
						
						var discardedDescriptorsInIteration = data.discardedDescriptorsInIteration;
						// discardedDescriptorsNamesForJSON = [];
						$.each(discardedDescriptorsInIteration, function(index,descriptorIn) {
							discardedDescriptors.push(descriptorIn);
							discardedDescriptorsIdsForJSON.push(descriptorIn.id);
						});
			
						// Add by antoine
						updateItemInformation(remainingItems);
					}
					loadingMessage("close");
					
					// reset input list of descrpitor
					reloadDescriptorUI();
					
					//sort item
					sortItemRemainingDiscarded();
				});
		}
		
		
		/** ******************************************************************************************************* */
		/** Antoine Function***** */
		
		//Update the List of discardedItems
		function updateItemInformation(remainingItemsIn){
			var tmp_every = [];
			// construct the discardeditems list
			$.each(everyItems, function(index, item) {
				var bol = false;
				$.each(remainingItemsIn, function(rindex, ritem) {
					if (item.id == ritem.id) {
						tmp_every.push(item);
						bol = true;
						return false;
					}
				});
				if (!bol) {
					$("#I"+item.id).removeClass('remaining').addClass('eliminated');
					$("#I"+item.id).addClass('item_D');
					$("#I"+item.id).attr('indexDel',descriptions.length);
					discardeditems.push(item);
				}
			});
			//Update the Number of remaining item
			$('#numberOfRemainingItem').html(remainingItemsIn.length+"  ");
			if ( $("#numberOfRemainingItemBis").length){
				$("#numberOfRemainingItemBis").html(remainingItemsIn.length+"  ");
			}
			everyItems = tmp_every;
			updateSimilarityScoreDisplay();
		}
		
		//Update the position and color display of each eliminated item to match the score of similarity
		function updateSimilarityScoreDisplay(){			
			var $remaingItems = $("#remainingItemList .remaining").detach();
			var $eliminatedItems = $("#remainingItemList .eliminated").detach();
//			var $completeList = $("#remainingItemList li").detach().removeAttr("style");
			
			
			getSimilarityMap(function(map){
				//Detach every eliminated Item
				var eliminatedItems = [];
				//If paire change display color
//				var $remaingItems = $("#remainingItemList .remaining");
				var paire = $remaingItems.length%2;
				var max = -1;
				var tmpIndex = -1;
				
				//update Style for remainingItems
				for ( var i=0; i < $remaingItems.length;i++){
					$($remaingItems[i]).attr("title",mkey.mkeyLang.getMessage("message_remainingItem"));
					$($remaingItems[i]).attr("style",getStyleRemainingItem(i%2));
				}
				
				//update Style for eliminated items
				for (var i=0;i<$eliminatedItems.length;i++){ 
					$.each(map,function(index,score){
						if ( score >= max){
							max = score;
							tmpIndex = index;
						}	
					});
					if (tmpIndex != -1 ){
						delete map[tmpIndex];
						max = max * 100;
						if ( max < 1 ){
							max = 1;
						}
						var eliminatedItem = findElementInjQueryArray($eliminatedItems,"id","I"+tmpIndex);

						$(eliminatedItem).attr("style",getStyleEliminatedItem(max,(i+paire)%2));
						$(eliminatedItem).attr("title",max+"% "+mkey.mkeyLang.getMessage("message_eliminatedItem"));
						eliminatedItems.push($(eliminatedItem));
					}
					
					tmpIndex = -1;
					max = -1;
				}
				$('#remainingItemList').append($remaingItems);
				$('#remainingItemList').append(eliminatedItems);
				
				mkey.mkeyLang.updateLang("#remainingItemList");
//				$remaingItems.appendTo($("#remainingItemList"));
//				$eliminatedItems.appendTo($("#remainingItemList"));
			});
		}
		
		
		//Sort the Item list ( remaining Up, eliminated down )
		function sortItemRemainingDiscarded(){
			$('#remainingItemList > .eliminated').detach().appendTo('#remainingItemList');
			
		}
		
		//Sort n descriptors depending on their score ( Higth to low )
		function sortDescriptorScore(nIndex){	
			var sortedDescriptorList = [];
			var tmpIndex = -1;
			var max = -1;
			var minScore = -99;
			
			if ( mkey.onlyPositiveScore ){
				minScore = 0;
			}
			
			for (var i=0;i<nIndex;i++){ 
				$.each(scoreMap,function(index,score){
					if (!isParentDescriptorDiscardedAndInaplicable(descriptors[index])){
		//				&& score >= 0
						if ( $.inArray(index,sortedDescriptorList) < 0 && score > minScore &&  score >= max){
							max = score;
							tmpIndex = index;
						}
					}
		//			sortedDescriptorList.push(index);
				});
				if (tmpIndex != -1 ){
					sortedDescriptorList.push(tmpIndex);
					displayMoreDescriptorsButton = true;
				}else{
					displayMoreDescriptorsButton = false;
				}
				tmpIndex = -1;
				max = -1;
			}
			
			//Fire End identification
			if ( sortedDescriptorList.length == 0 ){
				
				$("#msg-no-descriptor-left").css("display","block");
				//If there is remaining items (identification works)
				if ( remainingItems.length > 0 ){
					if ( mkey.showEndIdentification ){
						createEndIdentification(remainingItems);
					}
				}
				else{
		//			alert("0 remaining Items");
					$("#modalNoRemainingItem").modal("show");
					$("#nav-descriptor-description li").removeClass("active");
					$("#nav-li-description").addClass("active");
					$("#id-descriptors-block .tab-pane").removeClass("active");
					$("#id-history").addClass("active");
					//hide button add_descriptor
					$("#add_descriptors").css("display","none");
				}
			}
			else{
				//show button add_descriptor
				$("#add_descriptors").css("display","block");
				//hide message no descriptors
				$("#msg-no-descriptor-left").css("display","none");
			}
			return sortedDescriptorList;
		}
		
		
		//Sort Similarity Map depending on their score and return n similarity {item,score}( Higth to low )
		function sortSimilarityMap(nIndex,similarityMap){	
			var sortedMapLit = [];
			var tmpIndex = -1;
			var max = -1;
			for (var i=0;i<nIndex;i++){ 
				$.each(similarityMap,function(index,score){
						if ( $.inArray(index,sortedMapLit) < 0 && score > 0 &&  score >= max){
							max = score;
							tmpIndex = index;
						}
				});
				if (tmpIndex != -1 ){
					sortedMapLit.push(tmpIndex);
				}
				tmpIndex = -1;
				max = -1;
			}
			
			return sortedMapLit;
		}
		
		
		// Get the remaining Items if this state is selected and submited by the user,
		// then append the HTML code for the check box in the interface
		// Warning as the ajax request can only be performed async=true, the HTML result
		// could not be write any where else.
		function getRemainingItems(state,descriptor,row) {
			selectedStatesNames = [];
			selectedStatesNames.push(state.name);
			selectedStatesIds = [];
			selectedStatesIds.push(state.id);
		
			var descList = [];
			var descriptionElementStateJSON = {
				selectedStatesNames : selectedStatesIds,
				quantitativeMeasure : quantitativeMeasure
			};
			var descriptionJSON = {};
			var selectedDescriptor = descriptor;
		
			descriptionJSON[selectedDescriptor.id] = descriptionElementStateJSON;
			descList.push(descriptionJSON);
		
			$.ajax({url : mkey.webserviceURL+ '/identification/getRemainingItemsAndDescriptorsUsingIDs',
				method : 'GET',
				dataType : 'jsonp',
				data : {
					sddURL : mkey.sddFileURL,
					descriptions : JSON.stringify(descList),
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON),
					withScoreMap : false,
					discardedDescriptorsIDs : JSON.stringify(discardedDescriptorsIdsForJSON),
					 withGlobalWeigth : true
				}
			}).done(function(data) {
				if ( !mkey.showStateWhitoutTaxon && data.remainingItems.length <= 0 ){
					row.addClass("stateWithoutTaxon");
				}
				creatState(state,descriptor,data.remainingItems.length,row);
			});
		}
		
		//Same as getRemainingItems
		function getRemainingItemsInDiv(state,descriptor,div,append){
			append = typeof append !== 'undefined' ? append : true;
			selectedStatesNames = [];
			selectedStatesNames.push(state.name);
			selectedStatesIds = [];
			selectedStatesIds.push(state.id);
		
			var descList = [];
			var descriptionElementStateJSON = {
				selectedStatesNames : selectedStatesIds,
				quantitativeMeasure : quantitativeMeasure
			};
			var descriptionJSON = {};
			var selectedDescriptor = descriptor;
		
			descriptionJSON[selectedDescriptor.id] = descriptionElementStateJSON;
			descList.push(descriptionJSON);
		
			$.ajax({url : mkey.webserviceURL+ '/identification/getRemainingItemsAndDescriptorsUsingIDs',
				method : 'GET',
				dataType : 'jsonp',
				async : 'true',
				data : {
					sddURL : mkey.sddFileURL,
					descriptions : JSON.stringify(descList),
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON),
					withScoreMap : false,
					discardedDescriptorsIDs : JSON.stringify(discardedDescriptorsIdsForJSON),
					 withGlobalWeigth : true
				}
			}).done(function(data) {
				var numberOfItem = data.remainingItems.length;
				var numberOfitemStr = "";
				if ( !mkey.showStateWhitoutTaxon && numberOfItem <= 0){
					$("#S"+state.id).addClass("stateWithoutTaxon");
				}
				var style = "";
				var relativeScore = Math.round((1 - (numberOfItem/everyItems.length)) *100);
				if ( mkey.graphicDisplayRemainingItem ){
					style = getStyle(relativeScore);
				}
				
				if ( mkey.showNumberOfRemainingItem && numberOfItem >= 0){
					numberOfitemStr = "("+numberOfItem+")";
				}
				if(append) {
					div.append("<div style='"+style+"'></div><span style='clear:rigth;'>"+numberOfitemStr+"</span>");
				} else {
					div.html("<div style='"+style+"'></div><span style='clear:rigth;'>"+numberOfitemStr+"</span>");
				}
				
			});
		}
		
		/**
		 * Get the similarity map for the submited description (at this time), every description is taken
		 */
		function getSimilarityMap(callback){
			var descriptionsJSON = [];
			for ( var i = 0 ; i < descriptions.length ; i ++ ){
				var descriptionElementStateJSON = {
					selectedStatesNames : descriptions[i].selectedStates,
					quantitativeMeasure : descriptions[i].quantitativeMeasure
				};
				var descriptionJSON = {};
		
				descriptionJSON[descriptions[i].descriptor.id] = descriptionElementStateJSON;
				
				descriptionsJSON.push(descriptionJSON);
			}
				
			$.ajax({
				url : mkey.webserviceURL+ '/identification/getSimilarityMap',
				data : {
					sddURL : mkey.sddFileURL,
					descriptions : JSON.stringify(descriptionsJSON),
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON)
				},
				method : 'GET',
				dataType : 'jsonp'// ,
				}).done(function(data) {
					 callback(data.similarityMap);
				});
		}
		
		/**
		 * Get the similaritry map Using the union of every remaining Items description
		 */
		function getSimilarityMapByRemainingItem(callback){
			$.ajax({
				url : mkey.webserviceURL+ '/identification/getSimilarityMapForRemainingItem',
				data : {
					sddURL : mkey.sddFileURL,
					remainingItemsIDs : JSON.stringify(remainingItemsIdsForJSON)
				},
				method : 'GET',
				dataType : 'jsonp'// ,
				}).done(function(data) {
					callback(data.similarityMap);
				});
		}
		
		/**
		 * Warning : If QuantitativeMeasure == undefined, the description results will have no field quantitativeMeasure
		 * Recompute the entire Description History
		 * @param callback
		 */
		function changeDescriptionHistory(callback){
			$.ajax({
				url : mkey.webserviceURL+ '/identification/changeDescriptionHistory',
				data : {
					sddURL : mkey.sddFileURL,
					descriptions : JSON.stringify(descriptions)
				},
				method : 'GET',
				dataType : 'jsonp'// ,
				}).done(function(data) {
					remainingItems = data.remainingItems;
					discardedDescriptors = data.discardedDescriptors;
					descriptions = data.descriptions;
					scoreMap = data.descriptorScoreMap;
					everyItems = items;
					
					remainingItemsIdsForJSON = [];
					$.each(remainingItems, function(index, item) {
						remainingItemsIdsForJSON.push(item.id);
					});
					
					discardedDescriptorsIdsForJSON = [];
					$.each(discardedDescriptors, function(index,descriptorIn) {
						discardedDescriptorsIdsForJSON.push(descriptorIn.id);
					});
		
					discardeditems = [];
					
					// reload items list for sorting
					$("#remainingItemList").empty();
					$.each(everyItems, function(index, item) {
						createRemainingItem(item,index%2);
					});
					
					updateItemInformation(remainingItems);
		
					// reset input list of descrpitor
					reloadDescriptorUI();
					
					//sort item
					sortItemRemainingDiscarded();
					
					$('#id-history-descriptorsList').empty();
					
					//Recreate description block
					$.each(descriptions,function(index,description){
						creatHistoryEntry(description,index);
					});
					
					if ( callback != undefined ){
						//fire callback
						callback();
					}
				});
		}
		
		// Run the chooseSDD php file to select the "xml" file in the same directory as
		// the html current location
		function getSddFiles() {
		
			// creat a new path whithout the html file extension
			var pathArray = document.location.pathname.split('/');
			var newPathname = "";
			for ( var i = 0; i < pathArray.length - 1; i++) {
				newPathname += pathArray[i];
				newPathname += "/";
			}
		
			var newURL = window.location.protocol + "//" + document.location.host + newPathname;
		
			$.ajax({
				url : "php/chooseSDD.php",
				type : 'POST',
				dataType : 'html',
				data : "path=" + newURL,
				success : function(data) {
					$("#chooseSDD").html(data);
		
					$("button.sddButton").click(function() {
						mkey.sddFileURL = this.value;
						$("#chooseSDD").html("");
						// run the WebService
						getDescriptiveData();
					});
		
				},
				error : function(data) {
					$("#chooseSDD").html("PhP unsoported");
				}
			});
		
		}
		
		// Retun true if inaplicable state is selected in the parentDescriptor or return
		// true if the parentDescriptor is not yet discarded
		function isParentDescriptorDiscardedAndInaplicable(currentDescriptor) {
			var inap = false;
			var isDiscarded = false;
			var allwaysShown = false;
		//
			// for each rootNode descriptor that are allways shown
			$.each(rootNodesID, function(index, rootID) {
				if (rootID == currentDescriptor.id) {
					allwaysShown = true;
					// break the $.each iteration
					return false;
				}
			});
			// if the first if as returned false
			if (!allwaysShown){
				//If currentDescriptor is a child descriptor
				if ( invertedDependancyTable[currentDescriptor.id] != undefined){
					var parentDescriptorID = invertedDependancyTable[currentDescriptor.id];
					$.each(discardedDescriptors,function(index,descriptorDescarded){
						//The parend Descriptor of this child has been selected
						if ( descriptorDescarded.id == parentDescriptorID ){
							isDiscarded = true;
							$.each(descriptions,function(index1,description){
								if ( description.descriptor.id == parentDescriptorID ){
									var inapplicableStateIDs = currentDescriptor.inapplicableState;
									$.each(description.selectedStates, function(index2,selectedState) {
										$.each(inapplicableStateIDs,function(index3,inapplicableStateID){
											// if there is one inaplicable state selected in
											// the description
											if (states[selectedState].id == inapplicableStateID) {
												// then inaplicable state is detected
												inap = true;
												// break the $.each iteration
												return false;
											}
										});
										if ( inap ){
											// break the $.each iteration
											return false;
										}
									});
		
									// break the $.each iteration
									return false;
								}
							});
							//break the $.each
							return false;
						}
					});
				}
			}
			else{
				return !allwaysShown;
			}
			if ( isDiscarded ){
				return inap;
			}
			
			return !isDiscarded;
		}
		
		
		
		
		/****************************************************************************************************************/
		/****************************************************************************************************************/
		
		/**
		 * FUNCTION DISPLAY CHANGE
		 */
		
		//Set function
		if (typeof Mkey.initProto === "undefined"){
			Mkey.prototype.setShowScore = function(bol,reload){
				var f_bol = isBoolean(bol);
				
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.showScore ){
						this.showScore = f_bol;
						//Reload display
						var re = isBoolean(reload);
						if ( re != undefined ){
							if ( re ){
								//Reload display
								displayDescriptorSelect();
							}
						}
						return true;
					}
				}
				return false;
			};
			
			Mkey.prototype.setGraphicDisplayScore = function(bol,reload){
				var f_bol = isBoolean(bol);
				
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.graphicDisplayScore ){
						this.graphicDisplayScore = f_bol;
						$("#charteDiv").toggle();
						//Reload display
						var re = isBoolean(reload);
						if ( re != undefined ){
							if ( re ){
								//Reload display
								reloadDescriptorUI();
							}
						}
						return true;
					}
				}
				return false;
			};
			
			Mkey.prototype.setShowNumberOfRemainingItem = function(bol,reload){
				var f_bol = isBoolean(bol);
				
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.showNumberOfRemainingItem ){
						this.showNumberOfRemainingItem = f_bol;
						//Reload display
						var re = isBoolean(reload);
						if ( re != undefined ){
							if ( re ){
								//Reload display
								displayDescriptorSelect();
							}
						}
						return true;
					}
				}
				return false;
			};
			
			Mkey.prototype.setGraphicDisplayRemainingItem = function(bol,reload){
				var f_bol = isBoolean(bol);
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.graphicDisplayRemainingItem ){
						this.graphicDisplayRemainingItem = f_bol;
						//Reload display
						var re = isBoolean(reload);
						if ( re != undefined ){
							if ( re ){
								//Reload display
								displayDescriptorSelect();
							}
						}
						return true;
					}
				}
				return false;
			};
			
			
			Mkey.prototype.setNumberOfDescriptor = function(numb){
				if ( isNumber(numb) ){
					if ( numb != this.numberOfDescriptor){
						this.numberOfDescriptor = numb;
						//Reload display
						reloadDescriptorUI();
					}
					return true;
				}
				return false;
			};
			
			
			Mkey.prototype.setSddFileUrl = function(urlSdd,reloadIdentification,callback){
				if ( urlSdd != undefined &&  urlSdd.length > 0 ){
					this.sddFileURL = urlSdd;
					var bol = isBoolean(reloadIdentification);
					if ( bol != undefined && bol){
						getDescriptiveData(callback);
					}
				}else{
					console.warn("sddFile URL has not been Change");
				}
			};
			
			Mkey.prototype.setWebserviceURL = function(urlWebService){
				if ( urlWebService != undefined &&  urlWebService.length > 0 ){
					this.webserviceURL=urlWebService;
				}else{
					console.warn("WebService URL has not been Change");
				}
			};
			
			Mkey.prototype.setScoreType = function(scoreT){
				this.scoreType = scoreT;
			};
			
			//TODO add choose score
	//		function getScoreTypeMap(){
	//			mapScore = {
	//				xperScore : 0,
	//				sokal : 1,
	//				jaccard : 2 
	//			};
	//			return mapScore;
	//		}
			
			Mkey.prototype.setNumberOfStatesImg = function(nStat){
				if ( isNumber(nStat) ){
					if ( nStat != this.statByRow){
						this.statByRow = nStat;
						this.statByRowSquare = nStat;
						$("#visualState").empty();
						//Reload display
						displayDescriptorSelect();
					}
					return true;
				}
				return false;
			};
			
			Mkey.prototype.setPrincipalStateDim = function(n){
				if ( isNumber(n) ){
					if ( n != this.principalStateDim){
						this.principalStateDim = n;
						$("#visualState").empty();
						//Reload display
						displayDescriptorSelect();
					}
					return true;
				}
				return false;
			};
			
			
			Mkey.prototype.setRowDisplay = function(bolRowDisplay,secondaryRowDisplay,reloadUI){
				var f_bol = isBoolean(bolRowDisplay);
				var n_bol = isBoolean(secondaryRowDisplay);
				var reloadUi = isBoolean(reloadUI);
				if ( f_bol != undefined ){
					if ( this.rowDisplay != f_bol ){
						this.rowDisplay = f_bol;
						//Set Row display
						if ( this.rowDisplay ){
							$("#itemDivDisplay").hide();
							$("#itemRowDisplay").show();
							if ( $("#desciptorDisplay").hasClass("span8") ){
								$("#desciptorDisplay").removeClass("span8");
							}
							$("#desciptorDisplay").addClass("span4");
						}
						//Remove Row diplay
						else{
							$("#itemDivDisplay").show();
							$("#itemRowDisplay").hide();
							if ( $("#desciptorDisplay").hasClass("span4") ){
								$("#desciptorDisplay").removeClass("span4");
							}
							$("#desciptorDisplay").addClass("span8");
							
						}
						if ( reloadUi == undefined ){
							reloadUi = true;
						}
					}
					
					
					//set the secondary row display
					if ( n_bol != undefined ){
						if ( n_bol !=  this.rowDisplaySquare){
							this.rowDisplaySquare = n_bol;
							if ( reloadUi == undefined ){
								reloadUi = true;
							}
						}
					}
					//If undefined
					else{
						this.rowDisplaySquare = false;			
					}
					
					
					if ( reloadUi ){
						//Reload the ui
						displayDescriptorSelect();
					}
				}
				return false;
			};
			
			
			Mkey.prototype.setDefaultDisplay = function(reload){
				var f_bol = isBoolean(reload);
				this.rowDisplaySquare = false;	
				this.rowDisplay = false;
				if ( f_bol != undefined ){
					if ( f_bol ){
						displayDescriptorSelect();
					}
				}
			};
			
			Mkey.prototype.changeInterface = function(newInterface,reload){
				var f_bol = isBoolean(reload);
				if ( isNumber(newInterface) ){
					//Reset option to default
					this.openDescriptionInAnotherDiv = false;
					this.showConfigurationOption = true;
					this.askForSDD = false;
					this.fixedDimension = false;
					this.messageOnClose = false;
					this.showEndIdentification = false;
					this.hightlightFirstDescriptor = false;

					
					switch(newInterface){
						//default
						case 0:
							this.rowDisplay = false;
							this.rowDisplaySquare = false;
							break;
						//rowDisplay
						case 1:
							this.rowDisplay = true;
							this.rowDisplaySquare = false;
							break;
						//rowSquare
						case 2:
							this.rowDisplay = true;
							this.rowDisplaySquare = true;
							break;
						//Default Design with fixed dimension and without option
						case 3:
							this.rowDisplay = false;
							this.rowDisplaySquare = false;
							this.fixedDimension = true;
							this.showConfigurationOption = false;
							this.askForSDD = true;
							break;
						//Publish
						case 4:
							this.rowDisplay = false;
							this.rowDisplaySquare = false;
							this.fixedDimension = true;
							break;
						//Special Spipoll option
						case 99:
							this.openDescriptionInAnotherDiv = true;
							this.rowDisplay = true;
							this.rowDisplaySquare = true;
							this.showEndIdentification = true;
							this.hightlightFirstDescriptor = true;
							this.messageOnClose = true;
							break;
						default:
							this.rowDisplay = false;
							this.rowDisplaySquare = false;
							break;
					}
					if ( f_bol ){
						displayDescriptorSelect();
					}
				}else{
					console.warn("choose a valide interface number");
				}
			};
			
			
			Mkey.prototype.setShowEndIdentification = function(bol){
				var f_bol = isBoolean(bol);
					
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.showEndIdentification ){
						this.showEndIdentification = f_bol;
						return true;
					}
				}
				return false;
			};
			
			Mkey.prototype.setShowStateWhitoutTaxon = function(bol){
				var f_bol = isBoolean(bol);
					
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.showStateWhitoutTaxon ){
						this.showStateWhitoutTaxon = f_bol;
						return true;
					}
				}
				return false;
			};
			
			Mkey.prototype.setOnlyPositiveScore = function(bol,reload){
				var f_bol = isBoolean(bol);
				var f_bol2 = isBoolean(reload);
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.onlyPositiveScore ){
						this.onlyPositiveScore = f_bol;
						if ( f_bol2 ){
							displayDescriptorSelect();
						}
						return true;
					}
				}
				return false;
			};
			
			Mkey.prototype.setFixedDimension = function(bol,reload){
				var f_bol = isBoolean(bol);
				var f_bol2 = isBoolean(reload);
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.fixedDimension ){
						this.fixedDimension = f_bol;
						if ( f_bol2 ){
							displayDescriptorSelect();
						}
						return true;
					}
				}
				return false;
			}; 
			
			Mkey.prototype.setShowConfiguration = function(bol,reload){
				var f_bol = isBoolean(bol);
				var f_bol2 = isBoolean(reload);
				if ( f_bol == true || f_bol == false){
					if ( f_bol != this.showConfigurationOption ){
						this.showConfigurationOption = f_bol;
						if ( f_bol2 ){
							displayDescriptorSelect();
						}
						return true;
					}
				}
				return false;
			};
		}
		
		
		/****************************************************************************************************************/
		/****************************************************************************************************************/
		
		/**
		 * FUNTION MISCELLIOUS
		 * 
		 */
		
		//Function fire onError to change img src to default
		//function replaceSrcImg(urlImg){
		//	$('img[src="'+urlImg+'"]').attr('src','http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png');
		//}
		
		function parseURL(splitedURL,name){
			for (var i=0 ; i < splitedURL.length;i++){
				var tmp = splitedURL[i].split("=");
				if ( tmp[0] == name ){
					return tmp[1];
				}
			}
			return undefined;
		}
		
		
		//Set a EndIdentification Event, with attached Element like history or remainingItems
		function triggerEndIdentification(){
			var event = $.Event("MkeyEnded");
			event.history = descriptions;
			event.pass = remainingItems;
			$(window).trigger(event);
		}
		
		//Can't put espace in string
		function getStyle(score){	
			var cssStr = "";
			cssStr += "border-radius:10px;";
			cssStr += "clear:both;";
			cssStr += "display:inline-block;";
			cssStr += "vertical-align:text-bottom;";
			cssStr += "width:100px;";
			cssStr += "height:16px;";
			cssStr += "background:rgb(160,202,84);";
			cssStr += "background:-moz-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
		//	cssStr += "background:-webkit-gradient(linear,left top,right top,color-stop(0%,rgba(160,202,84,1)),color-stop(27%,rgba(255,255,255,1)));";
			cssStr += "background:-webkit-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
			cssStr += "background:-o-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
			cssStr += "background:-ms-linear-gradient(left,rgba(160,202,84,1)0%,rgba(243,247,248,1)"+score+"%);";
		//	cssStr += "background:linear-gradient(to right,rgba(160,202,84,1)0%,rgba(255,255,255,1)27%);";
			cssStr += "filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#a0ca54',endColorstr='#f3f7f8',GradientType=1);";
			return cssStr;
		}
		
		function getStyleEliminatedItem(score,type){
			var color = "#eff6c1";
			if ( type == 1 ){
				color = "#e8efbc";
			}
			var color2 = "#c3db97";
			var cssStr = "";			
			cssStr += "background: "+color+";";
			cssStr += "background: -moz-linear-gradient(left, "+color+" "+(score-10)+"%, "+color2+" "+(score)+"%, #ffffff "+(score+1)+"%);";
			cssStr += "background: -webkit-gradient(linear, left top, right top, color-stop("+(score-10)+"%,"+color+"), color-stop("+(score)+"%,"+color2+"), color-stop("+(score+1)+"%,#ffffff));";
			cssStr += "background: -webkit-linear-gradient(left, "+color+" "+(score-10)+"%, "+color2+" 72%, #ffffff "+(score+1)+"%);";
			cssStr += "background: -o-linear-gradient(left, "+color+" "+(score-10)+"%,"+color2+" "+(score)+"%,#ffffff "+(score+1)+"%);";
			cssStr += "background: -ms-linear-gradient(left, "+color+" "+(score-10)+"%,"+color2+" "+(score)+"%,#ffffff "+(score+1)+"%);";
			cssStr += "background: linear-gradient(to right, "+color+" "+(score-10)+"%,"+color2+" "+(score)+"%,#ffffff "+(score+1)+"%);";
			cssStr += "filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='"+color+"', endColorstr='#ffffff',GradientType=1 );";
			return cssStr;
		}
		
		
		function getStyleRemainingItem(type){
			var color = "#eff6c1";
			if ( type == 1 ){
				color = "#e8efbc";
			}
			var color2 = "#c3db97";
			var cssStr = "";			
			cssStr += "background:"+color+";";
			cssStr += "background: -moz-linear-gradient(left, "+color+" 90%, "+color2+" 100%);";
			cssStr += "background: -webkit-gradient(linear, left top, right top, color-stop(90%,"+color+"), color-stop(100%,"+color2+"));";
			cssStr += "background: -webkit-linear-gradient(left, "+color+" 90%,"+color2+" 100%);";
			cssStr += "background: -o-linear-gradient(left, "+color+" 90%,"+color2+" 100%);";
			cssStr += "background: -ms-linear-gradient(left, "+color+" 90%,"+color2+" 100%);";
			cssStr += "background: linear-gradient(to right, "+color+" 90%,"+color2+" 100%);";
			cssStr += "filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='"+color+"', endColorstr='"+color2+"',GradientType=1 );";
			return cssStr;
		}
		
		function isNumber(n) {
			 return !isNaN(parseFloat(n)) && isFinite(n);
		}
		
		function isBoolean(testBol){
			var bol = undefined;
			if ( testBol == "false" ){
				bol = false;
			}
			else if(testBol == "true"){
				bol = true;
			}
			else if ( testBol == true || testBol == false){
				bol = testBol;
			}
			return bol;
		}
		
		function reloadDescriptorUI(){
			displayDescriptorSelect();
		}
		
		/**
		 * Fire every resize function once
		 */
		function resizeMkey(){
				
			//Resize this.endIdentification window
			if ( mkey.endIdentification ){
				reSizeEndIdentification();
			}
			//Resize main identification window
			else{
				setSizeFullBlock();

				if ( mkey.rowDisplay ){
					reSizeBlockState();
				}
				
				//If there is a preview Display ( spipoll image case )
				if ( window.previewDisplay != undefined && previewDisplay){
					displayPreview();
				}
				
				var font = ($(window).width()/20)+1;
				//Resize td picture size
			//	$("#block-id-descriptors .picture").css("width",($("#id-descriptors-list").width()/4)+"px");
				$("#block-id-descriptors .picture").css("width",font+"px");
				$("#id-history-descriptorsList .picture").css("width",font+"px");
				
				//Resize link for ellipsis
				resizeLink();
				
				//font size
			//	var font = ($(window).width()/160)+1;
			//	$("body").css("font-size",font+"px");s
			//	$("body").css("line-height",(font+4)+"px");
			//	$("strong").css("font-size",(font+4)+"px");
			//	$("strong").css("line-height",(font+8)+"px");
				
			//	$("#remainingItemList").css("line-height",(font+8)+"px");
			//	$(".block .block-header").css("height",(font*2)+"px");
			//	$(".block .block-header").css("height",(font*2)+"px");
			//	$("#main-content").css("margin-top",(font*2)+"px");
				
			//	$("#humanReadableConsole .nav .nav-tabs li").css("font-size",font+"px");
			//	$("#humanReadableConsole .nav .nav-tabs li").css("line-height",(font+8)+"px");
				
				if ( $("#edit-history").css("display") != "none" ){
					setPositionEditHistory();
				}
			}
			
		//	reSizeEndIdentification();
		}
		
		//Warning This function is very dependant off the Html forme
		function resizeLink(){
			var w;
			
			//Update links in the block item remaining
			var linkRemainingItem = $("#humanReadableConsole .nav-tabs li a");
			w = $("#humanReadableConsole").width()*0.82;
			w -= parseInt($(linkRemainingItem[0]).css("padding-left")) + parseInt($(linkRemainingItem[0]).css("padding-right"));
			w -= parseInt($(linkRemainingItem[0]).css("margin-left")) + parseInt($(linkRemainingItem[0]).css("margin-right"));
			linkRemainingItem.css("width",w);
			
			//Update links in the block descriptors
			var linkDescriptors = $("#nav-descriptor-description a");
			w = $("#nav-descriptor-description").width()*0.95;
			w -= parseInt($(linkDescriptors[0]).css("padding-left")) + parseInt($(linkDescriptors[0]).css("padding-right"));
			w -= parseInt($(linkDescriptors[0]).css("margin-left")) + parseInt($(linkDescriptors[0]).css("margin-right"));
			w -= parseInt($(linkDescriptors[1]).css("padding-left")) + parseInt($(linkDescriptors[1]).css("padding-right"));
			w -= parseInt($(linkDescriptors[1]).css("margin-left")) + parseInt($(linkDescriptors[1]).css("margin-right"));
			linkDescriptors.css("width",((w)/2));
			
		}
		
		if ( typeof Mkey.initProto === "undefined" ){
			Mkey.prototype.lockIdentification = function(callback){
				this.sddFileURL = "";
				if ( callback != undefined ){
					callback();
				}
			};
			
//			Mkey.prototype.updateInterfaceDimension = function(callback){
//				resizeMkey();
//				if (typeof callback == "function"){
//					callback();
//				}
//			};
		}
		
		
		function enterFullscreen() {
			var element = document.getElementById("bodyMkey");
			
			fullScreenApi.requestFullScreen(element);
			
		}
		
		function getRealWidth(element){
			var mw = parseInt(element.css("margin-left")) + parseInt(element.css("margin-right"));
			mw += parseInt(element.css("padding-left")) + parseInt(element.css("padding-right"));
			mw += parseInt(element.css("width"));
			return mw;
		}
		
		function getRealHeight(element){
			var mh = parseInt(element.css("margin-top")) + parseInt(element.css("margin-bottom"));
			mh += parseInt(element.css("padding-top")) + parseInt(element.css("padding-bottom"));
			mh += parseInt(element.css("height"));
			return mh;
		}
		
		
		//Initialize the fullScreenApi variable
		function initFullScreenApi(){
			function fullScreenApi(){
				this.prefix = '';
				this.fullScreenEventName= '';
				this.supportsFullScreen = false;
				
				if ( typeof fullScreenApi.initProto == "undefined"){
					var browserPrefixes = 'webkit moz o ms khtml'.split(' ');
					// check for native support
					if (typeof document.cancelFullScreen != 'undefined') {
						this.supportsFullScreen = true;
				    } 
				    else {
				        // check for fullscreen support by vendor prefix
				        for (var i = 0, il = browserPrefixes.length; i < il; i++ ) {
				        	this.prefix = browserPrefixes[i];
				 
				            if (typeof document[this.prefix + 'CancelFullScreen' ] != 'undefined' ) {
				            	this.supportsFullScreen = true;
				 
				                break;
				            }
				        }
				    }
					
					 // update methods to do something useful
				    if (this.supportsFullScreen) {
				    	this.fullScreenEventName = this.prefix + 'fullscreenchange';
				 
				    	fullScreenApi.prototype.isFullScreen = function() {
				            switch (this.prefix) {
				                case '':
				                    return document.fullScreen;
				                case 'webkit':
				                    return document.webkitIsFullScreen;
				                default:
				                    return document[this.prefix + 'FullScreen'];
				            }
				        };
				        fullScreenApi.prototype.requestFullScreen = function(el) {
				            return (this.prefix === '') ? el.requestFullScreen() : el[this.prefix + 'RequestFullScreen']();
				        };
				        fullScreenApi.prototype.cancelFullScreen = function(el) {
				            return (this.prefix === '') ? document.cancelFullScreen() : document[this.prefix + 'CancelFullScreen']();
				        };
				    }
				    
				    // jQuery plugin
				    if (typeof jQuery != 'undefined') {
				        jQuery.fn.requestFullScreen = function() {
				 
				            return this.each(function() {
				                if (this.supportsFullScreen) {
				                	this.requestFullScreen(this);
				                }
				            });
				        };
				    }
				    fullScreenApi.initProto = true;
				}
			}
		
		    // export api
		    window.fullScreenApi = new fullScreenApi();
		}
		
		if ( typeof Mkey.initProto === "undefined"){
			/**
			 * Ajax Function to Load a new SDD
			 */
			Mkey.prototype.loadSdd = function(){
				var dataSend = new FormData();
				loadingMessage("open");
				var modal = undefined;
				
				if ( $("#sddLoad").css("display") != "none" ){
					modal = $("#sddLoad");
					dataSend.append('file', $('#sddLoad .sddfile')[0].files[0]);
					
				}else if ( $("#modalConfiguationMkey").css("display") != "none" ){
					modal = $("#modalConfiguationMkey");
					dataSend.append('file', $('#modalConfiguationMkey .sddfile')[0].files[0]);
				}
				
				modal.modal("hide");
				
				if ( $("#sddfile_url").val().length && $("#sddfile_url")[0].validity.valid ){
					//Set SddFile and reload UI
					mkey.setSddFileUrl($("#sddfile_url").val(),true);
					
					loadingMessage("close");
				}
				else if( $("#sddfile_url_onStart").val().length && $("#sddfile_url_onStart")[0].validity.valid ){
					//Set SddFile and reload UI
					mkey.setSddFileUrl($("#sddfile_url_onStart").val(),true);
					
					loadingMessage("close");
				}
				else{
					
					$.ajax({ // ajax request
						type : "POST", // send in POST
						url : "php/upload_sdd.php", // url target
						async : true, // asynchrone mode
						cache : false,
						contentType : false,
						processData : false,
						data : dataSend, // data send
						dataType : "html",// "html", //JSON
					}).done(function(data){
						mkey.setSddFileUrl(data);
						//Load identification
						getDescriptiveData(function(){
							loadingMessage("close");
						});
						return true;
					})
					.fail(function(data){
						loadingMessage("close");
						var alertDiv = $("#alert_dialog_jq");
						alertDiv.empty();
						var alertMessage =  "<h3><strong> Error : <span class='message' data-message='message_error_upload_1'></span> </strong></h3><br />";
						alertMessage += "<span class='message' data-message='message_error_upload_2' ></span><br />";
						alertMessage += "<p>"+data+"</p>";
						alertDiv.append(alertMessage);
						
						alertDiv.dialog("open");
						return false;
					});
				}
				return true;
			};
		}
		
		
		function sddManagementRemove(urlSdd,callback){
			$.ajax({url : mkey.webserviceURL+ '/identification/removeSDD',
				method : 'GET',
				dataType : 'jsonp',
				data : {
					sddURLtoRemove : urlSdd
				}
			}).done(function(){
				callback();
			});
		}
		
		
		/****************************************************************************************************************/
		/****************************************************************************************************************/
		/**
		 * FUNCTION UPDATE
		 * Used to update interface, resize Block ...
		 */
		
		/**
		 * Update remaining Item bar
		 */
		function updateRemainingItemBar(){
			$.each($(".remainingItemBar"),function(index,div){
				var parentDiv = $(div).parent().parent();
				var w = 0;
				w = parentDiv.width()*(remainingItems.length/items.length) + 1;
				$(div).parent().css('width',w);
			});
		}
		
		/**
		 * Resize the major Block ( which are displayed Full size ) 
		 * Full size means from the top of this element to the Bottom of the window
		 */
		function setSizeFullBlock(callback){	
			
			var screenHeight = $(window).height();
			var staticOffset = parseInt($("#main-content").css("margin-bottom")) + parseInt($("#main-content").css("margin-top"));
			
			//Add margin bottom
			staticOffset += 20;
		
//			var setSize = true;
			var block = $('.block');
//			var lengthLoop = block.length - 1 ;
//			var indexInEach = undefined;
			
//			function recursiveF(){
//				if ( lengthLoop != indexInEach ){
//					setTimeout(recursiveF,100);
//				}else{
//					callback();
//				}
//			}
			
			$.each(block,function(index,blockI){
				var offset = staticOffset;
				
		
				//For the descriptor block
		        if ( $(this).attr("id") == "block-id-descriptors" ){
		
		
		        	offset += getRealHeight($(this).find(".block-header"));
		        	
		        	if ( mkey.graphicDisplayScore ){
		        		offset += getRealHeight($("#charteDiv"));
		        	}
		        	
		        }
		        //Block remaining Item
		        else if ( $(this).attr("id") == "block-id-items-list" ){
		        	offset += getRealHeight($(this).find('.block-title'));
		        }        
		//        if ( $(this).hasClass("block-full-height")){
		//        	var w = $(this).parent().width() - 10;
		//        	$(this).css('width',w);
		//        }
		        
		        //If the block is the remainingItems, or humanReadableConsole (in the left)
		        else if ( $(this).attr("id") == "humanReadableConsole"){
		        	
		        	if ( $(this).css("display") != "none" ){
						offset += getRealHeight($(this).find('.block-header'));
						
						//If the size of this block in readable
//						$(this).css("display","block");
//						if ( $(this).height() > 100 && $(this).width() > 200){
							var sendForm = $("#sendImageForm");
							var resetButton = $(".reset-load-image");
							var cropimgForm = $("#form-container");
							var cropDisplay = $(".jcrop-holder");
							var target = $("#target");
							//Add the Dimension of the Image (#target) (If this elements exist )
			
							if ( cropDisplay.length > 0){
								offset += getRealHeight(cropDisplay);
							}else if ( target.length > 0 ){
								offset += getRealHeight($("#target"));
							}
							if ( sendForm.length > 0 && sendForm.css("display") != "none" ){
								offset += getRealHeight(sendForm);
							}
							if ( resetButton.length > 0 && resetButton.css("display") != "none" ){
								offset += getRealHeight(resetButton);
							}
							if ( cropimgForm.length > 0 && cropimgForm.css("display") != "none" ){
								offset += getRealHeight(cropimgForm);
							}
							
							
//						}else{
//							$(this).css("display","none");
//						}
		        	}
				}
		        else if ( $(this).attr("id") == "edit-history" ){
		        	//Offset = 0.3*screen size + 0.4*entire block 
		        	offset = (screenHeight*0.3) + (screenHeight*0.7)*0.4;
		        	//Set max-height header size to cut to long description
		        	var header = $(this).find(".block-header");
		        	var mH = (screenHeight*0.7)*0.5;
		        	header.css("max-height",mH+"px");
		        	
		
		        }
		        //Block remaining Item Visual state
		        else{
		        	offset += getRealHeight($(this).find('.block-header'));
		        }
		        
//		        if ( setSize ){
		        	$(this).find('.block-content').height(screenHeight - offset - offset * 0.075);
		        	 // $('#additionalInformation').height(screenHeight - offset - offset * 0.075);
//		        }
		
//		        indexInEach = index;
		        
			});
				
//			if ( callback != undefined ){
//				
//				setTimeout(recursiveF,100);
//			}
		
		}
		
		/**
		 * Resize the Block in the visualState div (Row display square design)
		 */
		function reSizeBlockState(){
			
			if (mkey.rowDisplaySquare){
				var frow = $($('#visualState .row-fluid')[0]);
				var froI = $($('#visualState .row-fluid .item img')[0]);
				var carousel = $($('#visualState .row-fluid .carousel')[0]);
				var currentDesc = $($('.currentStateDesc')[0]);
				var divMin = $("#divMinStat");
				
				var heightVisual = $('#visualState').height();
//				var heightVisual = getRealHeight($('#visualState'));
//				var h = getRealWidth($('#visualState'))/2;
				var h = heightVisual*0.58;

				
				currentDesc.css("height",h+"px");
				//If the currentStateDesc is not heigher than h and h is lesser the half of visualState		
//				if ( h > currentDesc.height() ){
//					h = currentDesc.height();
//				}
//				if ( h < currentDesc.height() ){
//					//+margin
//					h = currentDesc.height() + 20 ;
//				}
		
				frow.css('height',h+"px");
//				if ( currentDesc.height() > h ){
//					currentDesc.css("height",(h-1) +"px");
//				}
				
				froI.css('max-height',(h - ( getRealHeight(carousel) - parseInt(carousel.css("height")) + 1) )+"px");
				
				var offset = parseInt(divMin.css("border-width")) + parseInt(divMin.css("padding-top")) + parseInt(divMin.css("padding-bottom"));
				offset += parseInt(divMin.css("margin-top")) + parseInt(divMin.css("margin-bottom"));
				
				h = heightVisual - h - offset ;
				//The remaining space is for the divMinStat
				$("#divMinStat").css('height',h+"px");

			}
		}
		
		
		function reSizeEndIdentification(){
			
			var container = $("#endIdentAll");
			if ( container.css("display") != "none" ){
				// -20 margin of the row-fluid
				var h_total = $("#endIdentAll").height();
				var h;
		
				//Set Size inside endDescription
				$("#endDescription").css("height",h_total);
				
				
				//set size inside endDescription
				if ( mkey.historyGraphDisplay ){
					h = parseInt(h_total * 0.4);
					//carousel for ressources display only in case of this.historyGraphDisplay
					$(".innerCarouselDescription .carousel-inner").css("height",h);
					h -= 20;
					$(".innerCarouselDescription .picture").css("max-height",h);
					
					h = parseInt(h_total * 0.4);
					$("#endDescription dl").css("height",h);
					
					h = h_total - $($("#endDescription .carousel")[0]).height();
					$("#carouselGlobalControler").css("height",h);
					
					h = h-10;
//					$("#carouselGlobalControler li .picture").css("height",h);
					$("#carouselGlobalControler .item-in-controller .picture").css("height",h);
				}
				else{

					$("#endDescription #endDescription-taxarem").css("height",parseInt(h_total*0.02));
					$("#endDescription #endDescription-listaxa").css("height",parseInt(h_total*0.20));
					$("#endDescription #endDescription-taxonname").css("height",parseInt(h_total*0.05));
					$("#endDescription #endDescription-details").css("height",parseInt(h_total*0.6));
					$("#endDescription #endDescription-taxonpict").css("height",parseInt(h_total*0.6));
					$("#endDescription #buttonOut").css("height",parseInt(h_total*0.04));


/*					
					h = parseInt(h_total*0.7);
					$("#endDescription dl").css("height",h);
//					- h - 50 
					h = h_total - h - 40;
					$("#carouselGlobalControler").css("height",h);
					
					h = h-20;
//					$("#carouselGlobalControler li .picture").css("height",h);
					$("#carouselGlobalControler .item-in-controller .picture").css("height",h);
					2
	*/					
					h = h_total - $("#end-identification-list-item-span").find(".block-header").height() - $("#end-image-container").height() - 10;
					
					
					//Set Size list item
					$("#end-identification-list-item-span .block-content").css("height",h);
				
				}
				
/*				
				//Set size historyGraph
				h = 34;
				$("#title_historyGraph").css("height",h);
//				$("#title_similarity").css("height",h);
				
				//Ressource display
				h = (h_total*0.5);
				$("#historyGraph").css("height",h);
				
				h = (h_total*0.30);
				$("#endDescription-detail").css("height",h);
				
				// - the margin bottom from historyGraph row-fluid - title size
				h = h_total - (h_total*0.75) - 10 - (34*2);
				
				//Set size similarity and button
//				$("#similarity").css("height",h);
				$("#buttonOut").css("height",h);
				
//				h = h-30;
//				$(".stateDescription .item img").css("max-height",h*0.85);
*/				
				//REsize Link for ellipsis
				var linkRemainingItem = $("#end-identification-list-item-span .nav-tabs li a");
				var w = $("#end-identification-list-item-span").width()*0.82;
				w -= parseInt($(linkRemainingItem[0]).css("padding-left")) + parseInt($(linkRemainingItem[0]).css("padding-right"));
				w -= parseInt($(linkRemainingItem[0]).css("margin-left")) + parseInt($(linkRemainingItem[0]).css("margin-right"));
				linkRemainingItem.css("width",w);
				
				setLeftCarouselItem();
			}
		}
		
		/**
		 * Set the Left position of picture in the End description panel ( in order to center the img )
		 */
		function setLeftCarouselItem(){
			var toSet = $($("#endDescription .innerCarouselDescription .active .picture")[0]);
			var left = toSet.parent().parent().width() - toSet.width();
			left = left/2;
			
			if ( left > 0){
				toSet.css("left",left);
			}
		}
		
		
		/**
		 * Set position of the div containing the Big picture of this smallImgDOM
		 */
		function setPositionBigImg(smallImgDOM,bigImgDOM){
			var inset = smallImgDOM.offset();
			var h,l,testh;
			h = inset.top;
			l = inset.left + getRealWidth(smallImgDOM);
			
			testh = h + bigImgDOM.height() - ($(window).height() - 70);
			//If bigImgDOM goes out of the window
			if ( testh > 0 ){
				if ( h < testh){
					h = 28;
				}
				else{
					h -= testh;
				}
			}
			
			testh = ($(window).height()-57-40);
			//If bigImgDOM is bigger than the window 
		//	if ( bigImgDOM.height() > ($(window).height()+57+40)  ){
			bigImgDOM.find("img").css("max-height",testh+"px");
			
		//	}
			
			bigImgDOM.css("top",h);
			bigImgDOM.css("left",l);
		}
		
		/**
		 * Set the position where the submit button should be place ( this.rowDisplay )
		 */
		function setPositionSubmitRowDisplay(){
			var pos = $("#visualState").offset();
			var h,w;
		
			h = pos.top + $("#visualState").height() - $("#submitRow").height()*1.5 - 10;
			w = pos.left + $("#visualState").width() - $("#submitRow").width()*1.5;
			
			$("#submitRow").css("top",h);
			$("#submitRow").css("left",w);
		}
		
		//Set the position where the Edit-hitory window should be place
		function setPositionEditHistory(){
			var pos = $("#desciptorDisplay").offset();
			var parentW = getRealWidth($("#desciptorDisplay"));
			var h,w;
		
			h = pos.top*1.3;
			w = pos.left + parentW ;
			
			$("#edit-history").css("top",h);
			$("#edit-history").css("left",w);
		}
		
		//Set the position of the InputSearch pane in the bottom of the parent dom
		//position 0 == bottom
		//position 1 == top
		function setPositionInputSearch(parentDom,inputDom,position){
			var h = parentDom.offset().top;
			var left = parentDom.offset().left;
			var w = parentDom.width() - parseInt(inputDom.css("padding-left")) - parseInt(inputDom.css("padding-right"));
			if ( position == 0){
				h += parentDom.height() - getRealHeight(inputDom);
				inputDom.css("top",h+"px");
			}
			else if ( position == 1){
				inputDom.css("top",h+"px");
			}
			inputDom.css("left",left+"px");
			inputDom.css("width",w+"px");
		}
		
		/****************************************************************************************************************/
		/****************************************************************************************************************/
		
		/**
		 * FUNCTION CREATE
		 * Used to build HTML dom
		 */
		
		//Create and Bind data for auto-complete event
		//dropType == 0 drop up 
		//dropType == 1 drop down
		//dropType is also use to know if this is a descriptor list ( 0 ) or the item list ( 1 )
		function createAutoComplete(array,inputDOM,containerDOM,dropType){
			var data = [];
			var data_elem = undefined;
			for ( var i = 0 ; i < array.length ; i++ ){
				data_elem = {
						label : array[i].name,
						id : array[i].id
				};
				data.push(data_elem);
			}
			var my = "";
			var at = "";
			if ( dropType == 0 ){
				my = "left bottom";
				at = "left top";
			}
			else if ( dropType == 1){
				my = "left top";
				at = "left bottom";
			}
			
			inputDOM.autocomplete({
			      minlength: 2,
			      source: data,
			      focus: function( event, ui ) {
		//	    	  inputDOM.val( ui.item.label );
			        return false;
			      },
			      select: function( event, ui ) {
			    	//Empty the input field
			    	inputDOM.val("");
			    	//Close the input_search
			    	$("#input_search").fadeOut();
			    	//If this is the descriptor array add in the descriptor List
			    	if ( dropType == 0 ){
			    		
						for ( var i = 0 ; i < discardedDescriptors.length ; i++ ){
							if ( discardedDescriptors[i].id == ui.item.id ){
								return false;
							}
						}
			    		
			    		var selectedDescriptor = descriptors[ui.item.id];
			    		
			    		var row = undefined;
			    		var focusedRow = undefined;
			    		for ( var i = 0 ; i < $('#id-descriptors-list tr.descriptor').length ; i++ ){
			    			row = $('#id-descriptors-list tr.descriptor')[i];
			    			if ( row.id == "D"+selectedDescriptor.id ){
			    				focusedRow = row;
			    			}
			    		}
			    		if ( focusedRow == undefined ){
				    		//Row Display ( graphical View )
				    		if ( mkey.rowDisplay ){
				    			createDescriptorRow(selectedDescriptor,1);
				    		}
				    		//Div Display ( expert View ) default
				    		else {
				    			createDescriptorDiv(selectedDescriptor,1);
				    		}
				    		//Simulate this new descriptor click
				    		$("D"+selectedDescriptor.id).click();
			    		}
			    		else{
			    			//Simulate click on this desciptor
			    			$(focusedRow).click();
			    			$("#id-descriptors-block").scrollTop($(focusedRow).offset().top - $($("#id-descriptors-list tr")[0]).offset().top );
			    		}
			    	}
			    	else if ( dropType == 1 ){
				    	//Empty the input field
				    	inputDOM.val("");
				    	//Close the input_search
				    	$("#input_search").fadeOut();
				    	//Show the selected Item
				    	var selectedItem = items[ui.item.id];
				    	var focusedItem = $("#I"+selectedItem.id);
		    			//Simulate click on this item
				    	focusedItem.click();
				    	if ( mkey.endIdentification ){
				    		$("#similarityList").scrollTop(focusedItem.offset().top - $($("#remainingItemList li")[0]).offset().top );
				    	}else{
				    		$("#consol_block-content").scrollTop(focusedItem.offset().top - $($("#remainingItemList li")[0]).offset().top );
				    	}
			    	}
		
			    	inputDOM.autocomplete( "close" );
			        return false;
			      },
			      position : {
			    	  my : my, 
			    	  at: at,
			    	  collision : "fit",
			    	  within : containerDOM
			      }
			    })
			    .data( "ui-autocomplete" )._renderItem = function( ul, item ) {
					var newText = String(item.label).replace(
		                new RegExp(this.term, "gi"),
		                "<span class='ui-state-highlight-perso'>$&</span>");
					
					for ( var i = 0 ; i < discardedDescriptors.length ; i++ ){
						if ( discardedDescriptors[i].id == item.id ){
							return $( "<li></li>" )
					        .append( "<a style='text-decoration : line-through;'>" + newText + "</a>" )
					        .appendTo( ul );
						}
					}
					return $( "<li></li>" )
				        .append( "<a>" + newText + "</a>" )
				        .appendTo( ul );
			    };
		}
		
		/**
		 * Creat the color chart displayed in the bottom of the Descriptor block when
		 * the graphical display is setted.
		 */
		function createColorChartGraphics(){
			$("#charteDiv").empty();
			
			var toAppend = "";
			toAppend += "<div class='charteGraphic-div goodPDescriptor' ></div>";
			toAppend += "<div class='charteGraphic-div goodMDescriptor' > </div>";
			toAppend += "<div class='charteGraphic-div mediumPPDescriptor' > </div>";
			toAppend += "<div class='charteGraphic-div mediumPMDescriptor' > </div>";
			toAppend += "<div class='charteGraphic-div mediumMPDescriptor' > </div>";
			toAppend += "<div class='charteGraphic-div mediumMMDescriptor' > </div>";
			toAppend += "<div class='charteGraphic-div badPDescriptor' > </div>";
			toAppend += "<div class='charteGraphic-div badMDescriptor' ></div>";
		
			$("#charteDiv").append(toAppend);
			$("#charteDiv").toggle();
			
		}
		
		
		
		/**
		 * Create a default style descriptor div, contained in the Descriptor Block ( left )
		 * @param descriptor
		 * @param addMode Integer, 0 == append ( default ) , 1 == prepend
		 */
		function createDescriptorDiv(descriptor,addMode){
		
			var scoreStr = "";
			//Array containing all the dom created
			var arrayDesc = [];
			//submit button
			var button_submit = $("#button_submit");
			var button_reset_submit = $("#button_reset_submit");
			
			if ( mkey.showScore ){
				scoreStr = " ("+scoreMap[descriptor.id]+")";
			}
			var descriptorTR = $("<tr class='descriptor' id=D"+descriptor.id+"></tr>");
			
			var toAppend = "<td class='picture'>";
		
			//If ressources
			var dIds = descriptor.resourceIds;
			if ( dIds.length > 0  ){
				toAppend += "<img src='"+ resources[dIds[0]].url + "' alt='"+descriptor.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";' style='max-width: 140px;' />";
			}
			else{
				toAppend += "<img src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' style='max-width: 140px;' />";
			}
			toAppend += "</td>";//End Td img
			toAppend += "<td class='descriptor-text'>";
		
			//Descriptor name
			toAppend += "<strong class='descriptor-title'>"+descriptor.name+"</strong>"+scoreStr;
			if ( descriptor.detail != null && descriptor.detail != "null" && descriptor.detail != "_"){
				toAppend += "<p>"+descriptor.detail+"</p>";
			}
			toAppend += "<div class='descriptor-operators'>";	
		
			//		<a href="#" class="active">AND</a> / <a href="#">OR</a> / <a href="#">XOR</a> / <a href="#">NOT</a> / <a href="#">NOR</a> / <a href="#">NXOR</a>
			toAppend += "</div>";//end descriptor-operator
			toAppend += "</td>";//End Descriptor-text
			toAppend += "<td class='button'></td>";//Submit button
			
		//	<button class='btn btn-success'>Submit</button>
			
			descriptorTR.append(toAppend);//End descriptor row
			
			
		
			arrayDesc.push(descriptorTR);
			$('#id-descriptors-list').append(descriptorTR);
		
			
			//List states add FOR
			//if descriptor is categorical
			if ( descriptor.categoricalType ){
				
				$.each(descriptor.stateIds,function(index,stateID){
		//			data-descriptorid='"+descriptor.id+"'
						var newRow = $("<tr class='state' data-stateid='"+states[stateID].id+"'></tr>");
						//Add the row in the Array
						arrayDesc.push(newRow);
						$('#id-descriptors-list').append(newRow);				
						getRemainingItems(states[stateID],descriptor,newRow);
				});
				
			}
			//if quantitativeType (test)
			else if (descriptor.quantitativeType ) {
				descriptorTR.addClass("numerical");
				var newRow = $('<tr class="state numerical"></tr>');
				
				toAppend = '<td class="picture"></td>';
				toAppend += '<td class="state-text">';
				toAppend += '<input type="number" min="0" step="0.5" value="" name="numerical_value" style="width: 50px">'+descriptor.unit;
				toAppend += ' </td>';
				toAppend += ' <td class="button"></td>';
		//		toAppend += ' </tr>';
				
				newRow.append(toAppend);
				//Add the row in the Array
				arrayDesc.push(newRow);
		        $('#id-descriptors-list').append(newRow);
		        
		        
		        //Bind Event
		        newRow.find('input[name=numerical_value]')[0].addEventListener("input",function(){
		        	if ($.isNumeric($(this).val())) {
		        		if ( !newRow.hasClass('active') ){
		        			newRow.addClass('active');
		        			active_states_count++;
		        			button_submit.fadeIn();
		        			button_reset_submit.fadeIn();
			        		if ( descriptorsToSubmit.indexOf(descriptor.id) < 0 ){
			        			descriptorsToSubmit.push(descriptor.id);
			        		}
		        		}
		        	} else {
		        		newRow.removeClass('active');
		        		active_states_count--;
		        		if ( active_states_count == 0 ){
		        			button_submit.fadeOut();
		        			button_reset_submit.fadeOut();
		        		}
		        		if ( descriptorsToSubmit.indexOf(descriptor.id) >= 0 ){
		        			descriptorsToSubmit.splice(descriptorsToSubmit.indexOf(descriptor.id),1);
		        		}
		        	}
		        },false);
		        //Add a click function to unselect this state
		        newRow.click(function(){
		        	if ( newRow.hasClass('active') ){
		        		newRow.removeClass('active');
		        	}
		        	else if ( $.isNumeric($( newRow.find('input[name=numerical_value]')[0]).val()) ){
		        		newRow.addClass('active');
		        	}
		        	return false;
		        });
		
			}
			else{
//				alert("Do not show other type then categorical/quantitative");
				console.warn("Do not show other type then categorical/quantitative");
			}
			
			if ( isNumber(addMode) && addMode == 1){
				$(arrayDesc).detach();
				$('#id-descriptors-list').prepend(arrayDesc);
			}
			
			 //Add Background
			 var score = scoreMap[descriptor.id];
			 score = score - Math.floor(score);
			 if ( mkey.graphicDisplayScore ){
		//	 score == 1
				 if ( score == 0 && score != scoreMap[descriptor.id]){
					 $("#D"+descriptor.id).addClass('goodPDescriptor');
				 }
				 else if ( score > 0.875 ){
					 $("#D"+descriptor.id).addClass('goodPDescriptor');
				 }
				 else if( score > 0.750 ){
					 $("#D"+descriptor.id).addClass('goodMDescriptor');
				 }
				 else if( score > 0.675 ){
					 $("#D"+descriptor.id).addClass('mediumPPDescriptor');
				 }
				 else if( score > 0.5 ){
					 $("#D"+descriptor.id).addClass('mediumPMDescriptor');
				 }	
				 else if( score > 0.375 ){
					 $("#D"+descriptor.id).addClass('mediumMPDescriptor');
				 }
				 else if( score > 0.250 ){
					 $("#D"+descriptor.id).addClass('mediumMMDescriptor');
				 }
				 else if( score > 0.125 ){
					 $("#D"+descriptor.id).addClass('badPDescriptor');
				 }
				 else if (score == 0 ){
					 $("#D"+descriptor.id).addClass('invalidDescriptor');
				 }
				 else{
					 $("#D"+descriptor.id).addClass('badMDescriptor');
				 }
			 }
			 else{
				 //Debug
				 if ( score == 0 && score == scoreMap[descriptor.id]){
					 $("#D"+descriptor.id).addClass('invalidDescriptor');
				 }
			 }
			 
			 
			//Bind Event
			$('#D'+descriptor.id).click(function(){
				if ( $(this).nextUntil(".descriptor").hasClass("active") ){
					return false;
				}
				if ( $(this).hasClass('descriptor-open') ){
					$(this).removeClass("descriptor-open");
					$(this).nextUntil('.descriptor').removeClass('visible');
				}else{
					$(this).addClass('descriptor-open');
					$(this).nextUntil('.descriptor').addClass('visible');
					$("#id-descriptors-block").scrollTop($(this).offset().top - $($("#id-descriptors-list tr")[0]).offset().top );
				}
			});	 
		}
		
		
		/**
		 * Create the Row display for this descriptor (block #descriptorDisplay).
		 * Add Event to build the statRowDisplay when this descriptor is clicked on.
		 * @param descriptor
		 * @param addMode, integer, 0 == append (default), 1==prepend
		 */
		function createDescriptorRow(descriptor,addMode){	
			var scoreStr = "";
			if ( mkey.showScore ){
				scoreStr = " ("+scoreMap[descriptor.id]+")";
			}
			
			var toAppend = "<tr class='descriptor' id=D"+descriptor.id+">";
		
			toAppend += "<td class='picture'>";
		
			//If ressources
			var dIds = descriptor.resourceIds;
			if ( dIds.length > 0  ){
				toAppend += "<img src='"+ resources[dIds[0]].url + "' alt='"+descriptor.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";' class='picture rowPicture' />";
			}
			else{
				toAppend += "<img src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' class='picture rowPicture' />";
			}
			toAppend += "</td>";//End Td img
			toAppend += "<td class='descriptor-text'>";
		
			//Descriptor name
			toAppend += "<strong class='descriptor-title'>"+descriptor.name+"</strong>"+scoreStr;
			toAppend += "<div class='descriptor-operators'>";	
		
			//		<a href="#" class="active">AND</a> / <a href="#">OR</a> / <a href="#">XOR</a> / <a href="#">NOT</a> / <a href="#">NOR</a> / <a href="#">NXOR</a>
			toAppend += "</div>";//end descriptor-operator
			toAppend += "</td>";//End Descriptor-text
			toAppend += "<td class='button'><button class='btn btn-success'>Submit</button></td>";//Submit button
			toAppend +=	"</tr>";//End descriptor row
			
			toAppend +=	"<tr class='descriptor-description' data-descriptor='"+descriptor.id+"'>";
			toAppend += "<td colspan='3' >";
//			id='D"+descriptor.id+"descriptorDetail'
			toAppend += "<div class='descriptorDetail'>";
//			display:none;
			if ( descriptor.detail != null && descriptor.detail != "null" && descriptor.detail != "_"){
				toAppend += "<p>"+descriptor.detail+"</p>";
			}
			toAppend += "</td>";//End of the descriptor description
			toAppend +=	"</tr>";//End descriptor description
			
			if ( isNumber(addMode) && addMode == 1 ){
				$('#id-descriptors-list').prepend(toAppend);
			}
			else{
				$('#id-descriptors-list').append(toAppend);
			}
		
		
			//Toggle content
			$("#D"+descriptor.id).click(function(){
				var desc = $(this);
				//Reset the selection summary
				$("#selectionSummary").fadeOut();
				$($("#content_selectionSummary ol")[0]).empty();
				
				//reset descriptors to submit ( in row design only one descriptor can be open at once )
				descriptorsToSubmit = [];
				
				//Remove or Add the openDescriptor Class
				if ( desc.hasClass('descriptor-open') ){
		//			.desc	riptor-open
					$(".descriptor-open").removeClass('descriptor-open');
				}else{
					$(".descriptor-open").removeClass('descriptor-open');
					desc.addClass('descriptor-open');
					//Add descriptor to the descriptors to be submitted
					descriptorsToSubmit.push(descriptor.id);
				}
				
				$.each($(".descriptor-description"),function(index,row){
					if ($(row).css("display") !== "none" && $(row).attr("data-descriptor") != descriptor.id ){
						$(row).toggle();
					}
				});
//				$.each($(".descriptor-description div:first-of-type"),function(index,div){
//					if ( $(div).css("display") != "none" && $(div).attr("id") !== ("D"+descriptor.id+"descriptorDetail") ){
//						$(div).toggle("slow");
//						$(div).parent().parent().css("border-bottom","0");
//					}
//				});
				
				var $toToggle = $(this).next(".descriptor-description");
				
				$toToggle.toggle();
//				$toToggle.toggle("slow",function(){
				
				//Open or Close this descriptor Div
//				$("#D"+descriptor.id+"descriptorDetail").toggle("slow",function(){
					//Open
					if (desc.hasClass('descriptor-open')){
		//				$("#D"+descriptor.id+" img.arrow").attr("src","http://identificationkey.fr/mkeyplus/img/bg-descriptor-arrow-close.png");
		//					desc.find('img.arrow').attr("src","http://identificationkey.fr/mkeyplus/img/bg-descriptor-arrow-close.png");
						$('#visualState').empty();
						$('#titleDescriptor').empty();
						$('#titleDescriptor').append(descriptor.name);
						//Create the row diplay states div in #visualState
						creatRowDivStates(descriptor);
						$toToggle.css("border-bottom","5px solid #e5e5e5");
//						$(this).css("border-bottom","5px solid #e5e5e5");
//						$(this).parent().parent().css("border-bottom","5px solid #e5e5e5");
					}
					//Close
					else{
						$('#visualState').fadeOut(function(){
							$('#visualState').empty();
							$('#visualState').append('<h1  style="text-align: center;vertical-align: middle;padding: 12%;"> <table><tr><td><img style="width: 100px;" src="./img/arrow.png"/> </td><td> <span class="message" data-message="message_helpFirstStep"></span></td></tr></table> </h1>'); 
							
							$('#titleDescriptor').empty();
							$('#visualState').css("display","block");
							
							mkey.mkeyLang.updateLang('#visualState');
							
							descriptorsToSubmit = [];
		//					if( $("#submitRow").css('display') != 'none'){
		//						$("#submitRow").toggle('slow');
		//						$("#submitRow").attr('value',-1);
		//					}
							if( $("#selectionSummary").css('display') != 'none'){
								$("#selectionSummary").fadeOut();
		//						$("#submitRow").attr('value',-1);
							}
						});
						$toToggle.css("border-bottom","0");
//						$(this).css("border-bottom","0");
//						$(this).parent().parent().css("border-bottom","0");
					}
					desc = null;
//					return false;
//				});
				return false;
			});
			
			
			  // Validation d'un descripteur
		//	 $("#D"+descriptor.id).find('.btn-success').click(function(e){
		//	      e.preventDefault();
		//	      e.stopPropagation();
		//	      
		//	      submitDescription(descriptor);
		//	      
		//	      $(this).closest('li').remove();
		//	      history_number = $history_tab.find('.number').data('number') + 1;
		//	      $history_tab.find('.number').show().data('number', history_number).text(' ('+history_number+')');
			      
		//	  });
			 
			 //Add Background
			 var score = scoreMap[descriptor.id];
			 score = score - Math.floor(score);
			 if ( mkey.graphicDisplayScore ){
		//	 score == 1
				 if ( score == 0 && score != scoreMap[descriptor.id]){
					 $("#D"+descriptor.id).addClass('goodPDescriptor');
				 }
				 else if ( score > 0.875 ){
					 $("#D"+descriptor.id).addClass('goodPDescriptor');
				 }
				 else if( score > 0.750 ){
					 $("#D"+descriptor.id).addClass('goodMDescriptor');
				 }
				 else if( score > 0.675 ){
					 $("#D"+descriptor.id).addClass('mediumPPDescriptor');
				 }
				 else if( score > 0.5 ){
					 $("#D"+descriptor.id).addClass('mediumPMDescriptor');
				 }	
				 else if( score > 0.375 ){
					 $("#D"+descriptor.id).addClass('mediumMPDescriptor');
				 }
				 else if( score > 0.250 ){
					 $("#D"+descriptor.id).addClass('mediumMMDescriptor');
				 }
				 else if( score > 0.125 ){
					 $("#D"+descriptor.id).addClass('badPDescriptor');
				 }
				 else if (score == 0 ){
					 $("#D"+descriptor.id).addClass('invalidDescriptor');
				 }
				 else{
					 $("#D"+descriptor.id).addClass('badMDescriptor');
				 }
			 }
			 else{
				 //Debug
				 if ( score == 0 && score == scoreMap[descriptor.id]){
					 $("#D"+descriptor.id).addClass('invalidDescriptor');
				 }
			 }
		}
		
		//Used in the this.rowDisplay Create the choice div
		function creatRowDivStates(descriptor){
			var spanType = " span"+parseInt(12/mkey.statByRow)+" ";
		
			var DescriptorDiv = $("<div  id=De"+descriptor.id+"></div>");
		//	toAppend += "<div  id=De"+descriptor.id+">";
		//	toAppend += "</div>";//close state list
		
			//Append Before Ajax call in getRemainingItems
			$('#visualState').append(DescriptorDiv);
			if ( descriptor.categoricalType ){
				//If square Display is selected
				if ( mkey.rowDisplaySquare ){
					//InnerFunction
					rowSquareDesign();
				}
				else{
					rowDesign();
				}
		
			}
			else if ( descriptor.quantitativeType ){
		//		descriptorTR.addClass("numerical");
				var div = $("<div class='row-fluid'></div>");
				var principalSpanType = " span"+mkey.principalStateDim+" ";
				var secondarySpanType = " span"+(12-mkey.principalStateDim)+" ";
				creatDescriptorRow(descriptor,-1,div,principalSpanType);
				var divDesc = $("<div class='"+secondarySpanType+" currentStateDesc description'></div>");
				divDesc.append("<h4>"+descriptor.name+"</h4>");
				if ( descriptor.detail != null && descriptor.detail != "null" && descriptor.detail != "_"){
					divDesc.append("<p>"+descriptor.detail+"</p>");
				}
				div.append(divDesc);
		
				var input = $('<input type="number" min="0" step="0.5" value="" name="numerical_value" style="width: 50px">');
		
				DescriptorDiv.append(div);
				DescriptorDiv.append(input);
				DescriptorDiv.append(descriptor.unit);
		        
		        //Bind Event
				input.addEventListener("input",function(){
		        	if ($.isNumeric($(this).val())) {
		        		$("#selectionSummary").fadeIn();
		        		$('#content_selectionSummary ol li').remove();
		        		$('#content_selectionSummary ol').append("<li>"+$(this).val()+"</li>");
		        		if ( descriptorsToSubmit.indexOf(descriptor.id) < 0 ){
		        			descriptorsToSubmit.push(descriptor.id);
		        		}
		        	} else {
		        		$("#selectionSummary").fadeOut();
		        		if ( descriptorsToSubmit.indexOf(descriptor.id) >= 0 ){
		        			descriptorsToSubmit.splice(descriptorsToSubmit.indexOf(descriptor.id),1);
		        		}
		        	}
		        },false); 
			}
			
			//Resize the block state wait 100ms
//			setTimeout(function(){
//				resizeMkey();
//			},100);
		//	resizeMkey();
			
			var lock = true;
			//Bind Global Event on the state div
			$("#De"+descriptor.id+" .carousel").click(function (){
				if ( lock ){
					var $stat = $(this);
					lock = false;
					var idStat = parseInt($stat.attr('value'));
					if ( $stat.hasClass('selectedState')){
						$stat.removeClass('selectedState');
						$("#S" + idStat + ".span2").removeClass('selectedState');
						$($("#De"+descriptor.id+" .removeHover")[0]).removeClass('selectedState');
		
						//Remove the min description
						$('#content_selectionSummary ol li[statID='+idStat+']').remove();
						
					}
					else{
						$stat.addClass('selectedState');
						$("#S" + idStat + ".span2").addClass('selectedState');
						$($("#De"+descriptor.id+" .removeHover")[0]).addClass('selectedState');
						var li_stat = $("<li statID="+idStat+">"+states[idStat].name+"</li>");
						var button_delete = $("<i class='icon-remove'></i>");
						button_delete.click(function(){
							//Fire a click on the state
							$stat.click();
							return false;
						});
						li_stat.append(button_delete);
						//Add the min description
						$('#content_selectionSummary ol').append(li_stat);
//						$('#content_selectionSummary ol').append("<li statID="+idStat+">"+states[idStat].name+"</li>");
					}
			
					//Display
					if ( $("#De"+descriptor.id+" .selectedState").length > 0 ){
						//Display the selectionSummary containing the submitRow button
						$("#selectionSummary").fadeIn(function(){
							lock = true;
						});
					}
					
					//Close
					else if ($("#De"+descriptor.id+" .selectedState").length  == 0 ){
						//Close the selectionSummary
						$("#selectionSummary").fadeOut(function(){
							lock = true;
						});
					}
					else{
						lock = true;
					}
					
					//Resize the block state
					reSizeBlockState();
				}
				
				return false;
		
			});
			
			
			/**
			 * InnerFunction, create the row Design
			 */
			function rowDesign(){
				
				var div=undefined;
				
				$.each(descriptor.stateIds,function(index,stateID){
		//				getRemainingItems(states[stateID],descriptor);
						if ( index%mkey.statByRow == 0 ){
							div = $("<div class='row-fluid'></div>");
							creatStateRow(states[stateID],descriptor,-1,div,spanType);
						}
						else if ( 0 == ((index%mkey.statByRow)-1)){
							creatStateRow(states[stateID],descriptor,-1,div,spanType);
							DescriptorDiv.append(div);
						}
						else{
							creatStateRow(states[stateID],descriptor,-1,div,spanType);
						}
					
				});
				
				if ( descriptor.stateIds.length%mkey.statByRow != 0 ){
					DescriptorDiv.append(div);
				}
				
			}
			
			
			
			
			
			
			
			
			
			
			
			
			/**
			 * InnerFunction, create the row Design Square display
			 */
// vrolland - 26-08-14	------------------------------------
			function rowSquareDesign(){
				DescriptorDiv.empty();
				//Empty the content_selectionSummary
				$($("#content_selectionSummary ol")[0]).empty();
				
				var divAllStatmin = $("<div id='divMinStat'></div>");
				//Append the divAllStatmin for the this.rowDisplaySquare UI
				DescriptorDiv.append(divAllStatmin);
				var divStatShow = $("<div id='desc-show-state'></div>");
				DescriptorDiv.append(divStatShow);

				
				var stateDivContainer = $("<div class='container-fluid'></div>");
				divAllStatmin.append(stateDivContainer);
				
				var first = true;
				$.each(descriptor.stateIds,function(index,stateID){
					var state = states[stateID];
					
					var resource = resources[state.resourceIds[0]];
					
					
					var stringToAppend = "";
					var div = $("<div id='S"+stateID+"' class='span3 carousel slide stateDescription' value='"+stateID+"' ></div>");
					stringToAppend += '<div class="carousel-inner" style="cursor:pointer;">';
					stringToAppend += "<div class='item active'>";
					
					
					stringToAppend += "<img src='"+ (resource == undefined ? "http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png" : resource.url) +"' alt='"+state.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";
					stringToAppend += "<div class='carousel-caption legendState' style='padding:5px;'>";
					stringToAppend += "<h5 style='color:white;'>"+state.name+"</h5>";
					stringToAppend += '</div>';
					stringToAppend += '<div class="legendStateTop"><i class="icon-ok icon-light "></i></div>';
				
					stringToAppend += '</div>';
					stringToAppend += '</div>';

					div.append($(stringToAppend));
					stateDivContainer.append(div);	
					
					div.bind("divstatemouseenter", function(event,data){
						var stateTMP = states[parseInt(data.me.attr('value'))];
						data.me.find('.legendState').css('height', 'auto');
						$('#desc-show-state').empty();
						
						var stateDivContainer2 = $("<div class='container-fluid'></div>");
						var stateDivRow2 = $("<div class='row' ></div>");
						var stateDivRow3 = $("<div class='row' ></div>");
						var stateDivRow4 = $("<div class='row' ></div>");
						var statetitle = "<h3>"+stateTMP.name+"</h3>";			
						
						var firstline = $("<div class='span6'>"+statetitle+"</div><div class='span6'><div class='topright'><i class='loadImg'></i></div></div>");
						stateDivRow2.append(firstline);
						
						$('#desc-show-state').append(stateDivContainer2);
						stateDivContainer2.append(stateDivRow2);
						stateDivContainer2.append(stateDivRow3);
						stateDivContainer2.append(stateDivRow4);
						if(stateTMP.detail) {
							stateDivRow3.append("<em>"+stateTMP.detail+"</em>");
						}						
						getRemainingItemsInDiv(stateTMP,descriptor,firstline.find('.topright'),false);
						
						$.each(stateTMP.resourceIds,function(index,rID){
							var res = resources[rID];
							var stringToAppend = "";
							var div2 = $("<div class='span4 slide stateDescription' ></div>");
							stringToAppend += '<div class="carousel-inner">';
							stringToAppend += "<div class='item active' >";
							stringToAppend += "<img src='"+ res.url +"' alt='"+stateTMP.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";

							stringToAppend += '</div>';
							stringToAppend += '</div>';
							
							div2.click(function(){
								div.trigger('click');
								$('#visualState').scrollTop();
							});
							
							div2.append($(stringToAppend));
							stateDivRow4.append(div2);												
						});
					});
					
					div.mouseenter(function () {
						$(this).trigger("divstatemouseenter", {me:$(this)});
					});
					
					div.mouseout(function () {
						$(this).find('.legendState').css('height', '14px');
					});
					
					if(first) {
						div.trigger("divstatemouseenter", {me:div});
						first = false;
					}
					
				});
				
				
				$("#itemRowDisplay").mouseleave(function() {
					var selected = $("#itemRowDisplay").find('.selectedState');
					
					if(selected.length != 0){
						$(selected[0]).trigger("divstatemouseenter", {me:$(selected[0])});
					}
				});
			}
			
// vrolland - 26-08-14			
/*			function rowSquareDesign(){
				
				//Empty the content_selectionSummary
				$($("#content_selectionSummary ol")[0]).empty();
				
				var divAllStatmin = $("<div id='divMinStat'></div>");
				//Append the divAllStatmin for the this.rowDisplaySquare UI
				DescriptorDiv.append(divAllStatmin);
				
				var begin = true;
				var div = $("<div class='row-fluid'></div>");
				var numberOfspan = 0;
				var spanType2 = " span"+parseInt(12/mkey.statByRowSquare)+" ";
				var avance = parseInt(12/mkey.statByRowSquare);
				var principalSpanType = " span"+mkey.principalStateDim+" ";
				var secondarySpanType = " span"+(12-mkey.principalStateDim)+" ";
				var divSubMinStat = $("<div class='row-fluid'></div>");
				var	divDesc;
		
				
				$.each(descriptor.stateIds,function(index,stateID){
					var divToAppend = $("<div></div>");
					var state = states[stateID];
					if ( begin ){
						begin = false;
						creatStateRow(state,descriptor,-1,div,principalSpanType);
						divDesc = $("<div class='"+secondarySpanType+" currentStateDesc description' value='"+stateID+"'></div>");
						div.append(divDesc);
						
		//				var divToAppend = $("<div></div>");
						divDesc.append("<h4>"+state.name+"@@@</h4>");
						divDesc.append(divToAppend);
						if ( state.detail != null && state.detail != "null" && state.detail != "_"){
							divDesc.append("<p>"+state.detail+"</p>");
						}
//						if ( mkey.showNumberOfRemainingItem ){
							getRemainingItemsInDiv(state,descriptor,divToAppend);
//						}
						
						//Append the divResumeChoice for the this.rowDisplay
		//				divDesc.append("<div id='divResumeChoice'><ol></ol></div>");
					}
					else{
						//Create and Hide description
						divDesc = $("<div class='"+secondarySpanType+" description' value='"+stateID+"' style='display:none;'></div>");
						
						$("#divMinStat").append(divDesc);
						
						divDesc.append("<h4>"+state.name+"</h4>");
						divDesc.append(divToAppend);
						if ( state.detail != null && state.detail != "null" && state.detail != "_"){
							divDesc.append("<p>"+state.detail+"</p>");
						}
//						if ( mkey.showNumberOfRemainingItem ){
							getRemainingItemsInDiv(state,descriptor,divToAppend);
//						}
						
					}
		
					numberOfspan += avance;	
					if ( numberOfspan > (12) ){
						$("#divMinStat").append(divSubMinStat);
						numberOfspan = avance;
						divSubMinStat = $("<div class='row-fluid'></div>");
					}
					creatStateRow(state,descriptor,-1,divSubMinStat,spanType2);
													
				});
				
				$("#divMinStat").append(divSubMinStat);
					
				DescriptorDiv.append(div);
				//Append the divAllStatmin for the this.rowDisplaySquare UI
				DescriptorDiv.append(divAllStatmin);
				
				$($("#De"+descriptor.id+" .stateDescription")[0]).addClass('removeHover');
			
				$("#divMinStat").append(divSubMinStat);
				$($("#divMinStat .stateDescription")[0]).addClass('removeHover');
				
				var lockMouseEnterState = false;
				//Bind Local Event
				//Event Display the current State
				$("#De"+descriptor.id+" .stateDescription").mouseenter(function(){
					if ( !lockMouseEnterState && !$(this).hasClass("removeHover") ){
						
						
						lockMouseEnterState = true;
						var selectedState = $(this);
						var oldSelectedState = $("#De"+descriptor.id+" .removeHover");
						
						$(".removeHover").removeClass("removeHover");
						
			//				var valTodel = $(oldSelectedState[0]).attr('value');
						var oldDescState = $(".currentStateDesc");
						oldDescState.css("display","none");
						oldDescState.detach();
						$("#divMinStat").append(oldDescState);
						oldDescState.removeClass("currentStateDesc");
						
						//Remove the copy (span 6)
						$(oldSelectedState[0]).remove();
						
						
						var copy = selectedState.clone(true,true);
						copy.removeClass(spanType);
						copy.removeClass(spanType2);
						//Zoom into the state img
						copy.addClass(principalSpanType);
						copy.addClass("removeHover");
						copy.css('display','none');
						div.append(copy);
						
						
						var divDesc = $('.description[value='+selectedState.attr("value")+']');
						divDesc.detach();
			
						divDesc.addClass("currentStateDesc");
						divDesc.css("display","block");
						
						div.append(divDesc);	
		//				divDesc.append(divResum);
						
						
						selectedState.addClass("removeHover");
						

						copy.fadeIn();
						lockMouseEnterState = false;
					}
					
					return false;
				});
			}
			
			
			*/
		}
		
		
		//Create the Item List (called Once)
		function createRemainingItem(item,type){
			var itemHTML = $("<li indexDel='-1' class='remaining' title='"+mkey.mkeyLang.getMessage("message_remainingItem")+"' id=I"+item.id+"><a href='#'>"+item.name+"</a></li>");
			$('#remainingItemList').append(itemHTML);
			//update Style
			itemHTML.attr("style",getStyleRemainingItem(type));
			//Bind event Open carousel
			itemHTML.click(function(){
			      createCardItem(item,$("#id-item-card"));
			      return false;
			  });
			mkey.mkeyLang.updateLang("#remainingItemList");
		}
		
		
		//Create the carousel representation for this item
		/**
		 * element is the dom where this carousel representation should be place
		 */
		function createCardItem(item,elementCarousel){
			var resource = item.resourceIds;
			elementCarousel.empty();
			var toAppend =  '<div class="modal-header">';
		    toAppend += '<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>';
		    
		    if ( $('li#I'+item.id).hasClass('remaining') ){
		    	toAppend +=  '<h3 id="id-item-card-label">'+item.name+'</h3>';
		    	toAppend +=  '<span class="id-item-card-status-remaining">- ' + mkey.mkeyLang.getMessage("message_remaining") + '</span>';
		    }
		    else{
		    	toAppend +=  '<h3 id="id-item-card-label" class="id-item-card-label-discarded">'+item.name+'</h3>';
		    	toAppend +=  '<span class="id-item-card-status-discarded">– ' + mkey.mkeyLang.getMessage("message_discarded") + '</span>';
		    }
		    //Show/Hide comparaison with the current Description
		    toAppend += '<div id="showHideDif" class="messageTooltip" data-message="message_helpShowDiff"><i class="icon-cog"></i></div>';
		    //Add Open description in a new Window
		    if ( mkey.openDescriptionInAnotherDiv ){
		    	 toAppend += '<div id="showInNewWindow" class="messageTooltip" data-message="message_helpOpenInNewWindow"><i class="icon-eye-open"></i></div>';
		    }
		    
		    toAppend += '</div>';
		    toAppend += '<div class="modal-body">';
		    toAppend += '<div id="id-item-card-carousel" class="carousel slide" data-interval="false">';
		//        <!-- Carousel items -->
		    toAppend += '<div class="carousel-inner">';
		    for ( var i=0; i<resource.length;i++){
		  	  var currentResource = resources[resource[i]];
		  	  if ( currentResource.type == "image" ){
		  		  if ( i == 0){
		  			  toAppend += '<div class="active item"><img src="'+currentResource.url+'" alt="'+item.name+'" /></div>';
		  		  } 
		  		  else{
		  			toAppend += '<div class="item"><img src="'+currentResource.url+'" alt="'+item.name+'" /></div>'; 
		  		  }
		  	  }
		  	  else{
//		  		  alert("display error, resource is not an image");
		  		  console.warn("display error, resource is not an image");
		  	  }
		    }
		    toAppend += '</div>';//End carousel-inner
		//        <!-- Carousel nav -->
		    toAppend += '<div class="carousel-controls">';
		    toAppend += '<a class="carousel-control left" href="#id-item-card-carousel" data-slide="prev">&lsaquo; PREV</a>';
		    toAppend += '<a class="carousel-control right" href="#id-item-card-carousel" data-slide="next">NEXT &rsaquo;</a>';
		    toAppend += '</div>';

		    toAppend += '<ol class="carousel-indicators">';
		    toAppend += '<li data-target="#id-item-card-carousel" data-slide-to="0" class="active"></li>';
		    toAppend += '<li data-target="#id-item-card-carousel" data-slide-to="1"></li>';
		    toAppend += '<li data-target="#id-item-card-carousel" data-slide-to="2"></li>';
		    toAppend += '</ol>';    
		    toAppend += '</div>';//end carousel
		    
		    if ( item.detail != null && item.detail != "null" && item.detail != "_"){
		    	toAppend += "<div class='detail_item_carousel'>";
		    	toAppend += item.detail;
		    	toAppend += "</div>";
		    }
    
 // Taxa Confusion :
if(item.taxaConfusion.length != 0) {
    toAppend += "<dl class='warning-confusion'>";
    toAppend += "<dt> <i class='icon-warning-sign'></i> Confusion possible avec  : </dt>";
    for ( var i=0; i<item.taxaConfusion.length;i++){
    	toAppend += "<dd id='itemsconfusion" + items[item.taxaConfusion[i]].id + "' idtaxaconfusion='"+item.taxaConfusion[i]+"' ><a href='#'>" + items[item.taxaConfusion[i]].name + "</a></dd>";
    }
    
    toAppend += "</dl>";
}    

		    toAppend += '<dl id="description-card-item">';
		    toAppend += '</dl>' ;
		    toAppend += '</div>';//end modal-body
		    elementCarousel.append(toAppend);
		    

		    if(item.taxaConfusion.length != 0) {
			    for ( var i=0; i<item.taxaConfusion.length;i++){
			    	var ddelem = $("#itemsconfusion" + items[item.taxaConfusion[i]].id);
			    	ddelem.click(function(){ 
			  	      createCardItem(items[parseInt($(this).attr('idtaxaconfusion'))],$("#id-item-card"));
			  	      return false;
			  	  	});
			    }
		    }   

		    
		    
		    // open external link in new page !
		    elementCarousel.find('a').each(function(){ 
		    	   if( this.href.indexOf(window.location.host) == -1 ) {
		    	       $(this).click(function(event) {
		    	           event.preventDefault();
		    	           event.stopPropagation();
		    	           window.open(this.href, '_blank');
		    	       });
		    	   }
		    });
		    
		    var div = $('<div class="modal-controls"></div>');

		    var left = $('<a class="modal-control left">&lsaquo;</a>');
		    var right = $('<a class="modal-control right">&rsaquo;</a>');
		    
		    left.click(function(){
		    	getItemCarousel(item.id,-1);
		    	return false;
		    });
		    
		    right.click(function(){
		    	getItemCarousel(item.id,1);
		    	return false;
		    });
		    
		    div.append(left);
		    div.append(right);
		    elementCarousel.append(div);
		    
		
			var elementSecondary = $('#description-card-item');
			elementSecondary.addClass("whiteWaitCard");

	    	createDescription(item,elementSecondary);
	    	elementSecondary.removeClass("whiteWaitCard");

		    $('#id-item-card').modal();
		    $("#showHideDif").click(function(){
		    	$("#id-item-card").find(".tableDescription").toggleClass("showdif");
		    	return false;
		    });
		    
		    $("#showInNewWindow").click(function(){
		    	addDescriptionInWindow(item);
		    	return false;
		    });
		}
		
		function creatCardItemForDescriptionWindow(item){
			var DOMelement = $("<div></div>");
			var header = $('<div class="content-header"></div>');
			var body = $('<div class="content-body"></div>');
			var descriptionDL = $('<dl id="description-content-body"></dl>');
			var buttonClose = $('<button type="button" class="close">×</button>');
			var carouselID = parseInt(Math.random()*1000)+"a";
			
			var resource = item.resourceIds;
//			var toAppend =  '<div class="content-header">';
//			var toAppend = '<button type="button" class="close">×</button>';
			
		    if ( $('li#I'+item.id).hasClass('remaining') ){
		    	var toAppend =  '<h3 id="id-item-card-label">'+item.name+'</h3>';
		    	toAppend +=  '<span class="id-item-card-status-remaining">– ' + mkey.mkeyLang.getMessage("message_remaining") + '</span>';
		    }
		    else{
		    	var toAppend =  '<h3 id="id-item-card-label" class="id-item-card-label-discarded">'+item.name+'</h3>';
		    	toAppend +=  '<span class="id-item-card-status-discarded">– ' + mkey.mkeyLang.getMessage("message_discarded") + '</span>';
		    }
//		    toAppend += '<div id="showHideDif" class="messageTooltip" data-message="message_helpShowDiff"><i class="icon-cog"></i></div>';
//		    toAppend += '</div>';//End content-header
		    
		    header.append(buttonClose);
		    header.append(toAppend);
		    
//		    toAppend += '<div class="content-body">';
		    toAppend = '<div id="'+carouselID+'" class="carousel slide" data-interval="false">';
		//        <!-- Carousel items -->
		    toAppend += '<div class="carousel-inner">';
		    for ( var i=0; i<resource.length;i++){
		  	  var currentResource = resources[resource[i]];
		  	  if ( currentResource.type == "image" ){
		  		  if ( i == 0){
		  			  toAppend += '<div class="active item"><img draggable="false" src="'+currentResource.url+'" alt="'+item.name+'" /></div>';
		  		  } 
		  		  else{
		  			toAppend += '<div class="item"><img draggable="false" src="'+currentResource.url+'" alt="'+item.name+'" /></div>'; 
		  		  }
		  	  }
		  	  else{
		  		  console.warn("display error, resource is not an image");
		  	  }
		    }
		    toAppend += '</div>';//End carousel-inner
		//        <!-- Carousel nav -->
		    toAppend += '<div class="carousel-controls">';
		    toAppend += '<a class="carousel-control left" href="#'+carouselID+'" data-slide="prev">&lsaquo; PREV</a>';
		    toAppend += '<a class="carousel-control right" href="#'+carouselID+'" data-slide="next">NEXT &rsaquo;</a>';
		    toAppend += '</div>';
//		    toAppend += '<ol class="carousel-indicators">';
//		    toAppend += '<li data-target="#id-item-card-carousel" data-slide-to="0" class="active"></li>';
//		    toAppend += '<li data-target="#id-item-card-carousel" data-slide-to="1"></li>';
//		    toAppend += '<li data-target="#id-item-card-carousel" data-slide-to="2"></li>';
//		    toAppend += '</ol>';    
		    toAppend += '</div>';//end carousel
		    
		    if ( item.detail != null && item.detail != "null" && item.detail != "_" ){
		    	toAppend += "<div class='detail_item_carousel'>";
		    	toAppend += item.detail;
		    	toAppend += "</div>";
		    }
		    
//		    body.append(toAppend);
//		    body.append(descriptionDL);
//		    toAppend += '<dl id="description-content-body">';
//		    toAppend += '</dl>' ;
//		    toAppend += '</div>';//end content-body
//		    DOMelement.append(header);
//		    DOMelement.append(body);
//			var elementSecondary = $('#description-content-body');

//		    buttonClose.click(function(){
//				var event = $.Event("closingDescription");
//				DOMelement.trigger(event);
//		    });
		    
	    	createDescription(item,descriptionDL,function(){
	    		body.append(toAppend);
			    body.append(descriptionDL);
			    DOMelement.append(header);
			    DOMelement.append(body);
	    		try{
	    			descriptionWindow.addDescription(DOMelement[0]);
	    		}
	    		catch(e){
	    			console.error(e,"Error Adding description");
	    		}
	    	});
		}
		
		/**
		 * Create the description in the Item card display
		 * @param descriptionElements
		 * @deprecated
		 */
		function createDescriptionOLD(item,element){
		    $.ajax({
				url : mkey.webserviceURL +'/identification/getDescription',
				data : {
					sddURL : mkey.sddFileURL,
					itemName : item.name
				},
				method : 'GET',
				dataType : 'jsonp'
			}).done(function(data) {
				var descriptionElements = data.description;
				var innapDescriptorId = data.innapDescriptorId;
				
		//		var description = {
		//				descriptor : selectedDescriptor,
		//				selectedStates : selectedStatesIds,
		//				quantitativeMeasure : quantitativeMeasure
		//			};
				
				var itemLI = $("#I"+item.id);
				var indexDel = -1;
				var description = undefined;
				
				if ( itemLI.hasClass("eliminated") ){
					indexDel = parseInt(itemLI.attr("indexdel"));
					description = descriptions[indexDel-1];
				}
				
				$.each(descriptionElements,function(index,descriptionElement){
					
					var compare = "";
			
					if ( description != undefined && description.descriptor.id == descriptionElement.id ){
		//				compare += " Index History = "+indexDel+"\n";
						for ( var k =0; k < description.selectedStates.length ; k++){
		//					compare += "\t-- "+states[description.selectedStates[k]].name;
							compare += '<li style="color:blue;">'+states[description.selectedStates[k]].name+'</li>';
						}
						if( description.quantitativeMeasure != undefined ){
							compare += descriptions[i].quantitativeMeasure.quantitativeMeasure.mean;
						}
					}
					
					var toAppendDesc = "";
					toAppendDesc += "<dt>";
					toAppendDesc += descriptors[descriptionElement.id].name;
		//			if ( compare.length > 0 ){
		//				toAppendDesc += '<span class="ui-icon ui-icon-comment pull-right" title="'+compare+'"></span>';
		//			}
					toAppendDesc += "</dt>";
					toAppendDesc += "<dd>";
					if ( !descriptionElement.unknown ){
						//Categorical states
						if ( descriptionElement.states != null && descriptionElement.states.length > 0){
							
							if ( compare.length > 0 ){
								toAppendDesc += '<span style="font-style:italic;">Index History = '+indexDel+'</span>';
							}
							
							toAppendDesc += "<ul>";
							
							if ( compare.length > 0 ){
								toAppendDesc += compare;
							}
							
							for ( var i=0; i < descriptionElement.states.length ; i++){
								var state = descriptionElement.states[i];
								
								if ( compare.length > 0 ){
									toAppendDesc += "<li style='text-decoration:line-through;'>";
								}
								else{
									toAppendDesc += "<li>";
								}
		//						toAppendDesc += "<li>";
								toAppendDesc += state.name;
								toAppendDesc += "</li>";
							}
							toAppendDesc += "</ul>";
						}
						//Quantitative states
						else if ( descriptionElement.quantitativeMeasure != null ){
							var quantitativeMeasureDesc = descriptionElement.quantitativeMeasure;
							if ( quantitativeMeasureDesc.min != null || quantitativeMeasureDesc.max != null || quantitativeMeasureDesc.mean != null || quantitativeMeasureDesc.sd != null){
								toAppendDesc += "[min,max] = ["+quantitativeMeasureDesc.min+","+quantitativeMeasureDesc.max+"]<br />";
								toAppendDesc += "mean = "+quantitativeMeasureDesc.mean+"<br />";
								toAppendDesc += "sd = "+quantitativeMeasureDesc.sd;
							}
							else{
								toAppendDesc += "<span class='description-text-notdescribed'>" + mkey.mkeyLang.getMessage("message_notDescribed") + "</span>";
							}
						}
						//calculated States
						else if( descriptionElement.calculatedStates != null && descriptionElement.calculatedStates.length > 0 ){
							var calculatedStates = descriptionElement.calculatedStates;
							toAppendDesc += "<ul>";
							for ( var i=0; i < calculatedStates.length ; i++){
								var calculatedState = descriptionElement.calculatedStates[i];
								toAppendDesc += "<li>";
								toAppendDesc += calculatedState.name;
								toAppendDesc += "</li>";
							}
							toAppendDesc += "</ul>";
						}
						else{
							var indexToDel = isDescriptorApplicable(descriptors[descriptionElement.id],innapDescriptorId);
							if ( indexToDel > -1){
								innapDescriptorId.slice(indexToDel,1);
								toAppendDesc += "<span class='description-text-inapplicable'>" + mkey.mkeyLang.getMessage("message_inapplicable") + "</span>";
							}
							else{
								toAppendDesc += "<span class='description-text-notdescribed'>" + mkey.mkeyLang.getMessage("message_notDescribed") + "</span>";
							}
						}
					}
					else{
						toAppendDesc += "<span class='description-text-unknown'>" + mkey.mkeyLang.getMessage("message_unknown") + "</span>";
					}
					toAppendDesc += "</dd>";
					element.append(toAppendDesc);
				});
				
				mkey.mkeyLang.updateLang("#id-item-card");
			})
			.fail(function(data) { 
				element.removeClass("whiteWaitCard");
				var alertDiv = $("#alert_dialog_jq");
				alertDiv.empty();
				var alertMessage =  "<h3><strong> Error : <span class='message' data-message='message_error_loadDescription_1'></span> </strong></h3><br />";
				alertMessage += "<span class='message' data-message='message_error_loadDescription_2' ></span><br />";
				alertMessage += "<p>"+data+"</p>";
				alertDiv.append(alertMessage);
				
				alertDiv.dialog("open");
			});
		
			
		}
		
		/**
		 * Create the description in the Item card display
		 * @param descriptionElements
		 */
		function createDescription(item,element,callback){
		    $.ajax({
				url : mkey.webserviceURL +'/identification/getDescription',
				data : {
					sddURL : mkey.sddFileURL,
					itemName : item.name
				},
				method : 'GET',
				dataType : 'jsonp'
			}).done(function(data) {
				var descriptionElements = data.description;
				var innapDescriptorId = data.innapDescriptorId;
				var descriptionElement;
				//For each descripionElement of this item
				for ( var a = 0 ; a  < descriptionElements.length ; a++){
						
					descriptionElement = descriptionElements[a];
						
					if ( !descriptionElement.unknown && isDescriptorApplicable(descriptors[descriptionElement.id],innapDescriptorId) <= -1){
							
						//$.each(descriptionElements,function(index2,descriptionElement){
					
						var statesMinus = descriptionElement.states;
						var qm = descriptionElement.quantitativeMeasure;
						var elementsToAppend = [];
						var table = $("<table class='tableDescription showdif' ></table>");
						table.append("<th colspan='2'>"+descriptors[descriptionElement.id].name+"</th>");
						//Create Classic display
						for ( var b = 0 ; b < statesMinus.length ; b++ ){
							table.append("<tr class='classic'>" +
											"<td><i class='icon-certificate'></i></td>"+
									     	"<td>"+statesMinus[b].name+"</td>"+
										 "</tr>");
						} 
						
						if( qm != undefined ){
							table.append($("<tr class='classic'>" +
														"<td><i class='icon-certificate'></i></td>" +
														"<td>Min: " + qm.min + "&nbsp;&nbsp;&nbsp;Max: " + qm.max + "&nbsp;&nbsp;&nbsp;Mean: " + qm.mean + "&nbsp;&nbsp;&nbsp;SD: " + qm.sd 
														+ "</td>" + "</tr>"));
						}
						
						var description;
						//For each description submitted by the user
						for ( var c = 0; c < descriptions.length ; c++ ){
							description = descriptions[c];
						
							// $.each(descriptions,function(index,description){
							if ( description.descriptor.id == descriptionElement.id ){
								//for each selected states
								for ( var d =0; d < description.selectedStates.length ; d++){
									var elementToAppend = undefined;
									for ( var e=0; e < statesMinus.length ; e++){
										//If this states has been selected
										if ( statesMinus[e].id == description.selectedStates[d] ){
											//Add signe ==
											elementToAppend = $("<tr class='egal messageTooltip' data-message='message_descriptionEgal' >" +
																	"<td><i class='icon-ok-sign'></i></td>" +
																	"<td>"+statesMinus[e].name+"</td>" +
																"</tr>");
											statesMinus.splice(e,1);
											break;
										}
									}
									//If the described states is not part of the item descriptor states
									if ( elementToAppend == undefined ){
										elementToAppend = $("<tr class='addition messageTooltip' data-message='message_descriptionAddition'>" +
																"<td><i class='icon-plus-sign'></i></td>" +
																"<td>"+states[description.selectedStates[d]].name+"</td>" +
															"</tr>");
									}
							
									elementsToAppend.push(elementToAppend);
								}
								
								//for each remaining states ( which have not been retrieve in the description selected state or which are not part of the description )
								for ( var f=0 ; f < statesMinus.length ; f++ ){
									elementsToAppend.push($("<tr class='negative messageTooltip' data-message='message_descriptionNegative' >" +
																"<td><i class='icon-minus-sign'></i></td>" +
																"<td>"+statesMinus[f].name+"</td>" +
															"</tr>"));
								}
								//Reset statesMinus
								statesMinus = [];
								
								if( description.quantitativeMeasure != undefined ){
									if ( description.quantitativeMeasure.quantitativeMeasure.mean ==  descriptionElement.quantitativeMeasure.mean ){
										elementsToAppend.push($("<tr class='egal'><td><i class='icon-ok-sign'></i></td><td></td></tr>"));
									}else{
										elementsToAppend.push($("<tr class='addition'><td><i class='icon-plus-sign'></i></td><td></td></tr>"));
									}
								}
							}
							
						}
					
						//If not entered in the loop $.each description or if this descriptor has not been discribed
						for ( var e=0 ; e < statesMinus.length ; e++ ){
							elementsToAppend.push($("<tr class='notdescribed'><td><i class='icon-certificate'></i></td><td>"+statesMinus[e].name+"</td></tr>"));
						}
						
						if ( qm != undefined ){
							elementsToAppend.push($("<tr class='notdescribed'><td><i class='icon-certificate'></i></td><td></td></tr>"));
						}
			
						if ( !descriptionElement.unknown ){
							
							if ( elementsToAppend.length == 0 ){
								var indexToDel = isDescriptorApplicable(descriptors[descriptionElement.id],innapDescriptorId);
								if ( indexToDel > -1){
									innapDescriptorId.slice(indexToDel,1);
									table.append("<tr class='alert-error'><td></td><td>" + mkey.mkeyLang.getMessage("message_inapplicable") + "</td></tr>");
								}
								else{
									table.append("<tr class='alert-error'><td></td><td>" + mkey.mkeyLang.getMessage("message_notDescribed") + "</td></tr>");
								}
							}else{
								table.append(elementsToAppend);
							}
						}
						else{
							table.append("<tr class='alert-error'><td></td><td>" + mkey.mkeyLang.getMessage("message_unknown") + "</td></tr>");
						}
			
						element.append(table);
					}
					
				}
				
				mkey.mkeyLang.updateLang("#id-item-card");
				
				if (typeof callback == "function" ){
					callback(element);
				}
				
			})
			.fail(function(data) { 
				element.removeClass("whiteWaitCard");
				var alertDiv = $("#alert_dialog_jq");
				alertDiv.empty();
				var alertMessage =  "<h3><strong> Error : <span class='message' data-message='message_error_loadDescription_1'></span> </strong></h3><br />";
				alertMessage += "<span class='message' data-message='message_error_loadDescription_2' ></span><br />";
				alertMessage += "<p>"+data+"</p>";
				alertDiv.append(alertMessage);
				
				alertDiv.dialog("open");
			});
		
			
		}
		
		
		
		//Create the State description under each descriptor
		//( numberOfItem is the remaining number of items left if this descriptor is choosen )
		function creatState(state,descriptor,numberOfItem,row,isHistory){
			var button_submit = $("#button_submit");
			var button_reset_submit = $("#button_reset_submit");
			var stringToAppend = '';
			var classe = "";
			var numberOfitemStr = "";
			var style = "";
			var relativeScore = Math.round((1 - (numberOfItem/everyItems.length)) *100);
			if ( mkey.graphicDisplayRemainingItem ){
				style = getStyle(relativeScore);
			}
			else{
				if ( numberOfItem == 0 ){
					classe = "invalidDescriptor'";
				}
			}
			
			if ( mkey.showNumberOfRemainingItem && numberOfItem >= 0){
				numberOfitemStr = "("+numberOfItem+")";
			}
			
			row.addClass(classe);
		//	toAppend +=	"<tr class='state "+classes+" ' data-descriptorid=S"+descriptor.id+" data-stateid="+state.id+" >";
		//	toAppend += "</tr>";
			stringToAppend += "<td class='picture'>";
			//If ressources
			var rIds = state.resourceIds;
			if ( rIds.length > 0  ){
				stringToAppend += "<img src='"+ resources[rIds[0]].url +"' alt='"+state.name+"' class='min-picture' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";' />";
			}
			else{
				stringToAppend += "<img src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' class='min-picture' />";
			}
			stringToAppend += "</td>";//End picture
			stringToAppend += "<td class='state-text' >";
			stringToAppend += "<strong class='state-title'>"+state.name+"</strong><br /><div style="+style+"></div><span style='clear:rigth;'>"+numberOfitemStr+"</span>";
			if ( state.detail != null && state.detail != "null" && state.detail != "_"){
				stringToAppend += "<p>"+state.detail+"</p>";
			}
			stringToAppend += "</td>";//End state-text
			stringToAppend += "<td class='button'></td>";
		
			row.append(stringToAppend);
			
			
			//bind Event
			var bol = isBoolean(isHistory);
			if ( bol != undefined && bol ){
				row.click(function(){	  
				      $(this).toggleClass('active');		   
				  });
			}
			//Case for Default interface div design
			else{
				// Selection des etats
				row.click(function(){	  
				      active_states_count += ($(this).hasClass('active') ? -1 : 1);
				      $(this).toggleClass('active');
				      // Afficher / masquer le bouton Submit
				      if (active_states_count > 0) {
				    	  button_submit.fadeIn();
				    	  button_reset_submit.fadeIn();
				      } else {
				    	  button_submit.fadeOut();
				    	  button_reset_submit.fadeOut();
				      }
				      
				      if (  $('#D'+descriptor.id).nextUntil('.descriptor').hasClass("active") ){
				    	  if ( descriptorsToSubmit.indexOf(descriptor.id) < 0 ){
				    		  descriptorsToSubmit.push(descriptor.id);
				    	  }
				      }else{
				    	  if ( descriptorsToSubmit.indexOf(descriptor.id) >= 0 ){
				    		  descriptorsToSubmit.splice(descriptorsToSubmit.indexOf(descriptor.id),1);
				    	  }
				      }
				      
				      return false;
				      // Afficher / masquer les operateurs logiques
			//	      if (active_states_count > 1) {
			//	          $parent_descriptor.find('.descriptor-operators').fadeIn(300);
			//	      } else {
			//	          $parent_descriptor.find('.descriptor-operators').fadeOut(300);
			//	      }
				      
				  });
			}
		}
		
		
		/**
		 * Create For each State a carousel image containing one or more (possibility) resources representing
		 * this descriptor
		 *  state, the state to represent
		 *  descriptor, the descriptor having this state
		 *  numberOfItem, the remaining item if this stat is selected
		 *  rowDiv, the div containing this state carousel
		 *  spanType, the span* type in bootstrap row-fluid context or row
		 */
		function creatStateRow(state,descriptor,numberOfItem,rowDiv,spanType) {
			
			var stringToAppend = '';
			var classes = "";
//			var numberOfitemStr = "";
		//	var relativeScore = Math.round((numberOfItem/everyItems.length)*100);
			if ( mkey.graphicDisplayRemainingItem ){
		//		style = getStyle(relativeScore);
			}
			else{
				if ( numberOfItem == 0 ){
					classes = "class='state invalidDescriptor'";
				}
			}
			
//			if ( mkey.showNumberOfRemainingItem && numberOfItem >= 0){
//				numberOfitemStr = "("+numberOfItem+")";
//			}
		
			
			
			classes += "class='"+spanType+" carousel slide stateDescription'";
			stringToAppend += "<div id='S"+state.id+"' "+classes+" value='"+state.id+"'>";
			stringToAppend += '<div class="carousel-inner" style="cursor:pointer;">';
			stringToAppend += '<div class="item active">';
			//If ressources
			var rIds = state.resourceIds;
			if ( rIds.length > 0 ){
//				style='height:auto;'
		//		stringToAppend += "<img style='height:auto;' src='"+ resources[rIds[0]].url +"' alt='"+state.name+"' onerror='replaceSrcImg(\""+resources[rIds[0]].url+"\")' />";
				stringToAppend += "<img src='"+ resources[rIds[0]].url +"' alt='"+state.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";
			}
			else{
				stringToAppend += "<img src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' class='picture'  alt='"+state.name+"' />";
			}
			
			//Add caption
			stringToAppend += "<div class='carousel-caption legendState' style='padding:5px;'>";
			stringToAppend += "<h4>"+state.name+" "+rIds.length+"</h4>";
		//	stringToAppend += "<p class='under-legend-State'>"+state.detail+"</p>";
			stringToAppend += "</div>";//End carousel-caption	
			stringToAppend += "<div class='legendStateTop'>";
			stringToAppend += "<i class='icon-ok icon-light '></i>";
			stringToAppend += "</div>";//End legendStateTop	
			
			
			stringToAppend += "</div>";//End item
			stringToAppend += "</div>";//End carousel-inner
		
			
			stringToAppend += "</div>";//End carousel
			
			rowDiv.append(stringToAppend);	
		}
		
		/**
		 * Same as creatStatRow but with the descriptor ( used for quantitativeDescriptor )
		 */
		function creatDescriptorRow(descriptor,numberOfItem,rowDiv,spanType){
			
			var stringToAppend = '';
			var classes = "";
//			var numberOfitemStr = "";
			
			if ( numberOfItem == 0 ){
				classes = "class='state invalidDescriptor'";
			}
			
			
//			if ( mkey.showNumberOfRemainingItem && numberOfItem >= 0){
//				numberOfitemStr = "("+numberOfItem+")";
//			}
		
			
			
			classes += "class='"+spanType+" carousel slide stateDescription'";
			stringToAppend += "<div "+classes+" >";
			stringToAppend += '<div class="carousel-inner" style="cursor:pointer;">';
			stringToAppend += '<div class="item active">';
			//If ressources
			var rIds = descriptor.resourceIds;
			if ( rIds.length > 0 ){
				stringToAppend += "<img style='height:auto;' src='"+ resources[rIds[0]].url +"' alt='"+descriptor.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";
			}
			else{
				stringToAppend += "<img style='height:auto;' src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' class='picture'  alt='"+descriptor.name+"' />";
			}
			
			stringToAppend += "</div>";//End item
			stringToAppend += "</div>";//End carousel-inner
			stringToAppend += "</div>";//End carousel
			
			rowDiv.append(stringToAppend);	
		}
		
		//TODO add the remainingItemBar in the this.rowDisplay interface
		function createRemainingItemBar(){
			var toAppend = "";
		//	var w  = $('#itemDivDisplay .block-header').width();
			toAppend += '<div style="overflow:hidden;display: inline-block;position: relative;">';
			toAppend += '<div class="remainingItemBar"></div>';
			toAppend += '</div>';
			$('#itemDivDisplay .block-header').append(toAppend);
		    var w  = $('#itemDivDisplay .block-header').width() - 48 - $('#itemDivDisplay .block-header .block-title').width() - $('#itemDivDisplay .block-header .block-total').width();
		    var t = $('#itemDivDisplay .block-header').height()/2;
		    $('#itemDivDisplay .remainingItemBar').css('width',w);
		    $('#itemDivDisplay .remainingItemBar').parent().css('top',t);
		//	$('#itemRowDisplay').append(div);
			updateRemainingItemBar();
			
		}
		
		//Create an Entry in the History view base on this description
		function creatHistoryEntry(description,index){
			var index_description = index;
			if ( index_description == undefined ){
				index_description = descriptions.length - 1;
			}
			var descriptor = description.descriptor;
			var stateIds = description.selectedStates;
			var qMeasure = description.quantitativeMeasure;
			
		
			var row = $('<tr class="descriptor descriptionHistory" id="DescriptionD'+descriptor.id+'" data-indexdescription="'+index_description+'"></tr>');
			var toAppend = '<td class="descriptor-text" colspan="2">';
			toAppend += '<strong class="descriptor-title">'+descriptor.name+'</strong>';
			toAppend += '</td>';//End Descirptor-text
			toAppend += '<td class="button"></td>';
		
		
			row.append(toAppend);
			$('#id-history-descriptorsList').append(row);
			
			var deleteButton = $('<i class="icon-remove icon-large messageTooltip" data-message="message_helpDelete" ></i>');
			var editButton = $('<i class="icon-edit icon-large messageTooltip" data-message="message_helpChangeDescription" ></i>');
		
			toAppend = "";
			//Categorical Type
			if ( descriptor.categoricalType ){
				for ( var i=0; i < stateIds.length ; i++ ){
					var state = states[stateIds[i]];
					toAppend += '<tr class="state">';
					toAppend += '<td class="picture">';
					if ( state.resourceIds.length > 0){
						var resource = resources[state.resourceIds[0]];
						toAppend += '<img src="'+resource.url+'" alt="'+state.name+'"  class="min-picture"/>';
					}
					else{
						toAppend += '<img src="http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png" class="min-picture" />';
					}
					toAppend += '</td>';//End picture
					toAppend += '<td class="state-text">';
					toAppend += '<strong class="state-title">'+state.name+'</strong>';
					toAppend += '</td>';//End State text
					toAppend += '<td class="button"></td>';
					toAppend += '</tr>';//End State
				}
			}
			else if (descriptor.quantitativeType ){
				row.addClass("numerical");
				toAppend += '<tr class="state numerical">';
				toAppend += '<td class="picture"></td>';
				toAppend += '<td class="state-text">';
				toAppend += '<strong>'+qMeasure.value+'</strong>'+descriptor.unit;
				toAppend += ' </td>';
				toAppend += ' <td class="button"></td>';
				toAppend += ' </tr>';
				
			}
			else{
//				alert("Unknown descriptor Type");
				console.warn("Unknown descriptor Type");
			}
		
			
			$('#id-history-descriptorsList').append(toAppend);
			
			$('#DescriptionD'+descriptor.id+' .button').append(editButton);
			$('#DescriptionD'+descriptor.id+' .button').append(deleteButton);
			
			//Bind event
			deleteButton.click(function() {
				$("#edit-history").fadeOut();
				var ind = parseInt(row.attr("data-indexDescription"));
				descriptions.splice(ind,1);		
				changeDescriptionHistory();
			});
			
			editButton.click(function(){
				setPositionEditHistory();
				createEditHistory($("#edit-history"),description,index_description);
				$("#edit-history").fadeIn();
				mkey.mkeyLang.updateLang("#edit-history");
			});
			
			//Set the Span Message (update only the str passed as selector)
			mkey.mkeyLang.updateLang('#DescriptionD'+descriptor.id);
		} 
		
		/**
		 * Create the History Edit UI in the block element
		 * @param element (block)
		 */
		function createEditHistory(element,description,indexDescription){
			var descriptor = description.descriptor;
			var stateIds = description.selectedStates;
			var qMeasure = description.quantitativeMeasure;
			var allStatRow = [];
			
			var header = element.find(".block-header");
			var content = element.find(".block-content");
			var bottomDiv = element.find(".buttonDiv");
		
			//Empty the editHistory Div
			header.empty();
			content.empty();
			bottomDiv.empty();
			
		
			//remove the height parameter
			header.css("height","auto");
			
			var warning = $("<strong class='warning_message'><i class='icon-warning-sign'></i>  <span class='message' data-message='message_warning_changeDescription'></span></strong>");
			
			header.append(warning);
			
			var table = $("<table class='descriptors' style='border-bottom: 5px solid #DDDDDD;'></table>");
		
			
			var toAppend = "<tr class='descriptor'>";
		
			toAppend += "<td class='picture'>";
		
			//If ressources
			var dIds = descriptor.resourceIds;
			if ( dIds.length > 0  ){
				toAppend += "<img src='"+ resources[dIds[0]].url + "' alt='"+descriptor.name+"' style='max-width: 140px;' />";
			}
			else{
				toAppend += "<img src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' style='max-width: 140px;' />";
			}
			toAppend += "</td>";//End Td img
			toAppend += "<td class='descriptor-text' colspan='2'>";
		
			//Descriptor name
			toAppend += "<strong class='descriptor-title'>"+descriptor.name+"</strong>";
			if ( descriptor.detail != null && descriptor.detail != "null" && descriptor.detail != "_"){
				toAppend += "<p>"+descriptor.detail+"</p>";
			}
			toAppend += "<div class='descriptor-operators'>";	
		
			//		<a href="#" class="active">AND</a> / <a href="#">OR</a> / <a href="#">XOR</a> / <a href="#">NOT</a> / <a href="#">NOR</a> / <a href="#">NXOR</a>
			toAppend += "</div>";//end descriptor-operator
			toAppend += "</td>";//End Descriptor-text
		//	toAppend += "<td class='button'><button class='btn btn-success'>Submit</button></td>";//Submit button
			toAppend +=	"</tr>";//End descriptor row
			
			table.append(toAppend);
			header.append(table);
			
			table = $("<table class='descriptors' ></table>");
		
			//List states add FOR
			//if descriptor is categorical
			if ( descriptor.categoricalType ){
				$.each(descriptor.stateIds,function(index2,stateID){
					var active = "";
					if ( $.inArray(stateID, stateIds) > -1 ){
						active = "active";
					}
					var newRow = $("<tr class='state visible "+active+"' data-stateid='"+states[stateID].id+"'></tr>");
					//Get ref to the stat row
					allStatRow.push(newRow);
					
					//Append in the table
					table.append(newRow);
					creatState(states[stateID],descriptor,-1,newRow,true);
				});
				
			}
			else if (descriptor.quantitativeType ){
				
		//		descriptorTR.addClass("numerical");
				var newRow = $('<tr class="state numerical active visible"></tr>');
				
				toAppend = '<td class="picture"></td>';
				toAppend += '<td class="state-text">';
				toAppend += '<input type="number" min="0" step="0.5" value="'+qMeasure.value+'" name="numerical_value" style="width: 50px">'+descriptor.unit;
				toAppend += ' </td>';
				toAppend += ' <td class="button"></td>';
		
				
				newRow.append(toAppend);
				table.append(newRow);
		        
		        //Bind Event
		        newRow.find('input[name=numerical_value]').keyup(function(){
		        	if ($.isNumeric($(this).val())) {
		        		newRow.addClass('active');
		        	} else {
		        		newRow.removeClass('active');
		        	}
		    	}); 
			}
			else{
//				alert("Unknown descriptor Type");
				console.warn("Unknown descriptor Type");
			}
			
			content.append(table);
			
			//Add Button
			var buttonCancel = $("<button class='btn' style='margin-right:10px;'>Cancel</button>");
			var buttonChange = $("<button class='btn btn-warning'>Change</button>");
			
			bottomDiv.append(buttonCancel);
			bottomDiv.append(buttonChange);
			
			element.append(bottomDiv);
			
			//Bind Event
			buttonCancel.click(function(){
				element.fadeOut(function(){
					table.remove();
					warning.remove();
					buttonCancel.remove();
					buttonChange.remove();
				});
			});
			
			buttonChange.click(function(){
				var selectedStatesIdsDesc = [];
				var quantitativeMeasureDesc = undefined;
				//Get the new description
				if ( descriptor.categoricalType ){
					
					$.each(allStatRow,function(index1,row){
						if ( $(row).hasClass("active")){
							selectedStatesIdsDesc.push(parseInt($(row).attr("data-stateid")));
						}
					});
					//If no state selected return false and remove descriptor from history
					if ( selectedStatesIdsDesc.length == 0 ){
						//remove description at position (index)
						descriptions.splice(indexDescription,1);
						changeDescriptionHistory(function(){
							element.fadeOut(function(){
								table.remove();
								warning.remove();
								buttonCancel.remove();
								buttonChange.remove();
							});
						});
						return false;
					}
				}
				else if ( descriptor.quantitativeType ){
					quantitativeMeasureDesc = {
							value : $('#edit-history .state.numerical.active').find('input[name=numerical_value]').val()
					};
					//If no state selected return false and remove descriptor from history
					if ( quantitativeMeasureDesc.value == "" ){
						//remove description at position (index)
						descriptions.splice(indexDescription,1);
						changeDescriptionHistory(function(){
							element.fadeOut(function(){
								table.remove();
								warning.remove();
								buttonCancel.remove();
								buttonChange.remove();
							});
						});
						return false;
					}
				}
				else{
//					alert("Unknow descriptor type");
					console.warn("Unknow descriptor type");
				}
				
				// Create a new description
				var description = {
					descriptor : descriptor,
					selectedStates : selectedStatesIdsDesc,
					quantitativeMeasure : quantitativeMeasureDesc
				};
				
				//Change description at position (index)
				descriptions.splice(indexDescription,1,description);
				
				//Call Ajax function for recalculating the description
				changeDescriptionHistory(function(){
					element.fadeOut(function(){
						table.remove();
						warning.remove();
						buttonCancel.remove();
						buttonChange.remove();
					});
				});
			});
			
		}
		

		function addDescriptionInWindow(item){
			if ( descriptionWindow == undefined || descriptionWindow.closed ){
				descriptionWindow = window.open('description_page.html','',"location=no,menubar=no,status=no,titlebar=no",false);
			}		
			descriptionWindow.focus();
			setTimeout(function(){
				creatCardItemForDescriptionWindow(item);
			},100);
		}
		
	
		/**
		 * Construct the end identification interface, showing history, remaining items, similare items, ect
		 * @param items, an array of remaining item
		 */
		function createEndIdentification(Ritems) {
			mkey.endIdentification = true;
			var blackFont = $("#blackFont");
			//Show the blackFont div
			blackFont.css("display","block");
			
			//disable Jcrop
			if ( typeof jcrop_api != "undefined" ){
				jcrop_api.destroy();
			}
			
			
// vrolland 29-08-14 ----------------------------------				
			var enddesc_listaxa = $("#endDescription-listaxa").empty();
			var descriptionDiv = $("#endDescription");
			var first = true;
			var page;

		    page = $('<ul class="endDescription-listaxa-sublist"></ul>');
		    enddesc_listaxa.append(page);
			
			$.each(Ritems,function(index,rID){
	
				var res = resources[rID.resourceIds[0]];
				var stringToAppend = "";

				var div = $("<li class='picture' index='"+index+"' value='"+rID.id+"' ></li>");
				stringToAppend += "<img src='"+ (res==undefined ? 'http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' : res.url) +"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";
//				stringToAppend += '<div class="legendTaxonTop"><i class="icon-ok icon-light "></i></div>';
				
				div.append($(stringToAppend));
				page.append(div);
				
				div.find('img').load(function(){ // avoid bug on windows
					$(this).after('<div class="legendTaxonTop"><i class="icon-ok icon-light "></i></div>');
				});
				
				//  taxon description and pictures ------------------------
				div.bind("divtaxonmouseenter", function(event,data){
					var taxonchoosen = Ritems[parseInt(data.me.attr('index'))]; 
					
					$("#endDescription-taxonname").html(taxonchoosen.name);
					
					var endDescription_detail = $("#endDescription-details").empty();
					
		 // Taxa Confusion :
		console.log(taxonchoosen);
		if(taxonchoosen.taxaConfusion.length != 0) {					
				var dl_taxa_conf = $("<dl class='warning-confusion'></dl>")
				if(taxonchoosen.taxaConfusion.length != 0) {
				    dl_taxa_conf.append($("<dt ><i class='icon-warning-sign'></i> Confusion possible avec  : </dt>"));
				    for ( var i=0; i<taxonchoosen.taxaConfusion.length;i++){
				    	var newlineconf = $("<dd idtaxaconfusion='"+taxonchoosen.taxaConfusion[i]+"' ><a href='#'>" + Ritems[taxonchoosen.taxaConfusion[i]].name + "</a></dd>");
				    	dl_taxa_conf.append(newlineconf);
				    	newlineconf.click(function(){ 
					  	      createCardItem(items[parseInt($(this).attr('idtaxaconfusion'))],$("#id-item-card"));
					  	      return false;
					  	});
				    }
				}  
		}		
				endDescription_detail.html(taxonchoosen.detail);
				endDescription_detail.prepend(dl_taxa_conf);
							
					
				    // open external link in new page !
					endDescription_detail.find('a').each(function(){ 
				    	   if( this.href.indexOf(window.location.host) == -1 ) {
				    	       $(this).click(function(event) {
				    	           event.preventDefault();
				    	           event.stopPropagation();
				    	           window.open(this.href, '_blank');
				    	       });
				    	   }
				    });
					
					var endDescription_taxonpict = $("#endDescription-taxonpict").empty();
					$.each(taxonchoosen.resourceIds,function(index,rID){
						var res = resources[rID];
						var stringToAppend = "";
						var div = $("<div class='span4 slide stateDescription' ></div>");
						stringToAppend += '<div class="carousel-inner">';
						stringToAppend += "<div class='item active' >";
						stringToAppend += "<img src='"+ res.url +"' alt='"+$.parseHTML(res.name)+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";
						stringToAppend += '</div>';
						stringToAppend += '</div>';
						
						
						div.append($(stringToAppend));
						endDescription_taxonpict.append(div);	
					});	
				});
				
				div.mouseenter(function () {
					$(this).trigger("divtaxonmouseenter", {me:$(this)});
				});
				
				div.click(function(){
					if (  $(this).hasClass("selectedTaxon") ){
						$(this).removeClass("selectedTaxon");
						itemsSelectedForSubmission = jQuery.grep(itemsSelectedForSubmission, function(value) { return value != parseInt(div.attr('value')); });
					}else{
						if(itemsSelectedForSubmission.length > 9) {
							alert("You cannot choose more than 10 taxa.");
						} else {
							$(this).addClass("selectedTaxon");
							itemsSelectedForSubmission.push(parseInt(div.attr('value')));
						}
					}
				});
				

				
				if(first) {
					div.trigger("divtaxonmouseenter", {me:div});
					first = false;
				}
			});
		    
				$('.endDescription-listaxa-sublist').load( function () {
					// Handler for .load() called.
					console.log('ETES');
				});

			
			
			//Add button
			var buttonDiv = $("#buttonOut");
			
			var buttonSend = $("<button class='btn messageTooltip endIdentificationButton' data-message='message_HelpSendIdentification'><span class='message' data-message='message_sendIdentification'></span></button>");
			var buttonCancel = $("<button class='btn message endIdentificationButton' data-message='message_reset' style='margin-left: 5%;'></button>");
			var buttonReturnToHistorique = $("<button class='btn message endIdentificationButton' data-message='message_returnHistorique' style='margin-left: 5%;'></button>");
			
			buttonSend.addClass("btn-success");
			buttonCancel.addClass("btn-danger");
			buttonReturnToHistorique.addClass("btn-warning");
			
			buttonDiv.append(buttonSend);
			buttonDiv.append(buttonReturnToHistorique);
			buttonDiv.append(buttonCancel);
			
			buttonSend.mouseenter(function() {
				var selected = $("#endDescription-listaxa").find('.selectedTaxon');
				
				if(selected.length != 0){
					$(selected[0]).trigger("divtaxonmouseenter", {me:$(selected[0])});
				}
				//div.trigger("divtaxonmouseenter", {me:div});
			});
			
			buttonSend.click(function(){
				if(itemsSelectedForSubmission.length == 0) {
					alert( mkey.mkeyLang.getMessage("message_selectonetaxon") );
					return false;
				}
				loadEndIdentification(); // vrolland 21/07/2014
				$("#preIdentificationSubmitMessage").modal("show");
				
//				console.warn("no implemented yet, An event has been Trigger 'MkeyEnded' with parameter 'history', 'item'");
//				triggerEndIdentification();
			});
			
			buttonCancel.click(function(){
				//Reload page
				window.location.reload();

			});
			
			buttonReturnToHistorique.click(function(){
				descriptions.pop();
				mkey.endIdentification = false;
				changeDescriptionHistory(function(){		
					//Simulate click on history
					$("#nav-li-description a").click();
	
//					descriptionDiv.empty();
					buttonDiv.empty();
					
					
//					similarityDiv.empty();
//					historyGraphDiv.empty();
					blackFont.fadeOut();
				});
			});
			// --------------------------------------
			
			
			
			
// --------------------------------------	
			var rl = $("#remainingItemList").detach();
			$("#similarityList").append(rl);
			
			console.log($(".target").attr("src"));
			
			var img = $("#end-image-container img");
			img.attr("src",$(".target").attr("src"));
			
			mkey.mkeyLang.updateLang("#blackFont");
		}		
		
		
		
		
/* vrolland 29-08-14 ----------------------------------

		/**
		 * Construct the end identification interface, showing history, remaining items, similare items, ect
		 * @param items, an array of remaining item
		 * /
		function createEndIdentification(Ritems) {
			mkey.endIdentification = true;
			var numberOfItemInPagination = 1;
			var div = $("#blackFont");
			//Show the blackFont div
			div.css("display","block");
//			disable Jcrop
			if ( typeof jcrop_api != "undefined" ){
				jcrop_api.destroy();
			}
			
			var descriptionDiv = $("#endDescription").empty();
			var detailDiv = $("#endDescription-detail").empty();
			var buttonDiv = $("#buttonOut");
			var img = $("#end-image-container img");
//			var similarityDiv = $("#similarity");
			var historyGraphDiv = $("#historyGraph");
//			var similarityTitle = $("#title_similarity");
			var historyGraphTitle = $("#title_historyGraph").empty();
			
			//Create Description Panel (carousel inside carousel)
			//If multiple results create a "row display" item view (carousel with remaining items image in the bottom
			//Draw the description of the last remaining items ( if unique )
			var carouselGlobal = $("<div id='carouselGlobal' class='carousel slide targetOfController' data-interval='false'></div>");
			var carouselGlobalInner = $('<div class="carousel-inner"></div>');
			var carouselDetailInner = $('<div class="carousel-inner"></div>');
			var carouselControler = $("<div id='carouselGlobalControler' class='pagination pagination-centered' ></div>");
			var carouselDetail = $("<div class='carousel slide targetOfController' data-interval='false'></div>");
			
			var positionInPatignation = 0;
			
			$.each(Ritems,function(index,item){
				var toAppend = "";
				var addClass = "";
				var itemCarousel = undefined;
				var detailCarousel = undefined;
				var controllerCard = undefined;
				
				if ( index == 0){
					itemCarousel = $('<div class="active item"></div>');
					detailCarousel = $('<div class="active item"></div>');
//					controllerCard = $('<li data-target="#carouselGlobal" data-slide-to="'+index+'" class="active"><div class="legendItemIdentified"></div></li>');
					controllerCard = $('<div data-target=".targetOfController" data-slide-to="'+index+'" data-positionInPagination="'+positionInPatignation+'" class="showedItemPagination active item-in-controller"><div class="legendItemIdentified">'+(index+1)+'|'+ Ritems.length +'</div></div>');
				}
				else{
					if ( (index % numberOfItemInPagination) == 0 ){
						positionInPatignation++;
					}
					
					if ( index > (numberOfItemInPagination-1) ){
						addClass += "hiddenItemPagination";
					}else{
						addClass += "showedItemPagination";
					}
					
					itemCarousel = $('<div class="item"></div>');
					detailCarousel = $('<div class="item"></div>');
//					controllerCard = $('<li data-target="#carouselGlobal" data-slide-to="'+index+'" class=""><div class="legendItemIdentified"></div></li>');
					controllerCard = $('<div data-target="#carouselGlobal" data-positionInPagination="'+positionInPatignation+'" data-slide-to="'+index+'" class="'+addClass+' item-in-controller"><div class="legendItemIdentified">'+(index+1)+'|'+ Ritems.length +'</div></div>');
				}
				
				toAppend += '<div style="text-align:center;"><strong>'+(index+1)+' -- '+item.name+'</strong></div>';
				
				var resource = item.resourceIds;
				//Append the innerCarousel containing every Image for each remaining Items
				if ( mkey.historyGraphDisplay ){
					toAppend += '<div id="id-description-carousel'+index+'" class="carousel slide innerCarouselDescription" data-interval="false">';
				//  <!-- Carousel items -->
					toAppend += '<div class="carousel-inner">';
					if ( resource.length > 0){
						for ( var i=0; i<resource.length;i++){
						  var currentResource = resources[resource[i]];
						  if ( currentResource.type == "image" ){
							  if ( i == 0){
								  //TODO remove buggy onload attribute
							      toAppend += '<div class="active item"><img src="'+currentResource.url+'" alt="'+item.name+'" onerror="this.onerror=null;this.src=\'http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\';" onload="setLeftCarouselItem()" class="picture"/></div>';
								  controllerCard.append('<img src="'+currentResource.url+'" alt="'+item.name+'" class="picture"/>');
							  } 
							  else{
								toAppend += '<div class="item"><img src="'+currentResource.url+'" alt="'+item.name+'" title="'+item.name+'" class="picture" /></div>'; 
							  }
						  }
						  else{
//							  alert("display error, resource is not an image");
							  console.warn("display error, resource is not an image");
						  }
						}
					}
					//If there is no ressource associated
					else{
						//TODO remove buggy onload attribute
						toAppend += '<div class="active item"><img  alt="'+item.name+'" src="http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png" onload="setLeftCarouselItem()" class="picture"/></div>';
						controllerCard.append('<img src="http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png" alt="'+item.name+'" class="picture"/>');
					}
					toAppend += '</div>';//end carousel-inner
					//Carousel control
				    toAppend += '<div class="carousel-controls">';
				    toAppend += '<a class="carousel-control left" href="#id-description-carousel'+index+'" data-slide="prev">&lsaquo; PREV</a>';
				    toAppend += '<a class="carousel-control right" href="#id-description-carousel'+index+'" data-slide="next">NEXT &rsaquo;</a>';
				    toAppend += '</div>';//end carousel-controls
					toAppend += '</div>';//end carousel
				}
				else{
					if ( resource.length > 0){
						for ( var i=0; i<resource.length;i++){
							var currentResource = resources[resource[i]];
							if ( currentResource.type == "image" && i == 0){
								controllerCard.append('<img src="'+currentResource.url+'" alt="'+item.name+'" title="'+item.name+'" class="picture"/>');
							}
						}
					}
					//If there is no ressource associated
					else{
						controllerCard.append('<img src="http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png" alt="'+item.name+'" class="picture"/>');
					}
				}
		//		descriptionDiv.append(toAppend);
				itemCarousel.append(toAppend);
				detailCarousel.append(item.detail);
				
				var descriptionDl = $("<dl></dl>");
				
				itemCarousel.append(descriptionDl);
				
				carouselGlobalInner.append(itemCarousel);
				carouselDetailInner.append(detailCarousel);
				
				createDescription(item,descriptionDl);
				
//				cCu.append(controllerCard);
				carouselControler.append(controllerCard);
				//set in Carousel
				carouselGlobal.append(carouselGlobalInner);
				carouselDetail.append(carouselDetailInner);
			});
		
			//Add Carousel-control (changing Item)
			descriptionDiv.append(carouselControler);
			
			//Finally add the carousel in the div
			descriptionDiv.append(carouselGlobal);
			
			//Add detail in the detailDiv
			detailDiv.append(carouselDetail);
			
			//Set the Img src
			img.attr("src",$("#target").attr("src"));
			
			//Add pagination Button
			var buttonPatignationLeft = $("<button class='btn disabled' id='buttonPaginationLeft'><i class='icon-chevron-left'></i></div>");
			var buttonPatignationRight = $("<button class='btn' id='buttonPaginationRight'><i class='icon-chevron-right'></i></div>");

			carouselControler.prepend(buttonPatignationLeft);
			carouselControler.append(buttonPatignationRight);
			
			//Add Title
//			similarityTitle.append("<span class='message' data-message='message_similarity'></span>");
			historyGraphTitle.append("<span class='message' data-message='message_resourcesDisplay'></span>");
			
			//Add button
			var buttonSend = $("<button class='btn messageTooltip endIdentificationButton' data-message='message_HelpSendIdentification'><span class='message' data-message='message_sendIdentification'></span></button>");
			var buttonCancel = $("<button class='btn message endIdentificationButton' data-message='message_reset' style='margin-left: 5%;'></button>");
			var buttonReturnToHistorique = $("<button class='btn message endIdentificationButton' data-message='message_returnHistorique' style='margin-left: 5%;'></button>");
			
			buttonDiv.append(buttonSend);
			buttonDiv.append(buttonReturnToHistorique);
			buttonDiv.append(buttonCancel);
			
			//Bind Event
			buttonCancel.click(function(){
				//Reload page
				window.location.reload();
				//Reload Identification

			});
			
			
			buttonReturnToHistorique.click(function(){
				descriptions.pop();
				mkey.endIdentification = false;
				changeDescriptionHistory(function(){		
					//Simulate click on history
					$("#nav-li-description a").click();
	
					descriptionDiv.empty();
					buttonDiv.empty();
//					similarityDiv.empty();
					historyGraphDiv.empty();
					div.fadeOut();
				});
			});
			
			
			//Add Click function on pagination button
			buttonPatignationLeft.click(function(){
				if ( !buttonPatignationLeft.hasClass("disabled") ){
					//Add and Remove classes for the old item
					var items = $(".item-in-controller.showedItemPagination");
					items.removeClass("showedItemPagination").addClass("hiddenItemPagination");
					//Add and Remove classes for the new item to show
					var positionToShow = parseInt($(items[0]).attr("data-positionInPagination")) - 1;
					$(".item-in-controller[data-positionInPagination='"+positionToShow+"']").addClass("showedItemPagination").removeClass("hiddenItemPagination");
					//Fire a clik action
					$($(".item-in-controller.showedItemPagination")[0]).click();
					
					//If no more position in the left disabled the button
					if ( positionToShow == 0 ){
						buttonPatignationLeft.addClass("disabled");
					}
					//Remove disabled from the right button
					buttonPatignationRight.removeClass("disabled");
				}
				return false;
			});
			
			buttonPatignationRight.click(function(){
				if ( !buttonPatignationRight.hasClass("disabled") ){
					//Add and Remove classes for the old item
					var items = $(".item-in-controller.showedItemPagination");
					items.removeClass("showedItemPagination").addClass("hiddenItemPagination");
					//Add and Remove classes for the new item to show
					var positionToShow = parseInt($(items[0]).attr("data-positionInPagination")) + 1;
					$(".item-in-controller[data-positionInPagination='"+positionToShow+"']").addClass("showedItemPagination").removeClass("hiddenItemPagination");
					//Fire a clik action
					$($(".item-in-controller.showedItemPagination")[0]).click();
					
					//If no more position in the right disabled the button
					if ( positionToShow == positionInPatignation ){
						buttonPatignationRight.addClass("disabled");
					}
					//Remove disabled from the right button
					buttonPatignationLeft.removeClass("disabled");
				}
				return false;
			});
			
			//IF there is no need to use pagination
			if ( positionInPatignation == 0 ){
				buttonPatignationRight.addClass("disabled");
			}
			
			buttonSend.click(function(){
				loadEndIdentification(); // vrolland 21/07/2014
				$("#preIdentificationSubmitMessage").modal("show");
				
				console.warn("no implemented yet, An event has been Trigger 'MkeyEnded' with parameter 'history', 'item'");
				triggerEndIdentification();
			});
			
			//Not Used in the Default display 
			//Place picture in the middle of the div when sliding ( in the carousel )
			$(".innerCarouselDescription").bind("slid",function(){
				setLeftCarouselItem();
			});
			
			//Not Used in the Default display 
			//Bind Event Carousel Slide
			$("#carouselGlobal").bind("slid",function(){
				//If not active set the first slide of the inner carousel active
				if (!$("#carouselGlobal .active .item").hasClass('active')) {
				    $('#carouselGlobal .active .item:first-child').addClass('active');
				}  
				//replace carousel left position ( middle )
				setLeftCarouselItem();
			});
			
			//Bind event on the min-img ( bottom of the description block )
			carouselControler.click(function(event){
				var elementClicked = $(event.target).closest(".item-in-controller");
				if ( elementClicked.length > 0 ){
					//remove active from old selected li, add active to the new
					$("#endDescription .item-in-controller.active").removeClass("active");
					elementClicked.addClass("active");
					//If not in this.historyGraphDisplay
					if ( !mkey.historyGraphDisplay ){
						var currentSelectedItem = Ritems[elementClicked.attr("data-slide-to")];
						createResourceDisplay(historyGraphDiv,currentSelectedItem.resourceIds);
						//Show rigth detail in the derailCarousel div
						carouselDetail.carousel(parseInt(elementClicked.attr("data-slide-to")));
						carouselDetail.carousel("pause");
					}	
				}
//				return false;
			});
			
			var rl = $("#remainingItemList").detach();
			$("#similarityList").append(rl);
			
			//Create the History Graph
		//	createHistoryGraph();
			
			//Create the Ressources display
			createResourceDisplay(historyGraphDiv,Ritems[0].resourceIds);
			
			//Reload Languages and size
			mkey.mkeyLang.updateLang("#blackFont");
			
		}
*/		
		//Display every ressources from the resources Ids array in the elementTarget DOM, by default 3 resources are display on the same ligne.
		function createResourceDisplay(elementTarget,resourceIds,nbrResourcesPL){
			elementTarget.fadeOut(function(){
				elementTarget.empty();
				var nR = 3;
				if ( isNumber(nbrResourcesPL) ){
					nR = nbrResourcesPL;
				}
				
				if ( resourceIds.length > 0){
				
					var spanT = 12/nR;
					
					if (!elementTarget.hasClass("container-fluid")){
						elementTarget.addClass("container-fluid");
					}
					
					var spanRow = $("<div class='row-fluid'></div>");
					var avance = 0;
					for ( var i = 0; i < resourceIds.length ; i++){
						avance += spanT;
			//			var toApp = $("<div class='span"+spanT+"'><img style='height:auto;width:100%;' src='"+ resources[resourceIds[i]].url +"' alt='"+resources[resourceIds[i]].name+"' onerror='replaceSrcImg(\""+resources[resourceIds[i]].url+"\")' /></div>");
						var toApp = $("<div class='span"+spanT+"'><img style='height:auto;width:100%;' src='"+ resources[resourceIds[i]].url +"' alt='"+resources[resourceIds[i]].name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/></div>");
						spanRow.append(toApp);
						if ( avance >= 12 ){
							avance = 0;
							elementTarget.append(spanRow);
							spanRow = $("<div class='row-fluid'></div>");
						}
					}
					elementTarget.append(spanRow);
				}
		//		style='text-align:center;
				else{
					elementTarget.append("<div class='msg'><span class='message' data-message='message_noRessources'></span></div>");
				}
				if ( elementTarget[0].id.length > 0){
					mkey.mkeyLang.updateLang("#"+elementTarget[0].id);
				}
				else{
					mkey.mkeyLang.updateLang();
				}
				elementTarget.fadeIn();
			});
		}
		
		
		function createHightlightedDescriptor(descriptor){
			var highlightedDescriptor = descriptors[descriptor];
			var stateToSubmit = [];
			
			var containerDiv = $("<div id='containerDivHightlightDescriptor' class='container-fluid'></div>");
			var titleRowDiv = $("<div class='title_hd row-fluid'></div>");
			var titleDiv = $("<div class='span12'></div>");	
			var title = $("<span>"+highlightedDescriptor.name+"</span>");
			titleDiv.append(title);
			titleRowDiv.append(titleDiv);
			
			
			
			var titlePictRowDiv = $("<div class='title_hd row-fluid'></div>");
			var titlePictDiv = $("<div class='span12'><span class='message' data-message='message_hightlightedDescriptor_TitlePict'></span></div>");
			titlePictRowDiv.append(titlePictDiv);		

			
			var titleDescHoverRow = $("<div class='title_hd row-fluid'></div>")
			var titleDescHoverDiv = $("<div class='span12'></div>");
			var titleDescHover = $("<span id='titleDescHover'></span>");
			titleDescHoverDiv.append(titleDescHover);		
			titleDescHoverRow.append(titleDescHoverDiv);		
//			var subTitleRowDiv = $("<div class='subTitle_hd row-fluid'></div>");
//			var subTitleDiv = $("<div class='span12'></div>");

//			var subTitle = $("<span class='message' data-message='message_hightlightedDescriptor_subTitle'></span>");		
//			subTitleDiv.append(subTitle);
//			subTitleRowDiv.append(subTitleDiv);
			
			
			var stateDivContainer = $("<div class='container-fluid'></div>");
			var stateDivRow = $("<div class='row-fluid first-desc-line' ></div>");
			
			
			stateDivRow.append($("<div class='span3 empty'></div>")); // add a padding on left
			if ( highlightedDescriptor.categoricalType ){
				$.each(highlightedDescriptor.stateIds,function(index){
					var state = states[highlightedDescriptor.stateIds[index]];
					var resourceIds = state.resourceIds;
					var stringToAppend = "";
					var classes = "class='span1 carousel slide stateDescription' value='"+index+"'";
					var div = $("<div "+classes+" ></div>");
//					stringToAppend += "<div "+classes+" >";
					stringToAppend += '<div class="carousel-inner" style="cursor:pointer;">';
					stringToAppend += '<div class="item active">';
					
					//Add a clickable image for each state
					if ( resourceIds.length > 0 ){
						stringToAppend += "<img style='height:auto;border-radius: 35%;' class='picture' src='"+ resources[resourceIds[0]].url +"' alt='"+state.name+"' onerror='this.onerror=null;this.src=\"http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png\";'/>";
					}else{
						stringToAppend += "<img style='height:auto;border-radius: 35%;' src='http://identificationkey.fr/mkeyplus/img/defaultThumbnail.png' class='picture'  alt='"+state.name+"' />";
					}
					
					//Add caption
//					stringToAppend += "<div class='carousel-caption legendState' style='padding:5px;'>";
//					stringToAppend += "<h4>"+state.name+"</h4>";

//					stringToAppend += "</div>";//End carousel-caption	

					stringToAppend += "<div class='legendStateTop'>";
					stringToAppend += "<i class='icon-ok icon-light '></i>";
					stringToAppend += "</div>";//End legendStateTop	
					
					stringToAppend += "</div>";//End item
					stringToAppend += "</div>";//End carousel-inner
//					stringToAppend += "</div>";//End carousel
					
					div.append(stringToAppend);
					div.click(function(){
						var indexStat = stateToSubmit.indexOf(state.id);
						if (  indexStat < 0 ){
							stateToSubmit.push(state.id);
							$(this).addClass("selectedState");
						}else{
							stateToSubmit.splice(indexStat,1);
							$(this).removeClass("selectedState");
						}
					});
					
					div.mouseenter(function(){
						$("#titleDescHover").text(state.name);

						$("#imageExampleDesc").empty();
						$.each(resourceIds,function(index){
							if(index < 6 ) {
								$("#imageExampleDesc").append($("<div class='span2 carousel slide'><div class='carousel-inner'><div class='item active'><img   src='"+ resources[resourceIds[index]].url +"' /></div></div></div>"));
							}
						});
					});
					
//					div.mouseleave(function(){
//						$("#titleDescHover").text("");
//						$("#imageExampleDesc").empty();
//					});
					
					stateDivRow.append(div);
					if ( index != 0 && index%6 == 0 ){
						stateDivContainer.append(stateDivRow);
						stateDivRow = $("<div class='row-fluid'></div>");
					}
				});
				
			
				var button_continue = $("<div><button class='btn btn-large btn-continue'><span class='message' data-message='message_continue'></span></button>");
				
				button_continue.mouseenter(function(){
						var selected = $(".first-desc-line").find(".selectedState");
						
						if(selected.length != 0){
							var index = $(selected[0]).attr('value')
							var state = states[highlightedDescriptor.stateIds[index]];
							var resourceIds = state.resourceIds;
							
							$("#titleDescHover").text(state.name);

							$("#imageExampleDesc").empty();
							$.each(resourceIds,function(index){
								if(index < 6 ) {
									$("#imageExampleDesc").append($("<div class='span2 carousel slide'><div class='carousel-inner'><div class='item active'><img   src='"+ resources[resourceIds[index]].url +"' /></div></div></div>"));
								}
							});
						}
				});
				
				var buttonDiv = $("<div class='span1 carousel slide'></div>");
				buttonDiv.append(button_continue);
				stateDivRow.append(buttonDiv); // add a padding on left
			}
			else{
//				alert("Hightligth do not support non categorical descriptors");
				console.warn("Hightligth do not support non categorical descriptors");
				return;
			}
			
			stateDivContainer.append(stateDivRow);
			
			// vrolland	18-08-2014 ---------------------
			var imgloader = $("<span id='image-container-hightlighted' class='messageTooltip image-container' title='' data-message='message_helpCrop'> \
									<img id='target-hightlighted'  class='target' src='./img/defaultThumbnail.png' alt='image' style='vertical-align: top;width:auto;'/> \
								</span> \
								<form  id ='sendImageForm-hightlighted' class='sendImageForm' classaction='#' method='post' enctype='multipart/form-data'> \
									<input type='file' name='file' id='file-hightlighted' onchange='javascript:loadImage(true);'/><br> \
								</form> \
								<button id='reset-load-image-hightlighted' class='btn messageTooltip reset-load-image' data-message='message_helpEraseImg' style='display:none;'><i class='icon-remove'></i></button>");
	
			
				var imgexampleRowDiv  = $("<div class='row-fluid'></div>");
				var imgexampleContfluid  = $("<div class='container-fluid' style='float: none; margin: 0 auto;' id='imageExampleDesc'></div>")
				
				imgexampleRowDiv.append(imgexampleContfluid);
			// ------------------------------------------
			
			quantitativeMeasure = undefined;
			
			button_continue.click(function(){
				//If no state selected add history with every stat selected
				if(stateToSubmit.length == 0){
					stateToSubmit = highlightedDescriptor.stateIds;
				}
				//else set history and hide	
				
				// Create a new description
				var description = {
					descriptor : highlightedDescriptor,
					selectedStates : stateToSubmit,
					quantitativeMeasure : quantitativeMeasure
				};
				
				
				var descriptionElementStateJSON = {
					selectedStatesNames : stateToSubmit,
					quantitativeMeasure : quantitativeMeasure
				};
				
				var descriptionJSON = {};
				var submittedDescription = [];
				
				descriptionJSON[highlightedDescriptor.id] = descriptionElementStateJSON;
				
				submittedDescription.push(descriptionJSON);
				
				// add the description in Descriptions
				descriptions.push(description);
				
				//Creat the Html
				creatHistoryEntry(description);
				
				//Get remaining Items
				getRemainingItemsAndRemainingDescriptors(submittedDescription);
				
				containerDiv.remove();
				
			});
			// vrolland 18-08-2014
			containerDiv.append(titlePictRowDiv);
			containerDiv.append(imgloader);
			// -----------------------------------
			containerDiv.append(titleRowDiv);
//			containerDiv.append(subTitleRowDiv);
			containerDiv.append(stateDivContainer);
			// vrolland 18-08-2014
			containerDiv.append(titleDescHoverRow);
			containerDiv.append(imgexampleRowDiv);

			// -----------------------------------

			$("body").append(containerDiv);

			// vrolland 18-08-2014			
			// Init image user if it's present
			var ImageUserFromURL =  Mkey.prototype.getURLAnchorParameter('urlimageuser');
			if(ImageUserFromURL) {
				LoadImageFromUrl(ImageUserFromURL);
			}
			
			$(".reset-load-image").click(function(){
				$(".image-container").empty();
				$(".image-container").append('<img id="target" src="./img/defaultThumbnail.png" alt="image" style="width: auto;"/>');
				$('.reset-load-image').fadeOut();
				$('.sendImageForm').css("display","block");
				$("#file-hightlighted").val('');
			});
			// -----------------------------------
			
			mkey.mkeyLang.updateLang("#containerDivHightlightDescriptor");
		}
		
		//Escape special character
		function escapeCharacter(){
			//descriptors
			for ( var i = 0 ; i < descriptors.length ; i++){
				descriptors[i].name = $("<esc/>").text(descriptors[i].name).html();
//				descriptors[i].detail = $("<esc/>").text(descriptors[i].detail).html();
			}
			//Item
//			for ( var i = 0 ; i < items.length ; i++ ){
//				items[i].name = $("<esc/>").text(items[i].name).html();
//				items[i].detail = $("<esc/>").text(items[i].detail).html();
//			}
			//State
//			for ( var i = 0 ; i < states.length ; i++ ){
//				states[i].name = $("<esc/>").text(states[i].name).html();
//				states[i].detail = $("<esc/>").text(states[i].detail).html();
//			}
		}
		
		
		function createHistoryGraph(){
			var dim = computeDimension();
			 var chart = new Highcharts.Chart({
			        chart: {
			            renderTo: 'historyGraph',
			            width : dim.w,
			            //do not resize the graph
			            reflow : false,
			            margin : [10,10,10,10],
			            events: {
			                load: function () {
			                    // Draw the flow chart
			                    var ren = this.renderer,
			                        colors = Highcharts.getOptions().colors,
			                        rightArrow = ['M', 0, 0, 'L', dim.wa, 0, 'L', dim.wa-5, 5, 'M', dim.wa, 0, 'L', dim.wa-5, -5],
		//	                        leftArrow = ['M', 100, 0, 'L', 0, 0, 'L', 5, 5, 'M', 0, 0, 'L', 5, -5],
			                    	discardedItemsArrow = ['M',0,0,'L',0,dim.hai,'L',-5,dim.hai-5,'M',0,dim.hai,'L',5,dim.hai-5],
			                    	cross = ['M',0,0,'L',10,10,'M',0,0,'L',-10,10,'M',0,0,'L',10,-10,'M',0,0,'L',-10,-10];
			                    
			                    //Begin graph 10 ( margin ) + half of the arrow width ( used to compute discardedItem width )
			                    var posX = 10+dim.wa/2;
			                    
			                    
			                    // Separator, Descriptors from remaining items
			                    ren.path(['M', dim.wdb, dim.posTy, 'L', dim.wdb, dim.areaH]).attr({
			                            'stroke-width': 2,
			                            stroke: 'silver',
			                            dashstyle: 'dash'
			                        }).add();
			                    
			                    
			                    // Headers
			                    ren.label('Descriptors', dim.posTx, dim.posTy).css({
			                            fontWeight: 'bold'
			                        }).add();
			                    
			                    ren.label('Remaining Items', dim.posTx2, dim.posTy).css({
			                            fontWeight: 'bold'
			                        }).add();
			        
			                    
			                    var label = "";
			                    //The Computed heigth of the graph
			                    var h = 0;
			                    h += dim.posAIy;
			                    for ( var i = 0 ; i < descriptions.length ; i++){
			                    	
			                    	
			                    	label = descriptions[i].descriptor.name;
			                    	//If the size of the label (length*font size) > width add br
			                    	if ( label.length * 12 > dim.wd){
			                    		var authorizedSize = parseInt(dim.wd/6) + 1; 
			                    		if (label[authorizedSize-1] === " " | label[authorizedSize] === " " | label[authorizedSize] == undefined){
			                    			label = label.splice(authorizedSize,0,"<br />");
			                    		}
			                    		else{
			                    			label = label.splice(authorizedSize,0,"-<br />-");
			                    		}
			                    	}
			                    	
			                    	//Add a description Square
			                    	ren.label(label, posX, dim.posDy).attr({
			                            fill: colors[0],
			                            stroke: 'white',
			                            'stroke-width': 2,
		//	                            padding: 5,
			                            r: 5,
			                            width : dim.wd
			                        }).css({
			                            color: 'white'
			                        }).add().shadow(true);
			                    	
			                    	//Add the arrow pointing on discardedItems
				                    ren.path(discardedItemsArrow)
				                         .attr({
				                             'stroke-width': 2,
				                             stroke: colors[1]
				                         }).translate(posX + dim.wd/2 , dim.posAIy).add();
				                    
				                    
				                    
				                    ren.text("Discarded Items",posX + dim.wd/2 ,dim.posDTy+dim.hdit/2)
				                    .attr({zIndex: 3,align:'center'})
				                    .css({fontWeight: 'bold'})
				                    .add();
				                    
				                    ren.rect(posX,dim.posDTy, dim.wd , dim.hdit ,5)
				                    .attr({
				                        'stroke-width': 1,
				                        stroke: '#C7C19D',
				                        fill: '#E5E5E5'
				                    }).
				                    add().shadow(true);
		
				                    var hPos = dim.posRy + 10 + 14;
				                    
				                    //Add each discardedItems name
				                    $("#remainingItemList .eliminated[indexdel='"+(i+1)+"']").each(function(){
				                    	var item = items[parseInt(this.id.slice(1))];
				                    	var elem = ren.text(item.name,posX + dim.wa,hPos)
				                    	//Add attribute
				                    	.attr({zIndex: 3,cursor : 'pointer',align:'center'})
				                    	//Bind Event
				                    	.on('click',function(){
				                    		createCardItem(item,$("#id-item-card"));
				                    	})
				                    	.on('mouseover',function(){
				                    		elem.css({color:"#a0ca54"});
				                    		setTimeout(function(){
				                    			elem.css({color:"black"});
				                    		},100);
				                    	})
				                    	//Add to the canvas
				                    	.add();
				                    	hPos += 14;
				                    	h += 14;
				                    });
				                    
				                    //Add the rect embdebing the discardedItem list
				                    ren.rect(posX - dim.wa/2, dim.posRy,dim.wrib,hPos - ( dim.posRy )  ,5).attr({
				                        'stroke-width': 1,
				                        stroke: '#C7C19D',
				                        fill: '#E5E5E5'
				                    }).add();
				                    
				                    
				                    
				                    //Add the cross on the discardedItems arrow
				                    ren.path(cross)
				                         .attr({
				                             'stroke-width': 2,
				                             stroke: colors[3]
				                         }).translate(posX + dim.wd/2 , dim.posAIy + dim.hai/2).add();
				                    
				                    posX += dim.wd + 20;
				                    
				                    if ( i == descriptions.length - 1){
					                    //Add the arrow linking to the next description
					                    ren.path(rightArrow)
					                         .attr({
					                             'stroke-width': 2,
					                             stroke: colors[2]
					                         }).translate(posX, dim.posAy).add();
				                    } 
				                    else{
				                    	
					                    //Add the arrow linking to the next description
					                    ren.path(rightArrow)
					                         .attr({
					                             'stroke-width': 2,
					                             stroke: colors[3]
					                         }).translate(posX, dim.posAy).add();
				                    }
				                    
				                    
				                    posX += dim.wa + 10 ;
			                    	
			                    }  
		
			                    
			                    var hPos = dim.posDy + 20;
		
			                    $.each(remainingItems,function(){
			                    	var item = this;
			                    	var elem = ren.text(item.name,posX + dim.wrib/2,hPos)
			                    	//Add attribute
			                    	.attr({zIndex: 3,cursor : 'pointer',align:'center'})
			                    	//Bind Event
		                    		.on('click',function(){
			                    		createCardItem(item,$("#id-item-card"));
			                    	})
			                    	.on('mouseover',function(){
			                    		elem.css({color:"red"});
			                    		setTimeout(function(){
			                    			elem.css({color:"black"});
			                    		},100);
			                    	})
			                    	//Add to the canvas
			                    	.add();
			                    	hPos += 14;
			                    });
		                    	
			                    //Add the rect embdebing the remaining Item list
			                    ren.rect(posX, dim.posDy , dim.wrib, hPos - dim.posDy ,5).attr({
			                        'stroke-width': 2,
			                        stroke: 'white',
			                        fill: '#a0ca54'
			                    }).add().shadow(true);
			                    
		//                    	var h = remainingItem.length * 12;
		                    	this.setSize(dim.w,h);
			                }
			            }
			        },
			        title: {
			            text: 'History Graph'
			        }   
			    });
			 
			 function computeDimension(){
				 var numberOfDescriptors = descriptions.length ;
				 
				//Global width of the graph including margin
				 var globalWidth = null;
				 
				 //-margin
				 //Area of drawing
				 var areaWidth = $("#historyGraph").width() - 20;
				 var areaHeight = $("#historyGraph").height() - 20;
				 
				 
				 //width of one descriptor
				 var widthDesc = parseInt(areaWidth*0.2);
		
				 
				 //Set a minimum Size, re-compute old var
				 if ( widthDesc < 100){
					 widthDesc = 100;
//					 widthRemainingItemBlock = 100;
				 }
				 
				 //Width of the entire descriptor block
				 var widthDescBlock  = widthDesc*numberOfDescriptors;
				 //width of arrows between descriptors
				 var widthArrow = parseInt(widthDesc/2);
				 
				 var widthItemBlock = widthDesc + widthArrow;
		
				 widthDescBlock += numberOfDescriptors*widthArrow + widthArrow;
				 
				 //Set the global dimension of the graph
				 globalWidth =  widthDescBlock + widthItemBlock + 20 + widthArrow/2;
				 
				 var posTitleSubY = 30;
				 //Position of the Description title ( subDescritpion between description and remaining Items )
				 var posTitleSubX = 10+(widthDescBlock/2) - 15;
				//Position of the remaining Items title 
				 var posTitleSubX2 = 10 + widthDescBlock + widthItemBlock/2 - 15;
				 //Position Y of the descriptors
				 var posDescriptorY = posTitleSubY + 30;
				 //Position Y of the arrows between descriptors
				 var posArrowY = posDescriptorY + 15;
				//Position Y of the arrows between descriptor and discarded Items
				 var posArrowDiscardedItem = posDescriptorY + 50;
				 
				 var heightArrowDiscardedItem = 50;
				 //Position Y of the discarded Items title
				 var posDiscardedItemsTitleY = posArrowDiscardedItem + heightArrowDiscardedItem + 5;
				 //Font size + 10 margin top/bottom
				 var heightDiscardedItemsTitle = 34;
				 //
				 var posRectDiscardedItems = posDiscardedItemsTitleY + heightDiscardedItemsTitle + 15;
				 
				 var dim = {
					w : globalWidth,
					areaW : areaWidth,
				 	areaH : areaHeight,
				 	wdb : widthDescBlock,
				 	wrib : widthItemBlock,
				 	wd : widthDesc,
				 	wa : widthArrow,
				 	hdit : heightDiscardedItemsTitle,
				 	posRy : posRectDiscardedItems,
				 	posDTy : posDiscardedItemsTitleY,
				 	posTy : posTitleSubY,
				 	posTx : posTitleSubX,
				 	posTx2 : posTitleSubX2,
				 	posDy : posDescriptorY,
				 	posAy : posArrowY,
				 	posAIy : posArrowDiscardedItem,
				 	hai : heightArrowDiscardedItem
				 };
				 return dim;
			 }
			
		}
		
		String.prototype.splice = function( idx, rem, s ) {
		    return (this.slice(0,idx) + s + this.slice(idx + Math.abs(rem)));
		};
		
		
		
		/**
		 * Find a property in an array of jQuery element
		 * @param ArrayOfJqObject
		 * @param strElement
		 * @param value
		 * @returns
		 */
		function findElementInjQueryArray(ArrayOfJqObject,strProperty,value) {

		    for (var i = 0; i < ArrayOfJqObject.length; i++) {

		        if ($(ArrayOfJqObject[i]).attr(strProperty) === value)
		            return ArrayOfJqObject[i]; // Return as soon as the object is found

		    }
		    return null; // The object was not found
		}
		
		
		/**
		 * Fire requestAnimationFrame ( loop on render() function )
		 */
		function beforePaint() {
	        if ( oldsafari ) {
	        	// vieux safari degueux !
	        	setInterval(beforePaint,1000);
	        } else {
	        	requestAnimationFrame( beforePaint );
	        }
        	
	
	        resizeMkey();
		}
		
		function loadingMessage(toggle){
			if ( toggle == "open" ){
				if ( !$("#wait-message").dialog("isOpen") ){
					$("#wait-message").dialog("open");
				}
			}
			else{
				if ( $("#wait-message").dialog("isOpen") ){
					$("#wait-message").dialog("close");
				}
			}
		}
		
	
		// vrolland 21/07/2014
		function loadEndIdentification() {			
			remainingItems = mkey.getRemainingItems();
			$("#preIdentificationSubmitMessage .modal-body").html("<ul class='unstyled'></ul>");
			
			
			$.each(remainingItems,function(){
				var item = this;
				var itemHTML = $("<li indexDel='-1' class='remainingEndList' title='"+mkey.mkeyLang.getMessage("message_remainingItem")+"' id=finalI"+item.id+"><span></span> "+item.name+"</li>");
				
				if( $.inArray(item.id,itemsSelectedForSubmission) != -1 ) {
					$("#preIdentificationSubmitMessage .modal-body ul").append(itemHTML);
					itemHTML.find( "span" ).html('<img src="./img/bg-state-checked.png" alt="Picked" />');
					itemHTML.addClass('finalTaxaSelected');
				}
			});
			
			$('#nbItemsChosen').text(itemsSelectedForSubmission.length);
			
		};
		// end vrolland ---		
		
		// vrolland 21/07/2014
		$(".duringIdentificationButton").click(function(){
			createEndIdentification(remainingItems);
		});
		
		$(".finalSubmitIdentification").click(function(){
			var urlimagetosend = 'none';
			if(itemsSelectedForSubmission.length == 0) {
				alert(mkey.mkeyLang.getMessage("message_selectonetaxon"));
				return false;
			} 
			if(Mkey.prototype.getURLAnchorParameter('sessionid') == null) {
				alert(mkey.mkeyLang.getMessage("message_warning_nosessionid"));
				return false;
			}
			
			if (mkey.img_hasbeen_changed) {
				urlimagetosend = Mkey.prototype.getURLImageUser();
			}
			
			// todo todo todo todo999
			$.ajax({
				url : mkey.webserviceURL + '/xperience/addrecord',
				data : { 	
					sddversion : mkey.sddFileVersion,
					sessionid : Mkey.prototype.getURLAnchorParameter('sessionid'),
					itemsselected : Mkey.prototype.getJSONItemsSelected(),
					history : Mkey.prototype.getJSONDescriptions(),
					urlimageuser : urlimagetosend
				},
				method : 'GET',
				dataType : 'jsonp',
				success : function(code_json, statut){
				   if(code_json.status == "ok") {
						// show the finnish Message
						$("#finalIdentificationSubmitMessage").modal("show");
				   } else {
					   alert(mkey.mkeyLang.getMessage("message_errorduringsubmit") + ": '"+code_json.value.message+"'" );
				   }		   					   
			   },
			   error : function(resultat, statut, erreur){
				   alert(mkey.mkeyLang.getMessage("message_errorduringsubmit") + ": '"+statut+"'" );
			   }
			});
			
		});
		
		// -- end vrolland 			

		
		Mkey.initProto = true;
		
	}
	
	window.mkey = new Mkey(NsddFileURL,NwebserviceURL,interfaceType,NxperienceUniqueid);
	mkey.mkeyReady(function(){
		//Init the Mkey interaction File
		

		if ( typeof initMkeyInteraction == "function" ){
			initMkeyInteraction();
		}
		
		if ( mkey.askForSDD ){
			$("#sddLoad").modal("show");
		}
	});
}
