(function(){
	"use strict";
	var $ = jQuery;
	// Create variables (in this scope) to hold the API and image size
	var boundx,
	previewDisplay=false,
	$bigImg = $("<div id='spiBigImg'><img /></div>"),
	boundy;
	window.jcrop_api = undefined;    
	
	function init(){
		$bigImg.appendTo("body");
		// Grab some information about the preview pane
	//	var $preview = $('#preview-pane'),
		var $pcnt = $('#preview-pane .preview-container'),
		$pimg = $('#preview-pane .preview-container img'),
		
		xsize = $pcnt.width(),
		ysize = $pcnt.height();
		
		$('#image-container .target').Jcrop({
		    onChange: updatePreview,
		    onSelect: updatePreview,
		    onRelease : closePreview,
		    aspectRatio: 4 / 3,
		    boxWidth: $("#additionalInformation").width(), 
	//	    boxHeight: 300,
	//	    aspectRatio: 1,
		    allowResize: true,
		    allowMove: true,
		    bgOpacity: .4
		},function(){
	//		$(".jcrop-holder").css("width","100%");
	//		$(".jcrop-tracker").css("width","100%");
	//		$(".jcrop-holder img").css("width","100%");
		    // Use the API to get the real image size
		    var bounds = this.getBounds();
		    boundx = bounds[0];
		    boundy = bounds[1];
		    // Store the API in the jcrop_api variable
		    jcrop_api = this;
	
		});
	
		function updatePreview(c){
	
			if (parseInt(c.w) > 0){
				var rx = xsize / c.w;
				var ry = ysize / c.h;
		
				$pimg.css({
					width: Math.round(rx * boundx) + 'px',
					height: Math.round(ry * boundy) + 'px',
					marginLeft: '-' + Math.round(rx * c.x) + 'px',
					marginTop: '-' + Math.round(ry * c.y) + 'px'
				});
		       $('#x').val(c.x);
		       $('#y').val(c.y);
		       $('#w').val(c.w);
		       $('#h').val(c.h);
			}
	 	
			if ( !previewDisplay ){
				displayPreview();
				$("#form-container").fadeIn(function(){
//					mkey.updateInterfaceDimension();
				});
			}
		}
		
		
	
	}
	 
	
	function displayPreview(){
		//Compute the absolute position where the pane should be displayed
		var pos = $(".jcrop-holder").offset();
		var prev = $("#preview-pane-all");
	//	var prev = $("#preview-pane");
		var h,w;
		if (pos.left > prev.width()){	
			h = pos.top + 20;
			w = pos.left - prev.width()*0.95;
		}
		else{
			h = pos.top + 20;
			w = pos.left + $(".jcrop-holder").width() - prev.width()*0.95;
		}
		$("#preview-pane-all").css("top",h);
		$("#preview-pane-all").css("left",w);
		if ( !previewDisplay ){
			$("#preview-pane-all").fadeIn();
			previewDisplay = true;
		}
	}
	
//	function resizePreview(){
//		var prev = $("#preview-pane-all");
//	//	var prev = $("#preview-pane");
//		var pos = $("#image-container").offset();
//		var h,w;
//		if (pos.left > prev.width()){	
//			h = pos.top + 20;
//			w = pos.left - prev.width()*0.95;
//		}
//		else{
//			h = pos.top + 20;
//			w = pos.left + $(".jcrop-holder").width() - prev.width()*0.95;
//		}
//		$("#preview-pane-all").css("top",h);
//		$("#preview-pane-all").css("left",w);
//	}
	
	function closePreview(){
		previewDisplay = false;
		$("#preview-pane-all").css("display","none");
		$("#form-container").css("display","none");
	}
	
	
	//vrolland 23/07/14
	Window.prototype.LoadImageFromUrl = function(ImageUserFromURL){
		jQuery.ajax({ 
			type : "GET", 
			url : "php/copy_image.php?ImageUserFromURL="+ImageUserFromURL,
			cache : false,
			contentType : false,
			dataType : "html",
			success : function(data) {
				if(data != "Invalid url" && data != "Invalid file") {
					$(".image-container").empty();
					$(".image-container").append(data);
		
					reloadCrop();
					$('.reset-load-image').toggle();
					$('.sendImageForm').css("display","none");
				
		 		return true;
				} else {
					return false; 
				}
			},
			error : function(data) {
				return false;
			}
		});
		return true;
	};		
	// end vrolland
	
	Window.prototype.loadImage = function(highlight){
		var dataSend = new FormData();
		var fileid =  '#file';
		if(highlight) {
			fileid =  '#file-hightlighted';
		}
		dataSend.append('file', $(fileid)[0].files[0]);
		jQuery.ajax({ // ajax request
			type : "POST", // send in POST
			url : "php/upload_image.php", // url target
			async : true, // asynchrone mode
			cache : false,
			contentType : false,
			processData : false,
			data : dataSend, // data send
			dataType : "html",// "html", //JSON
			success : function(data) { // on PHP response
				$(".image-container").empty();
				$(".image-container").append(data);
	//			jQuery("#image-container").html(data);
	
				reloadCrop();
				$('.reset-load-image').toggle();
				$('.sendImageForm').css("display","none");

				mkey.img_hasbeen_changed = true;

				
		 		return true;
			}, // success
			error : function(data) {
	//			jQuery("#humanReadableConsoleTextBlock").empty();
	//			jQuery("#humanReadableConsoleTextBlock").append("<span class='error_consol'>An Error occured, check the image file or contact ###</span><br />");
	//			jQuery("#humanReadableConsoleTextBlock").append("<span class='warning_consol'>Image filename should : <br /> -not contained any points exepte for the extension <br /> -size lesser than 3Mo</span>");
				return false;
			}
		});
		return true;
	};
	
	Window.prototype.crop = function(){
		closePreview();
		var dataSend = new FormData();
		dataSend.append('h_s',$("#image-container .target").height());
		dataSend.append('w_s',$("#image-container .target").width());
		dataSend.append('x', $('#x').val());
		dataSend.append('srcI', $('#image-container .target').attr("src"));
		dataSend.append('y', $('#y').val());
		dataSend.append('h', $('#h').val());
		dataSend.append('w', $('#w').val());
		jQuery.ajax({ // ajax request
			type : "POST", // send in POST
			url : "php/crop.php", // url target
			async : true, // asynchrone mode
			cache : false,
			contentType : false,
			processData : false,
			data : dataSend, // data send
			dataType : "html",// "html", //JSON
			success : function(data) { // on PHP response
				jQuery("#image-container").html(data);
				reloadCrop();
				
				mkey.img_hasbeen_changed = true;		
				
		 		return true;
			}, // success
			error : function(data) {
				alert("[Warning] the webservice doesn't response to this data.");
	//			document.getElementById('resultezone').innerHTML = '<b>ERROR</b>';
				return false;
			}
		}); // ajax
		return true;
	};
	
	
	function reloadCrop(){
		$('#previewImage').attr('src',$('#image-container .target').attr('src'));
		init();
	}
	
	$(document).ready(function(){
		
		//Override the Click function 
		$("body").click(function(e){
			if ( jcrop_api != undefined && !$(window.event.srcElement).hasClass("jcrop-tracker") ){
				jcrop_api.release();
			}
		});
		
		$("#image-container").mouseover(function() {
			if ( $bigImg != undefined &&  !previewDisplay && $('.reset-load-image').css("display") != "none")
			$bigImg.css("display","block");
			$bigImg.find("img").attr('src',$('#image-container .target').attr('src'));
			
			var pos = $(".jcrop-holder").offset();
			if ( pos != undefined ){
			//	var prev = $("#preview-pane");
				var h,w;
				if ( pos.left > $bigImg.width()){	
					h = pos.top + 20;
					w = pos.left - $bigImg.width()*0.95;
				}
				else{
					h = pos.top + 20;
					w = pos.left + $(".jcrop-holder").width() - $bigImg.width()*0.95;
				}
				$bigImg.css("top",h);
				$bigImg.css("left",w);
			}
			
		  })
		  .mouseout(function() {
			  $bigImg.css("display","none");
		  });
		
		$(".reset-load-image").click(function(){
			$(".image-container").empty();
			$(".image-container").append('<img id="target" src="./img/defaultThumbnail.png" alt="image" style="width: 100%;"/>');
			$('.reset-load-image').fadeOut();
			$('.sendImageForm').css("display","block");
			$("#file").val('');
			closePreview();
		});
		
		
		$("#preview-pane-all").css("display","none");
			
	});
})();
