/**
 * Antoine Bergamaschi
 * To Use mkey_lang, message need to be place in <span> (recommended) or other DOM having the class
 * "message" and with a "data-message" parameter corresponding to on of the different global message variable.
 * 
 * For Tooltips use the class "messageTooltip" and "data-message" parameter
 * 
 * For Button use the class "messageBtn" and "data-message" parameter
 */

function MkeyLang(){
	"use strict";
	var $ = jQuery;
	
	var currentLang = "";
	
	//Set Message Here, "message_*" is the unique name of the message, add lang fr and en
	var messages = {
		index : {
			//Default value is English (see setLang(str) after to set other languages)
			"message_descriptors" : {en:"Descriptors",fr:"Descripteurs"},
			"message_items" : {en:"Taxa", fr:"Taxons"},
			"message_history" : {en:"History",fr:"Historique"},
			"message_filename" : {en:"File name",fr:"Nom du fichier"},
			"message_submit" : {en:"Submit",fr:"Envoyer"},
			"message_reset_submit" : {en:"Unselect",fr:"Déselectionner"},
			"message_remainingItems" : {en:"Remaining taxa (species, group of species...)",fr:"Taxons restants (espèces, groups d’espèces...)"},
			"message_remainingItems_mobile" :{en:"Remaining taxa",fr:"Taxons restants"},
			"message_console" : {en:"Console",fr:"Console"},
			"message_fullScreen" : {en:"Full screen",fr:"Plein écran"},
			"message_validate" : {en:"Confirm",fr:"Valider"},
			"message_yes" : {en:"Yes",fr:"Oui"},
			"message_no" : {en:"No",fr:"Non"},
			"message_reset" : {en:"Reset",fr:"Réinitialiser"},
			"message_close" : {en:"Close",fr:"Fermer"},
			"message_among" : {en:"Among",fr:"Parmi"},
			"message_remainingSpecies" : {en:"Remaining taxa",fr:"Taxons restants"},
			"message_delete" : {en:"Delete",fr:"Supprimer"},
			"message_sendIdentification" : {en:"Submit this identification",fr:"Soumettre cette identification"},
			"message_gotoendIdentification" : {en:"Finish this identification",fr:"Finir cette identification"},
			"message_cancel" : {en:"Cancel",fr:"Annuler"},
			"message_similarity" : {en:"Other taxa which might fit your description",fr:"Autres taxons qui pourraient correspondre à votre description"},
			"message_resourcesDisplay" : {en:"Linked resources", fr:"Illustrations liées"},
			"message_selection" : {en:"Current selection :", fr:"Sélection actuelle :"},
			"message_noDescriptor_1" : {en:"There are no descriptors left", fr:"Il ne reste plus de descripteurs"},
			"message_noDescriptor_2" : {en:"Check your results in the remaining taxa panel", fr:"Consultez les résultats dans le panneau des taxons restants"},
			"message_noDescriptor_21" : {en:"Here",fr:"Ici"},
			"message_noDescriptor_3" : {en:"Reset and restart", fr:"Réinitialiser et recommencer"},
			"message_noDescription_1" : {en:"There is no description yet", fr:"Il n'y a pas de description pour le moment"},
			"message_noDescription_2" : {en:"Add a new description in the descriptors panel", fr:"Ajouter une nouvelle description dans le panneau des descripteurs"},
			"message_noDescription_3" : {en:"Go to the descriptors panel", fr:"Aller au panneau des descripteurs"},
			"message_noRemainingItem_title" : {en:"No taxon identified", fr:"Pas de taxon identifié"},
			"message_noRemainingItem_body" : {en:"The submitted descriptions do not match any taxa in the base.<br /> Please consider resetting or changing the submitted description.",
				fr:"La description soumise ne correspond à aucun taxon de la base.<br /> Veuillez recommencer ou modifier votre description."},
			"message_noRessources" : {en:"No ressources linked to this taxon",fr:"Aucune illustration n'est lié à ce taxon"},
			"message_clicktoview" : {en:"Click on this image to view all ressources", fr:"Cliquer sur cette image pour voir toutes les illustrations associées"},
			"message_end_detail_taxon" : {en:"Descriptive sheet of the selected taxon",fr:"Fiche descriptive du taxon sélectionné"},
			//		"message_showdiff" : {en:"",fr:""},
			"message_hightlightedDescriptor_subTitle" :{en:"Click on one or more state",fr:"Cliquer sur un ou plusieur(s) état(s)"},
			"message_hightlightedDescriptor_TitlePict" :{en:"Picture of your speciment :",fr:"Photo de votre spécimen :"},
			"message_returnHistorique" : {en:"Change identification", fr:"Changer l'historique"},
			"message_submission" : {en:"Submit", fr:"Soumettre"},
			"message_chooseItems" : {en:"Choose Items", fr:"Choisir les taxons"},
			// "message_goToSpipollForm" : {en:"To submit your identification, please go to the <a target='_blank' href='http://www.spipoll.org/mon-spipoll/creer-une-collection'>CRÉER UNE COLLECTION</a> form and select the appropriate taxon in the dropdown list.", fr:"Afin de soumettre votre identification, merci de bien vouloir compléter le formulaire <a target='_blank' href='http://www.spipoll.org/mon-spipoll/creer-une-collection'>CRÉER UNE COLLECTION</a> en selectionnant le taxon identifié dans la liste déroulante."},
			// vrolland modify to select several taxa
			"message_goToSpipollForm" : {en:"You can go back to <a target='_blank' href='http://www.spipoll.org/mon-spipoll/creer-une-collection'>Spipoll collection form</a>, the taxa will be automatically picked up.", fr:"Vous pouvez retourner sur <a target='_blank' href='http://www.spipoll.org/mon-spipoll/creer-une-collection'>le formulaire de collection Spipoll</a>, les taxons seront selectionnés automatiquement."},
			"message_endIdentification" : {en:"Finnish",fr:"Finaliser"},
			"message_selectonetaxon" : {en:"You have to select at least one taxon",fr:"Vous devez choisir au moins un taxon"},
			"message_errorduringsubmit" : {en:"Error during the submission",fr:"Erreur pendant la soumission"},
			// end vrolland
			"message_unknown" : {en:"Unknown", fr:"Donnée inconnue"},
			"message_inapplicable" : {en:"Inapplicable", fr:"Inapplicable"},
			"message_notDescribed" : {en:"Not described", fr:"Non décrit"},
			"message_remaining" : {en:"Remaining", fr:"Conforme"},
			"message_discarded" : {en:"Discarded", fr:"Eliminé"},
			"message_reportProblem" : {en:"Report a problem", fr:"Signaler un problème"},
			"message_limit10taxa" : {en:"You cannot choose more than 10 taxa : ", fr:"Vous ne pouvez choisir que 10 taxons maximum : "},
			"message_picked" : {en:"picked", fr:"choisis"},
			
			//Warning Description
			"message_warning_deleteDescription" : {en:"Warning : if the following descriptions depend on this description, the deletion will also destroy subsequent descriptions",
				fr:"Attention : si les descriptions suivantes sont dépendantes de cette description, la suppression détruira également les descriptions restantes"},
			"message_warning_changeDescription" : {en:"Warning : Modifying descriptions can change the result of the next description",
				fr:"Attention : Modifier cette description peut entraîner la modification des descriptions restantes"},
			"message_warning_waitLoading_1" : {en:"Please wait while the SDD is loading",fr:"Veuillez attendre le chargement du SDD"},
			"message_warning_waitLoading_2" : {en:"The loading can take a few minutes",fr:"Le chargement peut prendre quelques minutes"},
			"message_warning_closeMkey" : {en:"Leaving this page will reset your identification",fr:"Quitter cette page réinitilisera votre identification"},
			"message_warning_resetIdentification" : {en:"Are you sure you want to reset the identification ?",fr:"Etes-vous sûre de vouloir réinitialiser l'identification ?"},
			
			//Error message
			"message_error_reload_1" :{en:"Please reload this page",fr:"Veuillez actualiser la page"},
			"message_error_reload_2" :{en:"Initialization failed",fr:"Echec de l'initialisation"},
			"message_error_upload_1" :{en:"Please try again to upload this file",fr:"Veuillez charger le fichier de nouveau"},
			"message_error_upload_2" :{en:"Uploading file failed",fr:"Echec du chargement du fichier"},
			"message_error_loadDescription_1" :{en:"Corrupted description",fr:"Description corrompue"},
			"message_error_loadDescription_2" :{en:"Loading description failed",fr:"Echec du chargement de la description"},
			"message_error_server_1" :{en:"Server busy or offline",fr:"Serveur occupé ou hors ligne"},
			"message_error_server_2" :{en:"Mkey Web Service cannot be connected",fr:"Le Web Service mkey ne peut pas être connecté"},
			"message_warning_nosessionid" : {en:"Nothing will be submit because there is no 'sessionid' given.",fr:"Rien ne sera soumis car le parametre 'sessionid' n'est pas renseigné."},
			
			
			//Button message
			"message_crop" : {en:"Crop image",fr:"Recadrer l'image"},	
			"message_send" : {en:"Send",fr:"Envoyer"},
			"message_continue" : {en:"Continue",fr:"Continuer"},
			
			//Tooltip HELP message
			"message_helpCrop" : {en:"Click and drag on your image to crop your selection",fr:"Cliquez et faites glisser votre curseur pour recadrer l’image "},
			"message_helpEraseImg" : {en:"Erase the image",fr:"Effacer l'image"},
			"message_helpFirstStep" : {en:"Click to see a descriptors available states",fr:"Cliquez sur un descripteur pour afficher les états disponibles"},
			"message_helpReset" : {en:"Reset the identification",fr:"Réinitialiser l'identification"},
			"message_helpReset_submit" : {en:"Cancel every selected states of the current descriptions (not yet submited)",
				fr:"Annule tous les états cochés de la description courante (non soumis)"},
			"message_helpChart" : {en:"Discriminant power scale, dark green (very discriminant) to white (non-discriminant)",fr:"Echelle de pouvoir discriminant, du vert foncé (très discriminant) au blanc (non  discriminant)"},
			"message_helpDelete" : {en:"Delete this description (Warning : if the following descriptions are dependant of this description, the deletion will destroy also subsequent descriptions)",
				fr:"Supprimer cette description (Attention : si les descriptions suivantes sont dépendantes de cette description, la suppression annulera également les descriptions restantes)"},
			"message_helpChangeDescription" : {en:"Change this description (Warning : Modifying descriptions can change the next result of the next description)",
				fr:"Changer cette description (Attention : Modifier cette description peu entraîner la modification des descriptions restantes)"},
			"message_HelpSendIdentification" : {en:"Send this identification to my Spipoll collection for curating and saving",
				fr:"Envoyer cette identification dans ma collection Spipoll pour sa validation et sa sauvegarde"},
			"message_helpSelectItem" : {en:"Search a specific taxon", fr:"Chercher un taxon en particulier"},	
			"message_helpSelectDescriptor" : {en:"Search a specific descriptor", fr:"Chercher un descripteur particulier"},
			"message_helpShowDiff" : {en:"Display the differences between the submitted description and the taxon’s description\n" +
					"Icone '+' and color blue means this state is additional in the submitted description,\n" +
					"Icone '-' and color red means this state is additional in the taxon's description,\n" +
					"Icone 'v' and color green means this state is the same in both cases,\n" +
					"Icone '*' and black means this parent desciptor has not been described",
					fr:"Affiche les différences entre la description soumise et la description de ce taxon.\n" +
					"l'icone '+' et la couleur bleue indiquent que vous avez renseigné l'état dans votre description mais qu'il n'apparait pas dans la fiche descriptive du taxon,\n" +
					"l'icone '-' et la couleur rouge indiquent que l'état existe mais que vous ne l'avez pas renseigné dans votre description,\n" +
					"l'icone 'v' et la couleur verte indiquent que l'état a été renseigné aussi bien dans votre description que dans la fiche descriptive du taxon,\n" +
					"l'icone '*' et de couleur noire indiquent que vous n'avez pas renseigné le descripteur associé à cet état"},
			"message_helpShowMoreDescriptor" : {en:"Show additional descriptor",fr:"Afficher des descripteurs supplémentaires"},
			"message_helpOpenInNewWindow" : {en:"Open in a new window",fr:"Ouvrir dans une nouvelle fenêtre"},
			
			//Tooltip About message
			"message_aboutDescriptors":{en:"The list of descriptors currently available. Only discriminant descriptors are shown, sorted by decreasing discriminant power.",
				fr:"Affiche la liste des descripteurs actuellement disponibles. Les descripteurs sont affichés du plus discriminant au moins discriminant."},
			"message_aboutHistory":{en:"The identification history in which each description can be edited or removed.",fr:"Affiche l'historique d'identification dans lequel toutes les descriptions peuvent être éditées ou supprimées."},	
			"message_aboutRemainingItems":{en:"The list of remaining and discarded taxa with a match percentage (shown in green) in between your description and discarded taxa.",fr:"Affiche la liste des taxons restants et éliminés (barré) avec un pourcentage de correspondance (en vert) entre votre description et le taxon éliminé."},
			
			//Other Tooltip
			"message_remainingItem":{en:"Item corresponding to the description",fr:"Item correspondant à la description"},
			"message_eliminatedItem":{en:"correspondence with description",fr:"de correspondance avec la description"},
			"message_helpParameter" :{en:"Parameter",fr:"Paramètre"},
			"message_descriptionNegative" : {en:"This state belongs to this item but isn't in the identification description",
				fr:"Cet état appartient à cette item, mais n'est pas dans la description de l'identification"},
			"message_descriptionEgal" : {en:"This state belongs both in the identification and item description",fr:"Cet état appartient à la fois à l'identification et la description de l'item"},
			"message_descriptionAddition" : {en:"This state belongs to the identification description but isn't in the item description",
				fr:"Cet état appartient à la description de l'identification, mais n'est pas dans la description de l'item"},
			
			
			//Modal configuration
			"message_parameter" : {en:"Parameters",fr:"Paramètres"},
			"message_sddSubmit" : {en:"Submit SDD",fr:"Soumettre un SDD"},
			"message_kbSubmit" : {en:"Submit a knowledge base in SDD format",fr:"Soumettre une base de connaissance au format SDD"},
			"message_changeDescriptorNumb" : {en:"Change the number of displayed descriptors",fr:"Changer le nombre de descripteurs affichés"},
			"message_numberOfDescriptor" : {en:"Number of displayed descriptors",fr:"Nombre de descripteurs affichés"},
			"message_changeStatesNumb" : {en:"Change the number of displayed states",fr:"Changer le nombre d'états affichés"},
			"message_numberOfState" : {en:"Number of displayed states",fr:"Nombre d'états affichés"},
			"message_changeDimPrincipalStat" : {en:"Change the size of the main state picture (for the <em>display row design</em> only)",fr:"Changer la taille de l’illustration de l'état principal (pour le <em>display row design</em>)"},
			"message_dimPrincipalStat" : {en:"Principal state pictures size",fr:"Taille de l’illustration de l'état principal"},
			"message_changeUI" : {en:"Change UI",fr:"Changer d'UI"},
			"message_displayDiscPow" : {en:"Display discriminant power for each descriptor",fr:"Afficher le pouvoir discriminant de chaque descripteur"},
			"message_displayDiscPowGraph" : {en:"Display discriminant power graphically",fr:"Afficher le pouvoir discriminant graphiquement"},
			"message_displayRemItemNumb" : {en:"Display the number of remaining taxa",fr:"Afficher le nombre de taxons restants"},
			"message_displayRemItemNumbGraph" : {en:"Display graphically the number of remaining taxa",fr:"Afficher le nombre de taxons restants graphiquement"},
			"message_rowDesign" : {en:"Row Design",fr:"Row design"},
			"message_rowDesignSquare" : {en:"Row Design + square design",fr:"Row design + square design"},
			"message_defaultDesign" : {en:"Default design",fr:"Design par défaut"},
			"message_sddFile" : {en:"SDD File",fr:"Fichier SDD"},
			"message_changeLang" : {en:"Change language",fr:"Changer de langue"},
			"message_onlyPositiveScore" : {en:"Show only discriminating descriptors",fr:"Afficher uniquement les descripteurs discriminants"},
			"message_showEndIdentification" : {en:"Show the end of identification interface",fr:"Afficher l'interface de fin d'identification"},
			"message_changeOption" : {en:"Change options",fr:"Changer les options"},
			"message_serverName" : {en:"Mkey+ Server :",fr:"Serveur Mkey+ :"},
			"message_currentSddName" : {en:"Current sdd url :",fr:"Url du sdd courant :"},
			"message_numberOfItems" : {en:"Number of taxa :",fr:"Nombre de taxons :"},
			"message_numberOfDescriptors" : {en:"Number of descriptors :",fr:"Nombre de descripteurs :"},
			"message_information" : {en:"Information",fr:"Information"},
			"message_showStateWhitoutTaxon" : {en:"Show undiscriminating state",fr:"Afficher les états non discriminant"}
		},
		get : function(message_name){
			if ( this.index[message_name] != undefined ){
				return this.index[message_name]
			}
			return "No message detected";
		}
	};
	
	
	
	//Add the startsWith function (used to get automatically every message
	if (typeof String.prototype.startsWith != 'function') {
		  String.prototype.startsWith = function (str){
		    return this.slice(0, str.length) == str;
		  };
	}
	
	if (typeof MkeyLang.initProto == "undefined" ){
		
		MkeyLang.prototype.setLang = function(lang){
			var Llang = lang.toLowerCase();
			
			if ( Llang != currentLang ){
				switch ( Llang ){
					case "fr":
						currentLang = "fr";
						break;
					case "en":
						currentLang = "en";
						break;
					default:
						return false;
						break;
				}
				return true;
			}
			return false;
		};
		
		
		MkeyLang.prototype.updateLang  = function(selectorStr){
			var selector = "";
			if ( selectorStr != undefined ){
				selector = selectorStr;
			}
			//Message not embded in title
			$.each($(selector+" .message"),function(index){
				//Empty the old message
				$(this).empty();
				//get the global variable in the window context and set it
				switch ( currentLang ){
					case "fr":
						$(this).append(messages.get($(this).attr("data-message")).fr);
						break;
					case "en":
						$(this).append(messages.get($(this).attr("data-message")).en);
						break;
				}	
			});
			//Message embded in Tooltip title
			$.each($(selector+" .messageTooltip"),function(index){
				//get the global variable in the window context and set it in the original title
				switch ( currentLang ){
					case "fr":
						$(this).attr("title",messages.get($(this).attr("data-message")).fr);
						break;
					case "en":
						$(this).attr("title",messages.get($(this).attr("data-message")).en);
						break;
				}	
			});	
			//Message embded in Button value
			$.each($(selector+" .messageBtn"),function(index){
				//get the global variable in the window context and set it in the original title
		
				switch ( currentLang ){
					case "fr":
						$(this).attr("value",messages.get($(this).attr("data-message")).fr);
						break;
					case "en":
						$(this).attr("value",messages.get($(this).attr("data-message")).en);
						break;
				}	
				
			});	
			
		};
		
		MkeyLang.prototype.getMessage = function(message_id){
			var message = "";
			switch ( currentLang ){
				case "fr":
					message =  messages.get(message_id).fr;
					break;
				case "en":
					message = messages.get(message_id).en;
					break;
			}
			return message;
		};
		
		MkeyLang.prototype.changeLang = function(lang){
			if ( this.setLang(lang) ){
				this.updateLang();
			}
		};
		
		MkeyLang.initProto = true;
	}
}




